/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java.jna;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import org.hid4java.jna.HidApiLibrary;
import org.hid4java.jna.HidDeviceInfoStructure;
import org.hid4java.jna.HidDeviceStructure;
import org.hid4java.jna.HidrawHidApiLibrary;
import org.hid4java.jna.LibusbHidApiLibrary;
import org.hid4java.jna.WideStringBuffer;

public class HidApi {
    private static final int WSTR_LEN = 512;
    private static final String DEVICE_NULL = "Device not initialised";
    private static final int DEVICE_ERROR = -2;
    public static boolean useLibUsbVariant = false;
    public static boolean logTraffic = false;
    private static HidApiLibrary hidApiLibrary;

    public static HidDeviceStructure open(int vendor, int product, String serialNumber) {
        Pointer p = hidApiLibrary.hid_open((short)vendor, (short)product, serialNumber == null ? null : new WString(serialNumber));
        if (p != null) {
            return new HidDeviceStructure(p);
        }
        return null;
    }

    public static void init() {
        try {
            hidApiLibrary = useLibUsbVariant && Platform.isLinux() ? LibusbHidApiLibrary.INSTANCE : HidrawHidApiLibrary.INSTANCE;
            hidApiLibrary.hid_init();
            System.err.println("HidApi Platform.isWindows()=" + Platform.isWindows() + " hidApiLibrary=" + hidApiLibrary);
        }
        catch (Throwable throwable) {
            System.err.println("HidApi Platform.isWindows()=" + Platform.isWindows() + " error initiated");
            throwable.printStackTrace();
        }
    }

    public static void exit() {
        hidApiLibrary.hid_exit();
    }

    public static HidDeviceStructure open(String path) {
        Pointer p = hidApiLibrary.hid_open_path(path);
        return p == null ? null : new HidDeviceStructure(p);
    }

    public static void close(HidDeviceStructure device) {
        if (device != null) {
            hidApiLibrary.hid_close(device.ptr());
        }
    }

    public static HidDeviceInfoStructure enumerateDevices(int vendor, int product) {
        return hidApiLibrary.hid_enumerate((short)vendor, (short)product);
    }

    public static void freeEnumeration(HidDeviceInfoStructure list) {
        hidApiLibrary.hid_free_enumeration(list.getPointer());
    }

    public static String getLastErrorMessage(HidDeviceStructure device) {
        if (device == null) {
            return DEVICE_NULL;
        }
        Pointer p = hidApiLibrary.hid_error(device.ptr());
        return p == null ? null : new WideStringBuffer(p.getByteArray(0L, 512)).toString();
    }

    public static String getManufacturer(HidDeviceStructure device) {
        if (device == null) {
            return DEVICE_NULL;
        }
        WideStringBuffer wStr = new WideStringBuffer(512);
        hidApiLibrary.hid_get_manufacturer_string(device.ptr(), wStr, 512);
        return wStr.toString();
    }

    public static String getProductId(HidDeviceStructure device) {
        if (device == null) {
            return DEVICE_NULL;
        }
        WideStringBuffer wBuffer = new WideStringBuffer(512);
        hidApiLibrary.hid_get_product_string(device.ptr(), wBuffer, 512);
        return wBuffer.toString();
    }

    public static String getSerialNumber(HidDeviceStructure device) {
        if (device == null) {
            return DEVICE_NULL;
        }
        WideStringBuffer wBuffer = new WideStringBuffer(512);
        hidApiLibrary.hid_get_serial_number_string(device.ptr(), wBuffer, 512);
        return wBuffer.toString();
    }

    public static boolean setNonBlocking(HidDeviceStructure device, boolean nonBlocking) {
        return device != null && 0 == hidApiLibrary.hid_set_nonblocking(device.ptr(), nonBlocking ? 1 : 0);
    }

    public static int read(HidDeviceStructure device, byte[] buffer) {
        if (device == null || buffer == null) {
            return -2;
        }
        WideStringBuffer wBuffer = new WideStringBuffer(buffer);
        int result = hidApiLibrary.hid_read(device.ptr(), wBuffer, wBuffer.buffer.length);
        if (result > 0) {
            HidApi.logTraffic(wBuffer, false);
        }
        return result;
    }

    public static int read(HidDeviceStructure device, byte[] buffer, int timeoutMillis) {
        if (device == null || buffer == null) {
            return -2;
        }
        WideStringBuffer wBuffer = new WideStringBuffer(buffer);
        int result = hidApiLibrary.hid_read_timeout(device.ptr(), wBuffer, buffer.length, timeoutMillis);
        if (result > 0) {
            HidApi.logTraffic(wBuffer, false);
        }
        return result;
    }

    public static int getFeatureReport(HidDeviceStructure device, byte[] data, byte reportId) {
        if (device == null || data == null) {
            return -2;
        }
        WideStringBuffer report = new WideStringBuffer(512);
        report.buffer[0] = reportId;
        int res = hidApiLibrary.hid_get_feature_report(device.ptr(), report, data.length + 1);
        if (res == -1) {
            return res;
        }
        System.arraycopy(report.buffer, 1, data, 0, Math.min(res, data.length));
        HidApi.logTraffic(report, false);
        return res;
    }

    public static int sendFeatureReport(HidDeviceStructure device, byte[] data, byte reportId) {
        if (device == null || data == null) {
            return -2;
        }
        WideStringBuffer report = new WideStringBuffer(data.length + 1);
        report.buffer[0] = reportId;
        System.arraycopy(data, 0, report.buffer, 1, data.length);
        HidApi.logTraffic(report, true);
        StringBuilder keyData = new StringBuilder();
        for (byte b : data) {
            keyData.append(String.format("%01x", b));
        }
        System.out.println("hid sent: length=" + report.buffer.length + " data [" + keyData + "]");
        keyData = new StringBuilder();
        for (byte b : report.buffer) {
            keyData.append(String.format("%01x", b));
        }
        System.out.println("hid sent: length=" + report.buffer.length + " report [" + keyData + "]");
        return hidApiLibrary.hid_send_feature_report(device.ptr(), report, report.buffer.length);
    }

    public static int write(HidDeviceStructure device, byte[] data, int len, byte reportId) {
        if (device == null || data == null) {
            return -2;
        }
        if (data.length < len) {
            len = data.length;
        }
        WideStringBuffer report = new WideStringBuffer(len + 1);
        report.buffer[0] = reportId;
        if (len >= 1) {
            System.arraycopy(data, 0, report.buffer, 1, len);
        }
        HidApi.logTraffic(report, true);
        return hidApiLibrary.hid_write(device.ptr(), report, report.buffer.length);
    }

    public static String getIndexedString(HidDeviceStructure device, int idx) {
        if (device == null) {
            return DEVICE_NULL;
        }
        WideStringBuffer wStr = new WideStringBuffer(512);
        int res = hidApiLibrary.hid_get_indexed_string(device.ptr(), idx, wStr, 512);
        return res == -1 ? null : wStr.toString();
    }

    private static void logTraffic(WideStringBuffer buffer, boolean isWrite) {
        if (logTraffic && buffer != null && buffer.size() > 0) {
            if (isWrite) {
                System.out.print("> ");
            } else {
                System.out.print("< ");
            }
            System.out.printf("[%02x]:", buffer.buffer.length);
            for (byte b : buffer.buffer) {
                System.out.printf(" %02x", b);
            }
            System.out.println();
        }
    }
}

