/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.graphics;

import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.graphics.BitmapImage;
import java.nio.ByteBuffer;
import javafx.geometry.Dimension2D;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public final class CursorImage
extends BitmapImage<Image> {
    private static final PixelFormat<ByteBuffer> PIXEL_FORMAT = PixelFormat.getByteBgraInstance();

    public static Image toToolkit(Bitmap bitmap) {
        return (Image)new CursorImage(bitmap).toolkitImage();
    }

    private CursorImage(Bitmap bitmap) {
        super(bitmap);
    }

    protected Image createImage() {
        WritableImage cursorImage = this.createWritableImage();
        this.drawCursor(cursorImage);
        return cursorImage;
    }

    private Size preferredSize() {
        Dimension2D bestCursorSize = ImageCursor.getBestSize((double)this.width(), (double)this.height());
        int preferredWidth = (int)bestCursorSize.getWidth();
        int preferredHeight = (int)bestCursorSize.getHeight();
        return Size.of((int)preferredWidth, (int)preferredHeight);
    }

    private WritableImage createWritableImage() {
        WritableImage cursorImage;
        Size preferredSize = this.preferredSize();
        int width = this.width();
        int height = this.height();
        if (Environment.isWindows()) {
            int maxWidth = Math.max(width, preferredSize.width());
            int maxHeight = Math.max(height, preferredSize.height());
            cursorImage = new WritableImage(maxWidth, maxHeight);
        } else {
            cursorImage = new WritableImage(width, height);
        }
        return cursorImage;
    }

    private void drawCursor(WritableImage cursorImage) {
        byte[] pixels = this.bitmap().pixels();
        PixelWriter writer = cursorImage.getPixelWriter();
        int width = this.width();
        int height = this.height();
        writer.setPixels(0, 0, width, height, PIXEL_FORMAT, pixels, 0, width * 4);
    }

    private Size size() {
        return this.bitmap().size();
    }

    private int width() {
        return this.size().width();
    }

    private int height() {
        return this.size().height();
    }
}

