/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.window;

import com.teamdev.jxbrowser.os.Environment;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.control.Tooltip;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.Window;

final class BeaconWindow {
    private static final int MAX_ORIGIN = 100;
    private static final int MIN_SIZE = 50;
    private static final int MAX_SIZE = 100;

    private BeaconWindow() {
    }

    static Optional<Long> findOwnerId(Window owner) {
        Rectangle2D bounds = BeaconWindow.generateBounds();
        Tooltip tooltip = BeaconWindow.createTooltip(bounds);
        tooltip.show(owner, bounds.getMinX(), bounds.getMinY());
        return BeaconWindow.findOwnerId(bounds);
    }

    private static Optional<Long> findOwnerId(Rectangle2D bounds) {
        long ownerId = BeaconWindow.findOwnerByBounds((int)bounds.getMinX(), (int)bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        return ownerId == 0L ? Optional.empty() : Optional.of(ownerId);
    }

    private static Tooltip createTooltip(Rectangle2D bounds) {
        Tooltip tooltip = new Tooltip();
        tooltip.setOpacity(0.0);
        tooltip.getStyleClass().clear();
        tooltip.setMinSize(bounds.getWidth(), bounds.getHeight());
        tooltip.setMaxSize(bounds.getWidth(), bounds.getHeight());
        tooltip.setPrefSize(bounds.getWidth(), bounds.getHeight());
        tooltip.setWidth(bounds.getWidth());
        tooltip.setHeight(bounds.getHeight());
        Parent root = tooltip.getScene().getRoot();
        root.getStyleClass().clear();
        tooltip.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
        return tooltip;
    }

    private static Rectangle2D generateBounds() {
        Point2D origin = BeaconWindow.generateOrigin();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int width = 50 + random.nextInt(50);
        int height = 50 + random.nextInt(50);
        return new Rectangle2D(origin.getX(), origin.getY(), (double)width, (double)height);
    }

    private static Point2D generateOrigin() {
        Point2D result;
        if (Environment.isWindows()) {
            result = Point2D.ZERO;
        } else {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (Environment.isMac()) {
                Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
                int screenX = (int)screenBounds.getMinX();
                int screenY = (int)screenBounds.getMinY();
                int x = screenX + random.nextInt(100);
                int y = screenY + random.nextInt(100);
                result = new Point2D((double)x, (double)y);
            } else {
                result = new Point2D((double)random.nextInt(100), (double)random.nextInt(100));
            }
        }
        return result;
    }

    private static native long findOwnerByBounds(int var0, int var1, int var2, int var3);
}

