/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen;

import de.jangassen.dialogs.about.AboutStageBuilder;
import de.jangassen.icns.IcnsParser;
import de.jangassen.icns.IcnsType;
import de.jangassen.labels.LabelMaker;
import de.jangassen.labels.LabelName;
import de.jangassen.listener.MenuBarSyncListener;
import de.jangassen.listener.WindowMenuUpdateListener;
import de.jangassen.model.AppearanceMode;
import de.jangassen.platform.NativeAdapter;
import de.jangassen.platform.NativeAdapterProvider;
import de.jangassen.util.MenuBarUtils;
import de.jangassen.util.StageUtils;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MenuToolkit {
    private static final String APP_NAME = "Apple";
    private final NativeAdapter nativeAdapter;
    private final LabelMaker labelMaker;

    private MenuToolkit(NativeAdapter nativeAdapter, LabelMaker labelMaker) {
        this.nativeAdapter = nativeAdapter;
        this.labelMaker = labelMaker;
    }

    public static MenuToolkit toolkit() {
        return MenuToolkit.toolkit(Locale.ENGLISH);
    }

    public static MenuToolkit toolkit(Locale locale) {
        return MenuToolkit.toolkit(new LabelMaker(locale));
    }

    public static MenuToolkit toolkit(LabelMaker labelMaker) {
        return new MenuToolkit(NativeAdapterProvider.getNativeAdapter(), labelMaker);
    }

    public Menu createDefaultApplicationMenu(String appName) {
        return this.createDefaultApplicationMenu(appName, this.createDefaultAboutStage(appName));
    }

    public Menu createDefaultApplicationMenu(String appName, Stage aboutStage) {
        return new Menu(APP_NAME, null, new MenuItem[]{this.createAboutMenuItem(appName, aboutStage), new SeparatorMenuItem(), this.createHideMenuItem(appName), this.createHideOthersMenuItem(), this.createUnhideAllMenuItem(), new SeparatorMenuItem(), this.createQuitMenuItem(appName)});
    }

    public MenuItem createAboutMenuItem(String appName) {
        return this.createAboutMenuItem(appName, this.createDefaultAboutStage(appName));
    }

    public MenuItem createNativeAboutMenuItem(String appName) {
        return this.createAboutMenuItem(appName, (EventHandler<ActionEvent>)((EventHandler)event -> this.nativeAdapter.showAboutWindow(appName)));
    }

    public MenuItem createAboutMenuItem(String appName, EventHandler<ActionEvent> actionEventEventHandler) {
        MenuItem about = new MenuItem(this.labelMaker.getLabel(LabelName.ABOUT, appName));
        about.setOnAction(actionEventEventHandler);
        return about;
    }

    private Stage createDefaultAboutStage(String appName) {
        AboutStageBuilder stageBuilder = AboutStageBuilder.start(this.labelMaker.getLabel(LabelName.ABOUT, appName)).withAppName(appName).withCloseOnFocusLoss().withCopyright("Copyright \u00a9 " + Calendar.getInstance().get(1));
        try {
            IcnsParser parser = IcnsParser.forFile("/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/GenericApplicationIcon.icns");
            stageBuilder = stageBuilder.withImage(new Image(parser.getIconStream(IcnsType.ic09)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stageBuilder.build();
    }

    public MenuItem createAboutMenuItem(String appName, Stage aboutStage) {
        return this.createAboutMenuItem(appName, (EventHandler<ActionEvent>)((EventHandler)event -> aboutStage.show()));
    }

    public MenuItem createQuitMenuItem(String appName) {
        MenuItem quit = new MenuItem(this.labelMaker.getLabel(LabelName.QUIT, appName));
        quit.setOnAction(event -> this.nativeAdapter.quit());
        quit.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        return quit;
    }

    public MenuItem createUnhideAllMenuItem() {
        MenuItem unhideAll = new MenuItem(this.labelMaker.getLabel(LabelName.SHOW_ALL, new Object[0]));
        unhideAll.setOnAction(event -> this.nativeAdapter.showAllWindows());
        return unhideAll;
    }

    public MenuItem createHideOthersMenuItem() {
        MenuItem hideOthers = new MenuItem(this.labelMaker.getLabel(LabelName.HIDE_OTHERS, new Object[0]));
        hideOthers.setOnAction(event -> this.nativeAdapter.hideOtherApplications());
        hideOthers.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCombination.META_DOWN, KeyCombination.ALT_DOWN}));
        return hideOthers;
    }

    public MenuItem createHideMenuItem(String appName) {
        MenuItem hide = new MenuItem(this.labelMaker.getLabel(LabelName.HIDE, appName));
        hide.setOnAction(event -> this.nativeAdapter.hide());
        hide.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        return hide;
    }

    public void hide() throws Exception {
        if (this.nativeAdapter != null) {
            this.nativeAdapter.hide();
        }
    }

    public MenuItem createMinimizeMenuItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.MINIMIZE, new Object[0]));
        menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        menuItem.setOnAction(event -> StageUtils.minimizeFocusedStage());
        return menuItem;
    }

    public MenuItem createZoomMenuItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.ZOOM, new Object[0]));
        menuItem.setOnAction(event -> StageUtils.zoomFocusedStage());
        return menuItem;
    }

    public MenuItem createCloseWindowMenuItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.CLOSE_WINDOW, new Object[0]));
        menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        menuItem.setOnAction(event -> StageUtils.closeCurrentStage());
        return menuItem;
    }

    public MenuItem createBringAllToFrontItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.BRING_ALL_TO_FRONT, new Object[0]));
        menuItem.setOnAction(event -> StageUtils.bringAllToFront());
        return menuItem;
    }

    public MenuItem createCycleWindowsItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.CYCLE_THROUGH_WINDOWS, new Object[0]));
        menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.BACK_QUOTE, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        menuItem.setOnAction(event -> StageUtils.focusNextStage());
        return menuItem;
    }

    public void setApplicationMenu(Menu menu) {
        this.nativeAdapter.setApplicationMenu(menu);
    }

    public void setDockIconMenu(Menu menu) {
        this.nativeAdapter.setDockIconMenu(menu);
    }

    public void setTrayMenu(Menu menu) {
        this.nativeAdapter.setTrayMenu(menu);
    }

    public void showContextMenu(Menu menu, MouseEvent event) {
        this.nativeAdapter.showContextMenu(menu, event);
    }

    public boolean systemUsesDarkMode() {
        return this.nativeAdapter.systemUsesDarkMode();
    }

    public void setAppearanceMode(AppearanceMode mode) {
        this.nativeAdapter.setAppearanceMode(mode);
    }

    public void setGlobalMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
        MenuBarSyncListener.register(menuBar);
    }

    public void unsetGlobalMenuBar() {
        MenuBarSyncListener.unregister();
    }

    public void setMenuBar(MenuBar menuBar) {
        if (Window.getWindows().isEmpty()) {
            this.nativeAdapter.setMenuBar((List<Menu>)menuBar.getMenus());
        } else {
            this.setApplicationMenu(this.extractApplicationMenu(menuBar));
            Window.getWindows().stream().filter(Stage.class::isInstance).map(Stage.class::cast).forEach(stage -> MenuBarUtils.setMenuBar(stage, menuBar));
        }
    }

    public void setMenuBar(Stage stage, MenuBar menuBar) {
        Parent parent = stage.getScene().getRoot();
        if (parent instanceof Pane) {
            this.setMenuBar((Pane)parent, menuBar);
        }
    }

    public void setMenuBar(Pane pane, MenuBar menuBar) {
        this.setApplicationMenu(this.extractApplicationMenu(menuBar));
        MenuBarUtils.setMenuBar(pane, menuBar);
    }

    public void autoAddWindowMenuItems(Menu menu) {
        menu.getItems().add((Object)new SeparatorMenuItem());
        StageUtils.getStages().addListener((ListChangeListener)new WindowMenuUpdateListener(menu));
    }

    public void setForceQuitOnCmdQ(boolean forceQuit) {
        this.nativeAdapter.setForceQuitOnCmdQ(forceQuit);
    }

    protected Menu extractApplicationMenu(MenuBar menuBar) {
        return (Menu)menuBar.getMenus().get(0);
    }
}

