/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.icns;

import de.jangassen.icns.IcnsIcon;
import de.jangassen.icns.IcnsInputStream;
import de.jangassen.icns.IcnsType;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class IcnsParser {
    private static final int MAGIC = 1768124019;
    private static final int HEADER_SIZE = 8;
    private final File icnsFile;
    private int length = 0;
    private long offset = 0L;
    private final HashMap<String, IcnsIcon> iconMap = new HashMap();

    protected IcnsParser(File icnsFile) {
        this.icnsFile = icnsFile;
    }

    public static IcnsParser forFile(String path) throws IOException {
        return IcnsParser.forFile(new File(path));
    }

    public static IcnsParser forFile(File file) throws IOException {
        IcnsParser parser = new IcnsParser(file);
        parser.parse();
        return parser;
    }

    public void parse() throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(this.icnsFile);
             DataInputStream dataInputStream = new DataInputStream(fileInputStream);){
            this.parseHeader(dataInputStream);
            this.parseIcons(dataInputStream);
        }
    }

    public boolean hasIconType(IcnsType iconType) {
        return this.iconMap.containsKey(iconType.getOsType());
    }

    public InputStream getIconStream(IcnsType iconType) throws IOException {
        if (!this.iconMap.containsKey(iconType.getOsType())) {
            return null;
        }
        return this.createIconInputStream(iconType.getOsType());
    }

    private InputStream createIconInputStream(String osType) throws IOException {
        IcnsIcon icon = this.iconMap.get(osType);
        FileInputStream iconData = new FileInputStream(this.icnsFile);
        ((InputStream)iconData).skip(icon.offset);
        return new IcnsInputStream(iconData, icon.length);
    }

    private void parseIcons(DataInputStream dataInputStream) throws IOException {
        while (this.offset < (long)this.length) {
            IcnsIcon icon = this.readNextIcon(dataInputStream);
            if (icon.length <= 0) break;
            this.iconMap.put(icon.type, icon);
            this.offset += (long)icon.length;
        }
    }

    private void parseHeader(DataInputStream stream) throws IOException {
        int magic = stream.readInt();
        if (magic != 1768124019) {
            throw new IllegalArgumentException("Provided file is not a valid icns file");
        }
        this.length = stream.readInt();
        this.offset += 8L;
    }

    private IcnsIcon readNextIcon(DataInputStream stream) throws IOException {
        byte[] type = new byte[4];
        stream.read(type);
        int skipLength = stream.readInt();
        stream.skipBytes(skipLength - 8);
        return new IcnsIcon(new String(type), this.offset + 8L, skipLength);
    }
}

