/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.platform.mac;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.PointerByReference;
import de.jangassen.jfa.FoundationMethod;
import de.jangassen.jfa.FoundationProxy;
import de.jangassen.jfa.FoundationProxyHandler;
import de.jangassen.jfa.JavaToObjc;
import de.jangassen.jfa.NamedType;
import de.jangassen.jfa.ObjcToJava;
import de.jangassen.jfa.appkit.NSAboutPanelOptionKey;
import de.jangassen.jfa.appkit.NSAppearance;
import de.jangassen.jfa.appkit.NSApplication;
import de.jangassen.jfa.appkit.NSApplicationDelegate;
import de.jangassen.jfa.appkit.NSDictionary;
import de.jangassen.jfa.appkit.NSInvocation;
import de.jangassen.jfa.appkit.NSMenu;
import de.jangassen.jfa.appkit.NSMenuItem;
import de.jangassen.jfa.appkit.NSObject;
import de.jangassen.jfa.appkit.NSPoint;
import de.jangassen.jfa.appkit.NSStatusBar;
import de.jangassen.jfa.appkit.NSStatusItem;
import de.jangassen.jfa.appkit.NSString;
import de.jangassen.jfa.appkit.NSUserDefaults;
import de.jangassen.jfa.appkit.NSView;
import de.jangassen.jfa.appkit.NSWindow;
import de.jangassen.jfa.appkit.NSWorkspace;
import de.jangassen.jfa.cleanup.NSCleaner;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import de.jangassen.listener.WindowShowingEventListener;
import de.jangassen.model.AppearanceMode;
import de.jangassen.platform.NativeAdapter;
import de.jangassen.platform.mac.convert.ImageConverter;
import de.jangassen.platform.mac.convert.MenuConverter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.scene.control.Menu;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;

public class MacNativeAdapter
implements NativeAdapter {
    public static final String DARK = "Dark";
    private static MacNativeAdapter instance;
    private boolean forceQuitOnCmdQ = true;
    private final NSApplication sharedApplication = NSApplication.sharedApplication();
    private final NSWorkspace sharedWorkspace = NSWorkspace.sharedWorkspace();
    private NSStatusItem nsStatusItem;
    private FoundationProxy applicationDelegate;
    private Menu applicationMenu;
    private NSMenu dockIconMenu;

    private MacNativeAdapter() {
        Window.getWindows().forEach(window -> window.showingProperty().addListener((observableValue, oldValue, newValue) -> {
            if (Boolean.TRUE.equals(newValue)) {
                this.handleWindowShowing();
            }
        }));
        Window.getWindows().addListener((ListChangeListener)new WindowShowingEventListener(this::handleWindowShowing));
    }

    public static MacNativeAdapter getInstance() {
        if (instance == null) {
            instance = new MacNativeAdapter();
        }
        return instance;
    }

    public static boolean isAvailable() {
        return Foundation.isAvailable();
    }

    @Override
    public void setMenuBar(List<Menu> menus) {
        NSMenu menu = NSMenu.alloc().init();
        menus.stream().map(this::getMenuBarItem).forEach(menu::addItem);
        this.sharedApplication.setMainMenu(menu);
        if (!menus.isEmpty()) {
            this.applicationMenu = menus.get(0);
        }
    }

    private NSMenuItem getMenuBarItem(Menu menu) {
        NSMenu nsMenu = MenuConverter.convert(menu);
        NSMenuItem wrapperItem = NSMenuItem.alloc().init();
        wrapperItem.setSubmenu(nsMenu);
        NSCleaner.register((Object)menu, wrapperItem);
        return wrapperItem;
    }

    private void handleWindowShowing() {
        if (this.applicationMenu != null) {
            this.setApplicationMenu(this.applicationMenu);
        }
    }

    @Override
    public void setApplicationMenu(Menu menu) {
        NSMenu nsMenu = this.sharedApplication.mainMenu();
        if (nsMenu == null) {
            this.setMenuBar(Collections.singletonList(menu));
        } else {
            this.replaceApplicationMenu(menu, nsMenu);
        }
    }

    private void replaceApplicationMenu(Menu menu, NSMenu nsMenu) {
        NSMenuItem mainMenu = this.getMenuBarItem(menu);
        nsMenu.removeItemAtIndex(0);
        nsMenu.insertItem(mainMenu, 0);
        this.applicationMenu = menu;
    }

    @Override
    public void hide() {
        this.sharedApplication.hide(ID.NIL);
    }

    @Override
    public void hideOtherApplications() {
        this.sharedWorkspace.hideOtherApplications();
    }

    @Override
    public void showAllWindows() {
        this.sharedApplication.unhide(ID.NIL);
    }

    @Override
    public void quit() {
        if (this.forceQuitOnCmdQ) {
            Platform.exit();
        }
    }

    @Override
    public void setForceQuitOnCmdQ(boolean forceQuit) {
        this.forceQuitOnCmdQ = forceQuit;
    }

    @Override
    public void setTrayMenu(Menu menu) {
        NSStatusBar nsStatusBar = NSStatusBar.systemStatusBar();
        if (menu != null) {
            if (this.nsStatusItem == null) {
                this.nsStatusItem = nsStatusBar.statusItemWithLength(NSStatusBar.NSSquareStatusItemLength);
                Foundation.cfRetain(ObjcToJava.toID(this.nsStatusItem));
            }
            ImageConverter.convert(menu.getGraphic()).ifPresent(this.nsStatusItem.button()::setImage);
            NSMenu convertedMenu = MenuConverter.convert(menu);
            this.nsStatusItem.setMenu(convertedMenu);
        } else if (this.nsStatusItem != null) {
            nsStatusBar.removeStatusItem(this.nsStatusItem);
            Foundation.cfRetain(ObjcToJava.toID(this.nsStatusItem));
        }
    }

    @Override
    public void showContextMenu(Menu menu, MouseEvent event) {
        Optional.ofNullable(this.sharedApplication.keyWindow()).map(NSWindow::contentView).ifPresent(view -> {
            NSMenu nsMenu = MenuConverter.convert(menu);
            NSPoint nsPoint = new NSPoint();
            nsPoint.x = new Foundation.CGFloat(event.getSceneX());
            nsPoint.y = new Foundation.CGFloat(event.getSceneY());
            nsMenu.popUpMenuPositioningItem(null, nsPoint, (NSView)view);
        });
    }

    @Override
    public void setDockIconMenu(Menu menu) {
        if (this.applicationDelegate == null) {
            this.applicationDelegate = this.createApplicationDelegate();
            ID mappedObject = JavaToObjc.map(this.applicationDelegate);
            this.sharedApplication.setDelegate(ObjcToJava.map(mappedObject, NSApplicationDelegate.class));
        }
        if (this.dockIconMenu != null) {
            Foundation.cfRelease(ObjcToJava.toID(this.dockIconMenu));
        }
        this.dockIconMenu = MenuConverter.convert(menu);
        if (menu != null) {
            Foundation.cfRetain(ObjcToJava.toID(this.dockIconMenu));
        }
    }

    private FoundationProxy createApplicationDelegate() {
        FoundationProxyHandler proxyHandler = new FoundationProxyHandler();
        NamedType namedType = new NamedType(NSApplication.class, null);
        proxyHandler.addMethod(new FoundationMethod(this::getNsInvocationConsumer, "applicationDockMenu", NSMenu.class, namedType));
        return new FoundationProxy(this.sharedApplication.delegate(), proxyHandler);
    }

    private void getNsInvocationConsumer(NSInvocation invocation) {
        Pointer value = new Pointer(ObjcToJava.toID(this.dockIconMenu).longValue());
        invocation.setReturnValue((ByReference)new PointerByReference(value));
    }

    @Override
    public boolean systemUsesDarkMode() {
        return DARK.equals(NSUserDefaults.standardUserDefaults().objectForKey("AppleInterfaceStyle"));
    }

    @Override
    public void setAppearanceMode(AppearanceMode mode) {
        switch (mode) {
            case AUTO: {
                NSAppearance.NSAppearanceName appearanceName = this.systemUsesDarkMode() ? NSAppearance.NSAppearanceName.NSAppearanceNameVibrantDark : NSAppearance.NSAppearanceName.NSAppearanceNameVibrantLight;
                this.sharedApplication.setAppearance(NSAppearance.appearanceNamed(appearanceName));
                break;
            }
            case DARK: {
                this.sharedApplication.setAppearance(NSAppearance.appearanceNamed(NSAppearance.NSAppearanceName.NSAppearanceNameVibrantDark));
                break;
            }
            case LIGHT: {
                this.sharedApplication.setAppearance(NSAppearance.appearanceNamed(NSAppearance.NSAppearanceName.NSAppearanceNameVibrantLight));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void showAboutWindow(String title) {
        NSDictionary<NSAboutPanelOptionKey, NSObject> options = NSDictionary.of(Map.of(NSAboutPanelOptionKey.NSAboutPanelOptionApplicationName, NSString.of(title)));
        this.sharedApplication.orderFrontStandardAboutPanelWithOptions(options);
    }
}

