/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io;

import ezvcard.VCard;
import ezvcard.io.ParseContext;
import ezvcard.io.ParseWarning;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.parameter.AddressType;
import ezvcard.property.Address;
import ezvcard.property.Label;
import ezvcard.property.VCardProperty;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class StreamReader
implements Closeable {
    protected final List<ParseWarning> warnings = new ArrayList<ParseWarning>();
    protected ScribeIndex index = new ScribeIndex();
    protected ParseContext context;

    public List<VCard> readAll() throws IOException {
        VCard vcard;
        ArrayList<VCard> vcards = new ArrayList<VCard>();
        while ((vcard = this.readNext()) != null) {
            vcards.add(vcard);
        }
        return vcards;
    }

    public VCard readNext() throws IOException {
        this.warnings.clear();
        this.context = new ParseContext();
        return this._readNext();
    }

    protected abstract VCard _readNext() throws IOException;

    protected void assignLabels(VCard vcard, List<Label> labels) {
        List<Address> adrs = vcard.getAddresses();
        for (Label label : labels) {
            boolean orphaned = true;
            HashSet<AddressType> labelTypes = new HashSet<AddressType>(label.getTypes());
            for (Address adr : adrs) {
                HashSet<AddressType> adrTypes;
                if (adr.getLabel() != null || !(adrTypes = new HashSet<AddressType>(adr.getTypes())).equals(labelTypes)) continue;
                adr.setLabel((String)label.getValue());
                orphaned = false;
                break;
            }
            if (!orphaned) continue;
            vcard.addOrphanedLabel(label);
        }
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<ParseWarning> getWarnings() {
        return new ArrayList<ParseWarning>(this.warnings);
    }
}

