/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.html;

import ezvcard.VCard;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.parameter.ImageType;
import ezvcard.property.Photo;
import ezvcard.util.DataUri;
import ezvcard.util.VCardDateFormat;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class HCardPage {
    private final Template template;
    private final List<VCard> vcards = new ArrayList<VCard>();

    public HCardPage() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setClassForTemplateLoading(HCardPage.class, "");
        cfg.setWhitespaceStripping(true);
        try {
            this.template = cfg.getTemplate("hcard-template.html");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public HCardPage(Template template) {
        this.template = template;
    }

    public void add(VCard vcard) {
        this.vcards.add(vcard);
    }

    public String write() {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sw.toString();
    }

    public void write(OutputStream out) throws IOException {
        this.write(new OutputStreamWriter(out));
    }

    public void write(Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.write(writer);
        }
    }

    public void write(Writer writer) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vcards", this.vcards);
        map.put("utils", new TemplateUtils());
        map.put("translucentBg", this.readImage("translucent-bg.png", ImageType.PNG));
        map.put("noProfile", this.readImage("no-profile.png", ImageType.PNG));
        map.put("ezVCardVersion", "0.12.1");
        map.put("ezVCardUrl", "https://github.com/mangstadt/ez-vcard");
        map.put("scribeIndex", new ScribeIndex());
        try {
            this.template.process(map, writer);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        writer.flush();
    }

    private Photo readImage(String name, ImageType mediaType) throws IOException {
        return new Photo(this.getClass().getResourceAsStream(name), mediaType);
    }

    public static class TemplateUtils {
        private final Pattern newlineRegex = Pattern.compile("\\r\\n|\\r|\\n");

        public String base64(String contentType, byte[] data) {
            return new DataUri(contentType, data).toString();
        }

        public String lineBreaks(String value) {
            return this.newlineRegex.matcher(value).replaceAll("<br />");
        }

        public String format(Temporal temporal, String format) {
            return this.format(temporal, format, ZoneOffset.UTC);
        }

        public String formatLocal(Temporal temporal, String format) {
            return this.format(temporal, format, ZoneId.systemDefault());
        }

        private String format(Temporal temporal, String format, ZoneId offset) {
            if (temporal instanceof Instant) {
                temporal = ((Instant)temporal).atZone(offset);
            }
            return DateTimeFormatter.ofPattern(format).format(temporal);
        }

        public String format(ZoneOffset offset) {
            return VCardDateFormat.BASIC.format(offset);
        }
    }
}

