/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.JsonParser;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.ParseWarning;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamReader;
import ezvcard.io.json.JCardRawReader;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class JCardReader
extends StreamReader {
    private final JCardRawReader reader;

    public JCardReader(String json) {
        this(new StringReader(json));
    }

    public JCardReader(InputStream in) {
        this(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public JCardReader(Path file) throws IOException {
        this(Files.newBufferedReader(file, StandardCharsets.UTF_8));
    }

    public JCardReader(Reader reader) {
        this.reader = new JCardRawReader(reader);
    }

    public JCardReader(JsonParser parser) {
        this.reader = new JCardRawReader(parser, true);
    }

    @Override
    protected VCard _readNext() throws IOException {
        if (this.reader.eof()) {
            return null;
        }
        this.context.setVersion(VCardVersion.V4_0);
        JCardDataStreamListenerImpl listener = new JCardDataStreamListenerImpl();
        this.reader.readNext(listener);
        VCard vcard = listener.vcard;
        if (vcard != null && !listener.versionFound) {
            this.warnings.add(new ParseWarning.Builder().lineNumber(this.reader.getLineNum()).message(29, new Object[0]).build());
        }
        return vcard;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class JCardDataStreamListenerImpl
    implements JCardRawReader.JCardDataStreamListener {
        private VCard vcard = null;
        private boolean versionFound = false;

        private JCardDataStreamListenerImpl() {
        }

        @Override
        public void beginVCard() {
            this.vcard = new VCard();
            this.vcard.setVersion(VCardVersion.V4_0);
        }

        @Override
        public void readProperty(String group, String propertyName, VCardParameters parameters, VCardDataType dataType, JCardValue value) {
            Object property;
            JCardReader.this.context.getWarnings().clear();
            JCardReader.this.context.setLineNumber(JCardReader.this.reader.getLineNum());
            JCardReader.this.context.setPropertyName(propertyName);
            if ("version".equalsIgnoreCase(propertyName)) {
                this.versionFound = true;
                VCardVersion version = VCardVersion.valueOfByStr(value.asSingle());
                if (version != VCardVersion.V4_0) {
                    JCardReader.this.warnings.add(new ParseWarning.Builder(JCardReader.this.context).message(30, new Object[0]).build());
                }
                return;
            }
            RawPropertyScribe scribe = JCardReader.this.index.getPropertyScribe(propertyName);
            if (scribe == null) {
                scribe = new RawPropertyScribe(propertyName);
            }
            try {
                property = scribe.parseJson(value, dataType, parameters, JCardReader.this.context);
                JCardReader.this.warnings.addAll(JCardReader.this.context.getWarnings());
            }
            catch (SkipMeException e) {
                JCardReader.this.warnings.add(new ParseWarning.Builder(JCardReader.this.context).message(22, e.getMessage()).build());
                return;
            }
            catch (CannotParseException e) {
                scribe = new RawPropertyScribe(propertyName);
                property = scribe.parseJson(value, dataType, parameters, JCardReader.this.context);
                JCardReader.this.warnings.add(new ParseWarning.Builder(JCardReader.this.context).message(e).build());
            }
            catch (EmbeddedVCardException e) {
                JCardReader.this.warnings.add(new ParseWarning.Builder(JCardReader.this.context).message(31, new Object[0]).build());
                return;
            }
            ((VCardProperty)property).setGroup(group);
            this.vcard.addProperty((VCardProperty)property);
        }
    }
}

