/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.BinaryPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.KeyType;
import ezvcard.parameter.MediaTypeParameter;
import ezvcard.parameter.VCardParameter;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Key;

public class KeyScribe
extends BinaryPropertyScribe<Key, KeyType> {
    public KeyScribe() {
        super(Key.class, "KEY");
    }

    @Override
    protected VCardDataType _dataType(Key property, VCardVersion version) {
        if (version == VCardVersion.V4_0 && property.getText() != null) {
            return VCardDataType.TEXT;
        }
        if (property.getUrl() != null) {
            return VCardDataType.URI;
        }
        return super._dataType(property, version);
    }

    @Override
    protected void _prepareParameters(Key property, VCardParameters copy, VCardVersion version, VCard vcard) {
        if (property.getText() != null) {
            Object contentType = property.getContentType();
            if (contentType == null) {
                contentType = new MediaTypeParameter(null, null, null);
            }
            copy.setEncoding(null);
            switch (version) {
                case V2_1: {
                    copy.setType(((VCardParameter)contentType).getValue());
                    copy.setMediaType(null);
                    break;
                }
                case V3_0: {
                    copy.setType(((VCardParameter)contentType).getValue());
                    copy.setMediaType(null);
                    break;
                }
                case V4_0: {
                    copy.setMediaType(((MediaTypeParameter)contentType).getMediaType());
                }
            }
            return;
        }
        super._prepareParameters(property, copy, version, vcard);
    }

    @Override
    protected String _writeText(Key property, WriteContext context) {
        String text = property.getText();
        if (text != null) {
            return text;
        }
        return super._writeText(property, context);
    }

    @Override
    protected Key _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape(value);
        if (dataType == VCardDataType.TEXT) {
            KeyType contentType = (KeyType)this.parseContentTypeFromValueAndParameters(value, parameters, context.getVersion());
            Key property = new Key();
            property.setText(value, contentType);
            return property;
        }
        return (Key)this.parse(value, dataType, parameters, context.getVersion());
    }

    @Override
    protected void _writeXml(Key property, XCardElement parent) {
        String text = property.getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        super._writeXml(property, parent);
    }

    @Override
    protected Key _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        String text = element.first(VCardDataType.TEXT);
        if (text != null) {
            KeyType contentType = (KeyType)this.parseContentTypeFromValueAndParameters(text, parameters, element.version());
            Key property = new Key();
            property.setText(text, contentType);
            return property;
        }
        String value = element.first(VCardDataType.URI);
        if (value != null) {
            return (Key)this.parse(value, VCardDataType.URI, parameters, element.version());
        }
        throw KeyScribe.missingXmlElements(VCardDataType.URI, VCardDataType.TEXT);
    }

    @Override
    protected JCardValue _writeJson(Key property) {
        String text = property.getText();
        if (text != null) {
            return JCardValue.single(text);
        }
        return super._writeJson(property);
    }

    @Override
    protected Key _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        if (dataType == VCardDataType.TEXT) {
            String valueStr = value.asSingle();
            KeyType contentType = (KeyType)this.parseContentTypeFromValueAndParameters(valueStr, parameters, VCardVersion.V4_0);
            Key property = new Key();
            property.setText(valueStr, contentType);
            return property;
        }
        return (Key)super._parseJson(value, dataType, parameters, context);
    }

    @Override
    protected KeyType _mediaTypeFromTypeParameter(String type) {
        return KeyType.get(type, null, null);
    }

    @Override
    protected KeyType _mediaTypeFromMediaTypeParameter(String mediaType) {
        return KeyType.get(null, mediaType, null);
    }

    @Override
    protected KeyType _mediaTypeFromFileExtension(String extension) {
        return KeyType.find(null, null, extension);
    }

    @Override
    protected Key _newInstance(String uri, KeyType contentType) {
        return new Key(uri, contentType);
    }

    @Override
    protected Key _newInstance(byte[] data, KeyType contentType) {
        return new Key(data, contentType);
    }

    @Override
    protected Key cannotUnmarshalValue(String value, VCardVersion version, KeyType contentType) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                Key key = new Key();
                key.setText(value, contentType);
                return key;
            }
            case V4_0: {
                return new Key(value, contentType);
            }
        }
        return null;
    }
}

