/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.StructuredName;
import ezvcard.util.StringUtils;

public class StructuredNameScribe
extends VCardPropertyScribe<StructuredName> {
    public StructuredNameScribe() {
        super(StructuredName.class, "N");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(StructuredName property, WriteContext context) {
        if (context.getVersion() == VCardVersion.V2_1) {
            VObjectPropertyValues.SemiStructuredValueBuilder builder = new VObjectPropertyValues.SemiStructuredValueBuilder();
            builder.append(property.getFamily());
            builder.append(property.getGiven());
            builder.append(StringUtils.join(property.getAdditionalNames(), ","));
            builder.append(StringUtils.join(property.getPrefixes(), ","));
            builder.append(StringUtils.join(property.getSuffixes(), ","));
            return builder.build(false, context.isIncludeTrailingSemicolons());
        }
        VObjectPropertyValues.StructuredValueBuilder builder = new VObjectPropertyValues.StructuredValueBuilder();
        builder.append(property.getFamily());
        builder.append(property.getGiven());
        builder.append(property.getAdditionalNames());
        builder.append(property.getPrefixes());
        builder.append(property.getSuffixes());
        return builder.build(context.isIncludeTrailingSemicolons());
    }

    @Override
    protected StructuredName _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        StructuredName property = new StructuredName();
        if (context.getVersion() == VCardVersion.V2_1) {
            VObjectPropertyValues.SemiStructuredValueIterator it = new VObjectPropertyValues.SemiStructuredValueIterator(value);
            property.setFamily(it.next());
            property.setGiven(it.next());
            String next = it.next();
            if (next != null) {
                property.getAdditionalNames().add(next);
            }
            if ((next = it.next()) != null) {
                property.getPrefixes().add(next);
            }
            if ((next = it.next()) != null) {
                property.getSuffixes().add(next);
            }
        } else {
            VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value);
            property.setFamily(it.nextValue());
            property.setGiven(it.nextValue());
            property.getAdditionalNames().addAll(it.nextComponent());
            property.getPrefixes().addAll(it.nextComponent());
            property.getSuffixes().addAll(it.nextComponent());
        }
        return property;
    }

    @Override
    protected void _writeXml(StructuredName property, XCardElement parent) {
        parent.append("surname", property.getFamily());
        parent.append("given", property.getGiven());
        parent.append("additional", property.getAdditionalNames());
        parent.append("prefix", property.getPrefixes());
        parent.append("suffix", property.getSuffixes());
    }

    @Override
    protected StructuredName _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        StructuredName property = new StructuredName();
        property.setFamily(StructuredNameScribe.s(element.first("surname")));
        property.setGiven(StructuredNameScribe.s(element.first("given")));
        property.getAdditionalNames().addAll(element.all("additional"));
        property.getPrefixes().addAll(element.all("prefix"));
        property.getSuffixes().addAll(element.all("suffix"));
        return property;
    }

    private static String s(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    @Override
    protected StructuredName _parseHtml(HCardElement element, ParseContext context) {
        StructuredName property = new StructuredName();
        property.setFamily(StructuredNameScribe.s(element.firstValue("family-name")));
        property.setGiven(StructuredNameScribe.s(element.firstValue("given-name")));
        property.getAdditionalNames().addAll(element.allValues("additional-name"));
        property.getPrefixes().addAll(element.allValues("honorific-prefix"));
        property.getSuffixes().addAll(element.allValues("honorific-suffix"));
        return property;
    }

    @Override
    protected JCardValue _writeJson(StructuredName property) {
        return JCardValue.structured(property.getFamily(), property.getGiven(), property.getAdditionalNames(), property.getPrefixes(), property.getSuffixes());
    }

    @Override
    protected StructuredName _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        StructuredName property = new StructuredName();
        VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value.asStructured());
        property.setFamily(it.nextValue());
        property.setGiven(it.nextValue());
        property.getAdditionalNames().addAll(it.nextComponent());
        property.getPrefixes().addAll(it.nextComponent());
        property.getSuffixes().addAll(it.nextComponent());
        return property;
    }
}

