/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.xml;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.ParseWarning;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamReader;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardNamespaceContext;
import ezvcard.io.xml.XCardOutputProperties;
import ezvcard.io.xml.XCardQNames;
import ezvcard.io.xml.XCardWriterBase;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import ezvcard.property.Xml;
import ezvcard.util.ListMultimap;
import ezvcard.util.XmlUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XCardDocument {
    private final VCardVersion version4 = VCardVersion.V4_0;
    private final Document document;
    private Element vcardsRootElement;

    public XCardDocument() {
        this.document = XmlUtils.createDocument();
        this.vcardsRootElement = this.document.createElementNS(XCardQNames.VCARDS.getNamespaceURI(), XCardQNames.VCARDS.getLocalPart());
        this.document.appendChild(this.vcardsRootElement);
    }

    public XCardDocument(String xml) throws SAXException {
        this(XmlUtils.toDocument(xml));
    }

    public XCardDocument(InputStream in) throws SAXException, IOException {
        this(XmlUtils.toDocument(in));
    }

    public XCardDocument(Path file) throws SAXException, IOException {
        this(XmlUtils.toDocument(file));
    }

    public XCardDocument(Reader reader) throws SAXException, IOException {
        this(XmlUtils.toDocument(reader));
    }

    public XCardDocument(Document document) {
        this.document = document;
        XCardNamespaceContext nsContext = new XCardNamespaceContext(this.version4, "v");
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsContext);
        try {
            this.vcardsRootElement = (Element)xpath.evaluate("//" + nsContext.getPrefix() + ":" + XCardQNames.VCARDS.getLocalPart(), document, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public StreamReader reader() {
        return new XCardDocumentStreamReader();
    }

    public XCardDocumentStreamWriter writer() {
        return new XCardDocumentStreamWriter();
    }

    public Document getDocument() {
        return this.document;
    }

    public List<VCard> getVCards() {
        try {
            return this.reader().readAll();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addVCard(VCard vcard) {
        this.writer().write(vcard);
    }

    public String write() {
        return this.write((Integer)null);
    }

    public String write(Integer indent) {
        return this.write(indent, null);
    }

    public String write(Integer indent, String xmlVersion) {
        return this.write(new XCardOutputProperties(indent, xmlVersion));
    }

    public String write(Map<String, String> outputProperties) {
        StringWriter sw = new StringWriter();
        try {
            this.write((Writer)sw, outputProperties);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void write(OutputStream out) throws TransformerException {
        this.write(out, (Integer)null);
    }

    public void write(OutputStream out, Integer indent) throws TransformerException {
        this.write(out, indent, null);
    }

    public void write(OutputStream out, Integer indent, String xmlVersion) throws TransformerException {
        this.write(out, (Map<String, String>)new XCardOutputProperties(indent, xmlVersion));
    }

    public void write(OutputStream out, Map<String, String> outputProperties) throws TransformerException {
        this.write((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), outputProperties);
    }

    public void write(Path file) throws TransformerException, IOException {
        this.write(file, (Integer)null);
    }

    public void write(Path file, Integer indent) throws TransformerException, IOException {
        this.write(file, indent, null);
    }

    public void write(Path file, Integer indent, String xmlVersion) throws TransformerException, IOException {
        this.write(file, (Map<String, String>)new XCardOutputProperties(indent, xmlVersion));
    }

    public void write(Path file, Map<String, String> outputProperties) throws TransformerException, IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.write((Writer)writer, outputProperties);
        }
    }

    public void write(Writer writer) throws TransformerException {
        this.write(writer, (Integer)null);
    }

    public void write(Writer writer, Integer indent) throws TransformerException {
        this.write(writer, indent, null);
    }

    public void write(Writer writer, Integer indent, String xmlVersion) throws TransformerException {
        this.write(writer, (Map<String, String>)new XCardOutputProperties(indent, xmlVersion));
    }

    public void write(Writer writer, Map<String, String> outputProperties) throws TransformerException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, String> entry : outputProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            transformer.setOutputProperty(key, value);
        }
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
    }

    public class XCardDocumentStreamWriter
    extends XCardWriterBase {
        @Override
        public void write(VCard vcard) {
            try {
                super.write(vcard);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        protected void _write(VCard vcard, List<VCardProperty> properties) throws IOException {
            ListMultimap<String, VCardProperty> propertiesByGroup = new ListMultimap<String, VCardProperty>();
            for (VCardProperty vCardProperty : properties) {
                propertiesByGroup.put(vCardProperty.getGroup(), vCardProperty);
            }
            Element vcardElement = this.createElement(XCardQNames.VCARD);
            for (Map.Entry entry : propertiesByGroup) {
                Element parent;
                String groupName = (String)entry.getKey();
                if (groupName != null) {
                    Element groupElement = this.createElement(XCardQNames.GROUP);
                    groupElement.setAttribute("name", groupName);
                    vcardElement.appendChild(groupElement);
                    parent = groupElement;
                } else {
                    parent = vcardElement;
                }
                for (VCardProperty property : entry.getValue()) {
                    try {
                        Element propertyElement = this.marshalProperty(property, vcard);
                        parent.appendChild(propertyElement);
                    }
                    catch (SkipMeException skipMeException) {
                    }
                    catch (EmbeddedVCardException embeddedVCardException) {}
                }
            }
            if (XCardDocument.this.vcardsRootElement == null) {
                XCardDocument.this.vcardsRootElement = this.createElement(XCardQNames.VCARDS);
                Element element = XCardDocument.this.document.getDocumentElement();
                if (element == null) {
                    XCardDocument.this.document.appendChild(XCardDocument.this.vcardsRootElement);
                } else {
                    element.appendChild(XCardDocument.this.vcardsRootElement);
                }
            }
            XCardDocument.this.vcardsRootElement.appendChild(vcardElement);
        }

        @Override
        public void close() {
        }

        private Element marshalProperty(VCardProperty property, VCard vcard) {
            Element propertyElement;
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(property);
            if (property instanceof Xml) {
                Xml xml = (Xml)property;
                Document propertyDocument = xml.getValue();
                if (propertyDocument == null) {
                    throw new SkipMeException();
                }
                propertyElement = propertyDocument.getDocumentElement();
                propertyElement = (Element)XCardDocument.this.document.importNode(propertyElement, true);
            } else {
                QName qname = scribe.getQName();
                propertyElement = this.createElement(qname);
                scribe.writeXml(property, propertyElement);
            }
            VCardParameters parameters = scribe.prepareParameters(property, this.targetVersion, vcard);
            this.removeUnsupportedParameters(parameters);
            if (!parameters.isEmpty()) {
                Element parametersElement = this.marshalParameters(parameters);
                Node firstChild = propertyElement.getFirstChild();
                propertyElement.insertBefore(parametersElement, firstChild);
            }
            return propertyElement;
        }

        private Element marshalParameters(VCardParameters parameters) {
            Element parametersElement = this.createElement(XCardQNames.PARAMETERS);
            for (Map.Entry parameter : parameters) {
                String parameterName = ((String)parameter.getKey()).toLowerCase();
                Element parameterElement = this.createElement(parameterName);
                for (String parameterValue : parameter.getValue()) {
                    VCardDataType dataType = (VCardDataType)this.parameterDataTypes.get(parameterName);
                    String dataTypeElementName = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                    Element dataTypeElement = this.createElement(dataTypeElementName);
                    dataTypeElement.setTextContent(parameterValue);
                    parameterElement.appendChild(dataTypeElement);
                }
                parametersElement.appendChild(parameterElement);
            }
            return parametersElement;
        }

        private Element createElement(String name) {
            return this.createElement(name, this.targetVersion.getXmlNamespace());
        }

        private Element createElement(String name, String ns) {
            return XCardDocument.this.document.createElementNS(ns, name);
        }

        private Element createElement(QName qname) {
            return this.createElement(qname.getLocalPart(), qname.getNamespaceURI());
        }
    }

    private class XCardDocumentStreamReader
    extends StreamReader {
        private final Iterator<Element> vcardElements;
        private VCard vcard;

        private XCardDocumentStreamReader() {
            List list = XCardDocument.this.vcardsRootElement == null ? Collections.emptyList() : this.getChildElements(XCardDocument.this.vcardsRootElement, XCardQNames.VCARD);
            this.vcardElements = list.iterator();
        }

        @Override
        public VCard readNext() {
            try {
                return super.readNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected VCard _readNext() throws IOException {
            if (!this.vcardElements.hasNext()) {
                return null;
            }
            this.vcard = new VCard();
            this.vcard.setVersion(XCardDocument.this.version4);
            this.context.setVersion(XCardDocument.this.version4);
            this.parseVCardElement(this.vcardElements.next());
            return this.vcard;
        }

        @Override
        public void close() {
        }

        private void parseVCardElement(Element vcardElement) {
            List<Element> children = XmlUtils.toElementList(vcardElement.getChildNodes());
            for (Element child : children) {
                if (XmlUtils.hasQName(child, XCardQNames.GROUP)) {
                    String group = child.getAttribute("name");
                    if (group.isEmpty()) {
                        group = null;
                    }
                    List<Element> grandChildren = XmlUtils.toElementList(child.getChildNodes());
                    for (Element grandChild : grandChildren) {
                        this.parseAndAddElement(grandChild, group);
                    }
                    continue;
                }
                this.parseAndAddElement(child, null);
            }
        }

        private void parseAndAddElement(Element element, String group) {
            VCardProperty property;
            VCardParameters parameters = this.parseParameters(element);
            String propertyName = element.getLocalName();
            String ns = element.getNamespaceURI();
            QName qname = new QName(ns, propertyName);
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(qname);
            this.context.getWarnings().clear();
            this.context.setPropertyName(propertyName);
            try {
                property = scribe.parseXml(element, parameters, this.context);
                property.setGroup(group);
                this.warnings.addAll(this.context.getWarnings());
            }
            catch (SkipMeException e) {
                this.warnings.add(new ParseWarning.Builder(this.context).message(22, e.getMessage()).build());
                return;
            }
            catch (CannotParseException e) {
                this.warnings.add(new ParseWarning.Builder(this.context).message(e).build());
                scribe = this.index.getPropertyScribe(Xml.class);
                property = scribe.parseXml(element, parameters, this.context);
                property.setGroup(group);
            }
            catch (EmbeddedVCardException e) {
                this.warnings.add(new ParseWarning.Builder(this.context).message(34, new Object[0]).build());
                return;
            }
            this.vcard.addProperty(property);
        }

        private VCardParameters parseParameters(Element element) {
            VCardParameters parameters = new VCardParameters();
            List<Element> roots = XmlUtils.toElementList(element.getElementsByTagNameNS(XCardQNames.PARAMETERS.getNamespaceURI(), XCardQNames.PARAMETERS.getLocalPart()));
            for (Element root : roots) {
                List<Element> parameterElements = XmlUtils.toElementList(root.getChildNodes());
                for (Element parameterElement : parameterElements) {
                    String name = parameterElement.getLocalName().toUpperCase();
                    List<Element> valueElements = XmlUtils.toElementList(parameterElement.getChildNodes());
                    for (Element valueElement : valueElements) {
                        String value = valueElement.getTextContent();
                        parameters.put(name, value);
                    }
                }
            }
            return parameters;
        }

        private List<Element> getChildElements(Element parent, QName qname) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element child : XmlUtils.toElementList(parent.getChildNodes())) {
                if (!XmlUtils.hasQName(child, qname)) continue;
                elements.add(child);
            }
            return elements;
        }
    }
}

