/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.parameter.Calscale;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.PartialDate;
import java.time.temporal.Temporal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DateOrTimeProperty
extends VCardProperty
implements HasAltId {
    private String text;
    private Temporal date;
    private PartialDate partialDate;

    public DateOrTimeProperty(Temporal date) {
        this.date = date;
    }

    public DateOrTimeProperty(PartialDate partialDate) {
        this.setPartialDate(partialDate);
    }

    public DateOrTimeProperty(String text) {
        this.setText(text);
    }

    public DateOrTimeProperty(DateOrTimeProperty original) {
        super(original);
        this.text = original.text;
        this.date = original.date;
        this.partialDate = original.partialDate;
    }

    public Temporal getDate() {
        return this.date;
    }

    public void setDate(Temporal date) {
        this.date = date;
        this.text = null;
        this.partialDate = null;
    }

    public PartialDate getPartialDate() {
        return this.partialDate;
    }

    public void setPartialDate(PartialDate partialDate) {
        this.partialDate = partialDate;
        this.text = null;
        this.date = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.date = null;
        this.partialDate = null;
    }

    public Calscale getCalscale() {
        return this.parameters.getCalscale();
    }

    public void setCalscale(Calscale calscale) {
        this.parameters.setCalscale(calscale);
    }

    @Override
    public String getLanguage() {
        return super.getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        super.setLanguage(language);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.date == null && this.partialDate == null && this.text == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
        if (version == VCardVersion.V2_1 || version == VCardVersion.V3_0) {
            if (this.text != null) {
                warnings.add(new ValidationWarning(11, new Object[0]));
            }
            if (this.partialDate != null) {
                warnings.add(new ValidationWarning(12, new Object[0]));
            }
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("text", this.text);
        values.put("date", this.date);
        values.put("partialDate", this.partialDate);
        return values;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.date, this.partialDate, this.text);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateOrTimeProperty other = (DateOrTimeProperty)obj;
        return Objects.equals(this.date, other.date) && Objects.equals(this.partialDate, other.partialDate) && Objects.equals(this.text, other.text);
    }
}

