/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.SupportedVersions;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.property.VCardProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@SupportedVersions(value={VCardVersion.V4_0})
public class Gender
extends VCardProperty {
    public static final String MALE = "M";
    public static final String FEMALE = "F";
    public static final String OTHER = "O";
    public static final String NONE = "N";
    public static final String UNKNOWN = "U";
    private String gender;
    private String text;

    public Gender(String gender) {
        this.gender = gender;
    }

    public Gender(Gender original) {
        super(original);
        this.gender = original.gender;
        this.text = original.text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public boolean isMale() {
        return MALE.equals(this.gender);
    }

    public boolean isFemale() {
        return FEMALE.equals(this.gender);
    }

    public boolean isOther() {
        return OTHER.equals(this.gender);
    }

    public boolean isNone() {
        return NONE.equals(this.gender);
    }

    public boolean isUnknown() {
        return UNKNOWN.equals(this.gender);
    }

    public static Gender male() {
        return new Gender(MALE);
    }

    public static Gender female() {
        return new Gender(FEMALE);
    }

    public static Gender other() {
        return new Gender(OTHER);
    }

    public static Gender none() {
        return new Gender(NONE);
    }

    public static Gender unknown() {
        return new Gender(UNKNOWN);
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.gender == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("gender", this.gender);
        values.put("text", this.text);
        return values;
    }

    @Override
    public Gender copy() {
        return new Gender(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.gender == null ? 0 : this.gender.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Gender other = (Gender)obj;
        if (this.gender == null ? other.gender != null : !this.gender.equals(other.gender)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

