/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.parameter.Pid;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Timezone
extends VCardProperty
implements HasAltId {
    private ZoneOffset offset;
    private String text;

    public Timezone(String text) {
        this(null, text);
    }

    public Timezone(ZoneOffset offset) {
        this(offset, null);
    }

    public Timezone(ZoneOffset offset, String text) {
        this.setOffset(offset);
        this.setText(text);
    }

    public Timezone(ZoneId timezone) {
        this(OffsetDateTime.now(timezone).getOffset(), timezone.getId());
    }

    public Timezone(Timezone original) {
        super(original);
        this.offset = original.offset;
        this.text = original.text;
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public void setOffset(ZoneOffset offset) {
        this.offset = offset;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ZoneId toTimeZone() {
        if (this.text != null) {
            try {
                return ZoneId.of(this.text);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        if (this.offset != null) {
            return this.offset;
        }
        return null;
    }

    public String getType() {
        return this.parameters.getType();
    }

    public void setType(String type) {
        this.parameters.setType(type);
    }

    public String getMediaType() {
        return this.parameters.getMediaType();
    }

    public void setMediaType(String mediaType) {
        this.parameters.setMediaType(mediaType);
    }

    @Override
    public List<Pid> getPids() {
        return super.getPids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.offset == null && this.text == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
        if (this.offset == null && version == VCardVersion.V2_1) {
            warnings.add(new ValidationWarning(20, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("offset", this.offset);
        values.put("text", this.text);
        return values;
    }

    @Override
    public Timezone copy() {
        return new Timezone(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Timezone other = (Timezone)obj;
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

