/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.event.ConsoleMessageReceived;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.logging.Level;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.media.MediaDevice;
import com.teamdev.jxbrowser.media.callback.SelectMediaDeviceCallback;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFailed;
import com.teamdev.jxbrowser.navigation.event.NavigationFinished;
import com.teamdev.jxbrowser.permission.PermissionType;
import com.teamdev.jxbrowser.permission.callback.RequestPermissionCallback;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.jar.JarFile;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javax.net.ssl.HttpsURLConnection;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.ssl.TrustSSLProvider;
import net.sipsnet.client.views.mainview.MainViewSceneController;

public class JXBrowserHelper {
    private String parentUrl = null;
    private MyAction onNavigationFinished;
    private MyAction onInitiated;
    private BrowserView browserView;
    private Browser jxBrowser;
    private Engine engine;
    private HBox urlBox;
    private boolean isProcessing = false;
    private static JXBrowserHelper jxBrowserHelper;

    public static void checkJXBrowserExists() {
        String resourcesJarPath = System.getProperty("user.dir") + File.separator + "bin" + File.separator + "jxbrowser.jar";
        try (JarFile jarFile = new JarFile(resourcesJarPath);){
            MainViewSceneController.setIsJXBrowserExists(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public BrowserView getBrowserView() {
        return this.browserView;
    }

    public static JXBrowserHelper getInstance() {
        if (jxBrowserHelper == null) {
            jxBrowserHelper = new JXBrowserHelper();
        }
        return jxBrowserHelper;
    }

    public void initJXBrowser(MyAction onInitiated, MyAction onNavigationFinished) {
        if (this.isProcessing) {
            return;
        }
        this.onNavigationFinished = onNavigationFinished;
        this.onInitiated = onInitiated;
        this.isProcessing = true;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initJXBrowser start initiate");
        System.setProperty("jxbrowser.logging.file", "./log/jxbrowser.log");
        Logger.level((Level)Level.DEBUG);
        TrustSSLProvider trustAllSSLProvider = new TrustSSLProvider();
        HttpsURLConnection.setDefaultSSLSocketFactory(trustAllSSLProvider.getSslSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(trustAllSSLProvider.getHostNameVerifier());
        EngineOptions options = EngineOptions.newBuilder((RenderingMode)RenderingMode.OFF_SCREEN).licenseKey("21IZPXIHODHBVL8HHW8PHU4O9F3IAIADQVYIXGFZGLMHLR23TV1EIBC5WI4100PX6PCA81W0F6G2NTACUYT1KCG6PS3S6N4UX42T7CDP5GYKEYYZCASYWISL73QBMLFN5EYPJBXDIKH3E898PHM8TRDR9OMHMNG38ITM9S0FR33B").chromiumDir(Path.of(System.getProperty("user.dir"), "jxbrowser")).userDataDir(Path.of(System.getProperty("user.dir"), "jxbrowser", "data")).build();
        long start = System.currentTimeMillis();
        this.engine = Engine.newInstance((EngineOptions)options);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Start jxBrowser engine : " + (System.currentTimeMillis() - start) + " ms");
        TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().getMainViewModel().removeLoadingPane()).startWithDelay(700L);
        this.engine.permissions().set(RequestPermissionCallback.class, (Callback)((RequestPermissionCallback)(params, action) -> {
            if (params.permissionType() == PermissionType.AUDIO_CAPTURE || params.permissionType() == PermissionType.VIDEO_CAPTURE) {
                action.grant();
            } else {
                action.deny();
            }
        }));
        this.engine.mediaDevices().set(SelectMediaDeviceCallback.class, (Callback)((SelectMediaDeviceCallback)params -> SelectMediaDeviceCallback.Response.select((MediaDevice)((MediaDevice)params.mediaDevices().get(0)))));
        this.jxBrowser = this.engine.newBrowser();
        this.jxBrowser.on(ConsoleMessageReceived.class, event -> ClientSingleton.toLog(this.getClass().getSimpleName(), "ConsoleMessageReceived : " + event.consoleMessage()));
        this.jxBrowser.navigation().on(FrameLoadFailed.class, event -> ClientSingleton.toLog(this.getClass().getSimpleName(), "FrameLoadFailed : " + event.url()));
        this.jxBrowser.navigation().on(NavigationFinished.class, event -> {
            String url = event.url();
            boolean hasCommitted = event.hasCommitted();
            boolean isSameDocument = event.isSameDocument();
            boolean isErrorPage = event.isErrorPage();
            if (isErrorPage) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "NavigationFinished with error : " + event.error() + " " + url);
            } else if (url != null && this.parentUrl != null && this.urlBox != null) {
                if (url.startsWith(this.rootUrl(this.parentUrl))) {
                    this.urlBox.setId(url);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "NavigationFinished : " + url);
                }
                if (this.onNavigationFinished != null) {
                    this.onNavigationFinished.execute();
                }
            }
        });
        this.browserView = BrowserView.newInstance(this.jxBrowser);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initJXBrowser initiate done");
        this.isProcessing = false;
        if (this.onInitiated != null) {
            this.onInitiated.execute();
            this.onInitiated = null;
        }
    }

    public void setOnInitiated(MyAction onInitiated) {
        this.onInitiated = onInitiated;
    }

    public void closeBrowser() {
        this.parentUrl = null;
        this.browserView.prefHeightProperty().unbind();
        this.browserView.prefWidthProperty().unbind();
        this.jxBrowser.close();
        this.engine.close();
        this.browserView = null;
    }

    public void bindTo(StackPane fx_spWithWebView) throws Exception {
        this.browserView.prefHeightProperty().unbind();
        this.browserView.prefWidthProperty().unbind();
        this.browserView.prefHeightProperty().bind((ObservableValue)fx_spWithWebView.heightProperty());
        this.browserView.prefWidthProperty().bind((ObservableValue)fx_spWithWebView.widthProperty());
    }

    public void loadUrl(Object urlBox) {
        TimerExecutor.getInstance().start(() -> {
            block5: {
                if (urlBox instanceof HBox) {
                    this.parentUrl = ((HBox)urlBox).getId();
                    this.urlBox = (HBox)urlBox;
                } else {
                    this.parentUrl = urlBox.toString();
                }
                try {
                    this.jxBrowser.navigation().loadUrlAndWait(this.parentUrl, Duration.ofSeconds(15L));
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "loadUrl : " + this.parentUrl);
                }
                catch (Exception ex) {
                    if (ex.getMessage() != null && !ex.getMessage().contains("ABORTED")) {
                        this.parentUrl = null;
                        ex.printStackTrace();
                    }
                    if (this.onNavigationFinished == null) break block5;
                    this.onNavigationFinished.execute();
                }
            }
        });
    }

    private String rootUrl(String url) {
        int index = 0;
        index = url.startsWith("https://") ? url.indexOf("/", 9) : (url.startsWith("http://") ? url.indexOf("/", 8) : url.indexOf("/"));
        if (index != -1 && index < url.length()) {
            return url.substring(0, index);
        }
        return url;
    }
}

