/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client;

import io.reactivex.Observable;
import io.reactivex.exceptions.UndeliverableException;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.PublishSubject;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.Taskbar;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import net.sipsnet.client.JXBrowserHelper;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.image.ImageUtil;
import net.sipsnet.client.utils.mac_menubar.StandardMacApp;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.threadpool.NotificationThreadPoolManager;
import net.sipsnet.client.views.mainview.MainViewSceneController;

public class UserClient
extends Application
implements IGUIObservable {
    private static TrayIcon trayIcon;
    private static PublishSubject<Throwable> onErrorObserver;
    private Stage parentWindow;

    public void init() throws Exception {
        ClientSingleton.setConsoleLog();
        Thread.setDefaultUncaughtExceptionHandler(UserClient::showError);
        RxJavaPlugins.setErrorHandler(e -> {
            e.printStackTrace();
            if (e instanceof UndeliverableException) {
                e = e.getCause();
            }
        });
        ClientSingleton.toLog("UserClient", "init package name : " + ClientSingleton.getInstance().getPackageName());
        Locale locale = Locale.getDefault();
        String lang = locale.getDisplayLanguage();
        String country = locale.getDisplayCountry();
        ResourceBundle bundles = null;
        try {
            bundles = ResourceBundle.getBundle("bundles.strings", locale);
        }
        catch (Exception ex) {
            try {
                bundles = ResourceBundle.getBundle("bundles.strings", new Locale("en"));
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        ClientSingleton.toLog("UserClient", "UserClient bundles");
        ClientSingleton.getInstance().setResourceBundle(bundles);
        ClientSingleton.getInstance().setCurrentLanguage(lang);
        ClientSingleton.toLog("Main", "ClientUtil.getOS()=" + ClientUtil.getOS());
        try {
            JXBrowserHelper.checkJXBrowserExists();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClientSingleton.toLog("Main", "isJXBrowserExists=" + MainViewSceneController.isJXBrowserExists());
    }

    public void start(Stage stage) throws Exception {
        ClientSingleton.toLog("UserClient", "UserClient start  ");
        Application.Parameters params = this.getParameters();
        ClientSingleton.toLog("UserClient", "UserClient params = " + params.getNamed());
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        ClientSingleton.toLog("UserClient", System.getProperty("java.vm.name") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
        List<String> arguments = runtimeMxBean.getInputArguments();
        if (arguments != null) {
            arguments.forEach(argument -> ClientSingleton.toLog("UserClient", "jvm arg=" + argument));
        }
        this.parentWindow = stage;
        this.parentWindow.initStyle(StageStyle.TRANSPARENT);
        this.parentWindow.setResizable(true);
        this.parentWindow.setTitle(ClientSingleton.getInstance().getPackageName());
        this.parentWindow.setOnCloseRequest(we -> {
            ClientSingleton.toLog("UserClient", "Stage is closing ");
            UserClient.exitRingotel(true);
        });
        String[] actions = new String[]{Constants.OPEN_EMAIL_APP};
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            UserClient.setTrayIcon();
        }
        ClientSingleton.getInstance().addObserver(this, actions);
        ClientSingleton.getInstance().initMainController(this.parentWindow);
        ClientSingleton.toLog("UserClient", System.currentTimeMillis() + " createClientConnector: start");
        String path = "taskbar/logo.png";
        ClientSingleton.getInstance().runLater(() -> ClientSingleton.getInstance().getImageFromResources(path).ifPresent(image -> this.parentWindow.getIcons().add(0, image)));
        ClientSingleton.getInstance().loadRegistrationScene();
    }

    private static void showError(Thread t, Throwable e) {
        if (e.getMessage().contains("\"javafx.stage.Window.isShowing()\" because the return value of \"com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow.toolkitWindow()\" is null")) {
            return;
        }
        ClientSingleton.memoryReport();
        ClientSingleton.toLog("UserClient", "---------------------------------------");
        if (e instanceof IndexOutOfBoundsException || e.getMessage().contains("Cannot read the array length because \"this.runs\" is null")) {
            if (onErrorObserver == null) {
                UserClient.initUpdateObserver();
            }
            onErrorObserver.onNext((Object)e);
        }
    }

    private static String getLogMessage(Throwable e) {
        StringWriter stackTrace = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTrace);
        e.printStackTrace(printWriter);
        String message = stackTrace.toString();
        return message.contains("net.sipsnet.client") ? message : e.getLocalizedMessage();
    }

    public static void setTrayIcon() {
        ClientSingleton.toLog("UserClient", "SystemTray.isSupported() = " + SystemTray.isSupported());
        if (SystemTray.isSupported()) {
            ResourceBundle bundle = ClientSingleton.getInstance().getResourceBundle();
            if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
                PopupMenu popup = new PopupMenu();
                MenuItem defaultItem = new MenuItem(bundle.getString("notify_press") + " " + ClientSingleton.getInstance().getPackageName());
                defaultItem.addActionListener(event -> {
                    if (!ClientSingleton.getInstance().isRegistrationPaneShow()) {
                        ClientSingleton.getInstance().showWindow();
                    }
                });
                popup.add(defaultItem);
                defaultItem = new MenuItem(bundle.getString("notify_exit") + " " + ClientSingleton.getInstance().getPackageName());
                defaultItem.addActionListener(listener -> UserClient.exitRingotel(true));
                popup.add(defaultItem);
                SystemTray tray = SystemTray.getSystemTray();
                BufferedImage bImage = ImageUtil.getPngBufferedImage("taskbar/logo_tray.png");
                ClientSingleton.toLog("UserClient", "SystemTray bImage = " + bImage);
                if (bImage == null) {
                    return;
                }
                try {
                    trayIcon = new TrayIcon(UserClient.getScaledImage(bImage), ClientSingleton.getInstance().getPackageName(), popup);
                    tray.add(trayIcon);
                    trayIcon.addMouseListener(new MouseListener(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (!ClientSingleton.getInstance().isRegistrationPaneShow() && ClientSingleton.getInstance().isRegistered() && e.getButton() == 1) {
                                ClientSingleton.getInstance().showWindow();
                            }
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                        }
                    });
                }
                catch (AWTException e) {
                    e.printStackTrace();
                }
            } else if (ClientUtil.getOS() == ClientUtil.OS.LINUX) {
                UserClient.setTaskBarImage_Linux(false);
            } else if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
                UserClient.setTaskBarImage_Mac(false);
                ClientSingleton.getInstance().runLater(() -> {
                    try {
                        StandardMacApp.createMacMenuBar();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        } else if (ClientUtil.getOS() == ClientUtil.OS.LINUX) {
            UserClient.setTaskBarImage_Linux(false);
        } else if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            UserClient.setTaskBarImage_Mac(false);
            ClientSingleton.getInstance().runLater(() -> {
                try {
                    StandardMacApp.createMacMenuBar();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public static void setTaskBarImage_Mac(boolean withNotification) {
        Taskbar taskbar = Taskbar.getTaskbar();
        try {
            BufferedImage bImage = ImageUtil.getPngBufferedImage(withNotification ? "taskbar/notification_mac.png" : "taskbar/logo_tray_mac.png");
            if (bImage == null) {
                return;
            }
            taskbar.setIconImage(bImage);
            ClientSingleton.toLog("ImageUtil", "getPngBufferedImage taskbar : " + taskbar.getIconImage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setTaskBarImage_Linux(boolean withNotification) {
        ClientSingleton.getInstance().runLater(() -> {
            ClientSingleton.getInstance().getParentWindow().getIcons().clear();
            ClientSingleton.getInstance().getImageFromResources(withNotification ? "taskbar/notification_mac.png" : "taskbar/logo_tray_mac.png").ifPresent(image -> ClientSingleton.getInstance().getParentWindow().getIcons().add(image));
        });
    }

    public static void setTrayIconImage(boolean withNotification) {
        if (trayIcon == null) {
            UserClient.setTrayIcon();
        }
        try {
            BufferedImage bImage = ImageUtil.getPngBufferedImage(withNotification ? "taskbar/notification_tray.png" : "taskbar/logo_tray.png");
            if (bImage == null) {
                return;
            }
            trayIcon.setImage(UserClient.getScaledImage(bImage));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static BufferedImage getScaledImage(Image image) {
        BufferedImage resizedImg = new BufferedImage(16, 16, 3);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, 16, 16, null);
        g2.dispose();
        return resizedImg;
    }

    public static void exitRingotel(boolean unreg) {
        ClientSingleton.toLog("UserClient", "exitRingotel call onExit = " + ClientSingleton.getInstance().getParentWindow().getWidth() + " isRegistered = " + ClientSingleton.getInstance().isRegistered());
        UserClient.onExit(unreg);
        ClientSingleton.getInstance().shutDownClientObserver();
        NotificationThreadPoolManager.getInstance().shutDownNow();
        ClientSingleton.getInstance().closeServices();
        TimerExecutor.getInstance().setMyAction(() -> {
            MyThreadPoolManager.getInstance().shutDownNow();
            Platform.runLater(Platform::exit);
        }).startWithDelay(1000L);
    }

    public static void onExit(boolean unreg) {
        if (ClientSingleton.getInstance().isRegistered()) {
            ClientSingleton.getInstance().runLater(() -> ClientSingleton.getInstance().getParentWindow().toBack());
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (Boolean.TRUE.equals(unreg) && !clientConnector.onExit(unreg)) {
                    clientConnector.onExit(false);
                }
            });
        }
        Platform.setImplicitExit((boolean)true);
        try {
            if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
                try {
                    SystemTray tray = SystemTray.getSystemTray();
                    tray.remove(trayIcon);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
                ClientSingleton.getInstance().runLater(() -> {
                    try {
                        StandardMacApp.hide();
                        Taskbar taskbar = Taskbar.getTaskbar();
                        taskbar.setIconImage(null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            System.setProperty("prism.lcdtext", "false");
            System.setProperty("com.sun.webkit.useHTTP2Loader", "false");
            Platform.setImplicitExit((boolean)false);
            ClientSingleton.toLog("Main", "ClientUtil.getOS()=" + ClientUtil.getOS());
            Application.launch((String[])args);
        }
        catch (Throwable th) {
            th.printStackTrace();
            ClientSingleton.getInstance().runLater(() -> ClientSingleton.getInstance().showAlert(th.toString()));
        }
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        ClientSingleton.toLog("Main", "notifyMessage_ action=" + action);
        if (action.equals(Constants.OPEN_EMAIL_APP)) {
            String email = (String)data.get("serviceAction");
            HostServices hostServices = this.getHostServices();
            hostServices.showDocument("mailto:" + email);
        }
    }

    private void initRXLibs() {
        String[] rxLibs = new String[]{"rxjava.java", "rxjavafx.java", "reactive-streams.java"};
        for (int i = 0; i < rxLibs.length; ++i) {
            String libFile = rxLibs[i];
            try (InputStream is = UserClient.class.getResourceAsStream("/" + libFile);){
                File lib = null;
                try {
                    lib = File.createTempFile("jna", "." + libFile);
                    lib.deleteOnExit();
                    System.out.println("Create lib=" + lib);
                }
                catch (IOException e) {
                    throw new UnsatisfiedLinkError("Can't create " + libFile + " in the filesystem nor in the classpath");
                }
                try (FileOutputStream fos = new FileOutputStream(lib);){
                    int count;
                    byte[] buf = new byte[1024];
                    while ((count = is.read(buf, 0, buf.length)) > 0) {
                        fos.write(buf, 0, count);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new UnsatisfiedLinkError("Can't create " + libFile + " in the filesystem nor in the classpath");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void memoryUsage() {
        System.out.println(" \t " + Runtime.getRuntime().freeMemory() + " \t \t " + Runtime.getRuntime().totalMemory() + " \t \t " + Runtime.getRuntime().maxMemory());
    }

    private static void initUpdateObserver() {
        onErrorObserver = PublishSubject.create();
        onErrorObserver.debounce(700L, TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).switchMap(Observable::just).subscribe(throwable -> {
            throwable.printStackTrace();
            ClientSingleton.getInstance().getMainViewModel().invalidateViews();
        }, Throwable::printStackTrace);
    }
}

