/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.bluetooth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import net.sipsnet.client.bluetooth.BluetoothServiceSearch;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;

public class BluetoothController {
    private final AtomicReference<RemoteDevice> connectedDevice = new AtomicReference();
    private boolean down = false;
    private StreamConnectionNotifier notifier;
    private static final String myServiceName = "MyBtService";
    private static final String myServiceUUID = "2d26618601fb47c28d9f10b8ec891363";
    private final UUID MYSERVICEUUID_UUID = new UUID("2d26618601fb47c28d9f10b8ec891363", false);

    public void create() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "create BluetoothServiceSearch");
        this.close();
        BluetoothServiceSearch bluetoothServiceSearch = new BluetoothServiceSearch();
        Map<String, RemoteDevice> bluetoothDevices = bluetoothServiceSearch.getBluetoothDevices();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "bluetoothDevices=" + bluetoothDevices);
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        AtomicReference<LocalDevice> localDevice = new AtomicReference<LocalDevice>();
        try {
            LocalDevice device = LocalDevice.getLocalDevice();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "LocalDevice.getLocalDevice() device=" + device + "\nAddress : " + device.getBluetoothAddress() + "\nName : " + device.getFriendlyName() + "\nPowered : " + LocalDevice.isPowerOn() + "\ngetDeviceClass : " + device.getDeviceClass());
            localDevice.set(device);
            for (Mixer.Info info : mixerInfo) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "info.getName()=" + info.getName());
                if (!info.getClass().getSimpleName().contains("DirectAudioDeviceInfo")) continue;
                bluetoothDevices.values().forEach(remoteDevice -> {
                    try {
                        if (info.getName().contains(remoteDevice.getFriendlyName(false))) {
                            this.connectedDevice.set((RemoteDevice)remoteDevice);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "connectedDevice=" + this.connectedDevice);
        if (this.connectedDevice.get() != null) {
            this.down = false;
            MyThreadPoolManager.getInstance().execute(() -> {
                try {
                    ((LocalDevice)localDevice.get()).setDiscoverable(10390323);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (!this.down) {
                    try {
                        String connURL = "btspp://localhost:" + this.MYSERVICEUUID_UUID + ";name=MyBtService";
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "connURL=" + connURL);
                        this.notifier = (StreamConnectionNotifier)Connector.open((String)connURL);
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "notifier=" + this.notifier);
                        StreamConnection connection = this.notifier.acceptAndOpen();
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "connection=" + connection);
                        RemoteDevice rd = RemoteDevice.getRemoteDevice((Connection)connection);
                        System.out.println("New client connection... " + rd.getFriendlyName(false));
                        try (DataInputStream dataIn = connection.openDataInputStream();){
                            String s = dataIn.readUTF();
                            ClientSingleton.toLog(this.getClass().getSimpleName(), "BluetoothConnectionTask s=" + s);
                            connection.close();
                        }
                        this.notifier.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.down = true;
                    }
                    System.out.println("AFTER DATA RECIEVED");
                }
            });
        }
    }

    public void close() {
        if (this.notifier != null) {
            try {
                this.notifier.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.notifier = null;
        }
        this.connectedDevice.set(null);
        this.down = true;
    }

    public void btConnect(final ServiceRecord sr) {
        Thread th = new Thread(){

            @Override
            public void run() {
                System.out.println("BTMIDlet.btConnect.run()");
                RemoteDevice rd = sr.getHostDevice();
                String connectionURL = sr.getConnectionURL(0, false);
                try {
                    System.out.println("Connecting to " + rd.getFriendlyName(false));
                    System.out.println("Connecting to " + rd.getFriendlyName(false) + ", " + connectionURL);
                    StreamConnection streamConnection = (StreamConnection)Connector.open((String)connectionURL);
                    DataOutputStream dataout = streamConnection.openDataOutputStream();
                    dataout.writeUTF("messageOut");
                    System.out.println("Closing");
                    streamConnection.close();
                }
                catch (IOException ioe) {
                    System.out.println("BTMIDlet.btConnect, exception &" + ioe);
                }
            }
        };
        th.start();
    }
}

