/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.bluetooth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import net.sipsnet.client.connector.ClientSingleton;

public class BluetoothServiceSearch {
    private final UUID OBEX_OBJECT_PUSH_PROFILE = new UUID(4357L);
    private final UUID OBEX_FILE_TRANSFER_PROFILE = new UUID(4358L);
    private final UUID HANDS_FREE = new UUID(4382L);
    private final int URL_ATTRIBUTE = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, RemoteDevice> getBluetoothDevices() {
        UUID[] searchUuidSet = new UUID[]{this.HANDS_FREE};
        final Object serviceSearchCompletedEvent = new Object();
        int[] attrIDs = new int[]{256};
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getBluetoothDevices");
        final HashMap<String, RemoteDevice> mapReturnResult = new HashMap<String, RemoteDevice>();
        try {
            DiscoveryListener listener = new DiscoveryListener(){

                public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
                }

                public void inquiryCompleted(int discType) {
                }

                public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
                    for (int i = 0; i < servRecord.length; ++i) {
                        String url = servRecord[i].getConnectionURL(0, false);
                        if (url == null) continue;
                        String temporaryString = "";
                        RemoteDevice rd = servRecord[i].getHostDevice();
                        try {
                            mapReturnResult.put(rd.getFriendlyName(false), rd);
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void serviceSearchCompleted(int transID, int respCode) {
                    Object object = serviceSearchCompletedEvent;
                    synchronized (object) {
                        serviceSearchCompletedEvent.notifyAll();
                    }
                }
            };
            for (RemoteDevice remoteDevice : this.getDevices()) {
                mapReturnResult.put(remoteDevice.getFriendlyName(false), remoteDevice);
                Object object = serviceSearchCompletedEvent;
                synchronized (object) {
                    LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(attrIDs, searchUuidSet, remoteDevice, listener);
                    serviceSearchCompletedEvent.wait();
                }
            }
            return mapReturnResult;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapReturnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RemoteDevice> getDevices() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getDevices");
        final ArrayList<RemoteDevice> devicesDiscovered = new ArrayList<RemoteDevice>();
        try {
            RemoteDevice[] devices;
            final Object inquiryCompletedEvent = new Object();
            LocalDevice device = LocalDevice.getLocalDevice();
            for (RemoteDevice d : devices = device.getDiscoveryAgent().retrieveDevices(1)) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "RemoteDevice  Adress : " + d.getBluetoothAddress() + "\nName : " + d.getFriendlyName(false) + "\nAuthenticated : " + d.isAuthenticated() + "\nTrusted : " + d.isTrustedDevice());
            }
            DiscoveryListener listener = new DiscoveryListener(){

                public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
                    devicesDiscovered.add(btDevice);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void inquiryCompleted(int discType) {
                    Object object = inquiryCompletedEvent;
                    synchronized (object) {
                        inquiryCompletedEvent.notifyAll();
                    }
                }

                public void serviceSearchCompleted(int transID, int respCode) {
                }

                public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
                }
            };
            Object object = inquiryCompletedEvent;
            synchronized (object) {
                boolean started = LocalDevice.getLocalDevice().getDiscoveryAgent().startInquiry(10390323, listener);
                if (started) {
                    System.out.println("wait for device inquiry to complete...");
                    inquiryCompletedEvent.wait();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return devicesDiscovered;
    }
}

