/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.bluetooth;

import com.intel.bluetooth.BluetoothConsts;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;

public class BluetoothTest
implements DiscoveryListener {
    private final UUID hidServiceId = new UUID("0011", true);
    private final UUID ftpServiceId = new UUID("1106", true);
    private final UUID HANDS_FREE = new UUID(4382L);
    private final UUID[] serviceIdTable = new UUID[]{this.HANDS_FREE};
    private final UUID protocolId = BluetoothConsts.RFCOMM_PROTOCOL_UUID;
    private final Queue<RemoteDevice> foundRemoteDevices = new ConcurrentLinkedQueue<RemoteDevice>();
    private final Queue<ServiceRecord> foundRemoteServices = new ConcurrentLinkedQueue<ServiceRecord>();

    private void startDeviceAccessTest() {
        block16: {
            try {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "startDeviceAccessTest " + LocalDevice.isPowerOn());
                if (!LocalDevice.isPowerOn()) break block16;
                LocalDevice ld = LocalDevice.getLocalDevice();
                String sLocalName = ld.getFriendlyName();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "mein Ger\u00e4t hei\u00dft: {0}" + sLocalName);
                DiscoveryAgent agent = ld.getDiscoveryAgent();
                RemoteDevice[] knownPairingPartners = agent.retrieveDevices(1);
                if (knownPairingPartners != null) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "Meine Freunde hei\u00dfen: ");
                    for (RemoteDevice rd : knownPairingPartners) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "{0}" + rd.getFriendlyName(false) + " : {1}" + rd.getBluetoothAddress());
                    }
                }
                this.foundRemoteDevices.clear();
                agent.startInquiry(10390323, (DiscoveryListener)this);
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Ger\u00e4tesuche gestartet");
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Ger\u00e4tesuche warten beendet");
                RemoteDevice myRD = null;
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Ger\u00e4te gefunden: ");
                while (!this.foundRemoteDevices.isEmpty()) {
                    RemoteDevice device = this.foundRemoteDevices.poll();
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "{0} " + device.getFriendlyName(false) + ": {1}" + device.getBluetoothAddress());
                    if (!device.getFriendlyName(false).equals("Poly V5200 Series")) continue;
                    myRD = device;
                }
                if (myRD == null) break block16;
                this.foundRemoteServices.clear();
                agent.searchServices(null, this.serviceIdTable, myRD, (DiscoveryListener)this);
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Servicesuche gestartet");
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException device) {
                    // empty catch block
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Servicesuche warten beendet foundRemoteServices.isEmpty()=" + this.foundRemoteServices.isEmpty());
                if (!this.foundRemoteServices.isEmpty()) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "Services gefunden: ");
                    String url = null;
                    while (!this.foundRemoteServices.isEmpty()) {
                        ServiceRecord record = this.foundRemoteServices.poll();
                        if (url == null) {
                            url = record.getConnectionURL(0, false);
                        }
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "url: {0} " + url);
                    }
                    if (url != null) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "versuche connection: {0} " + url);
                        StreamConnection connection = (StreamConnection)Connector.open(url);
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "Connection ge\u00f6ffnet");
                        if (myRD.isAuthorized((Connection)connection) && myRD.isEncrypted()) {
                            ClientSingleton.toLog(this.getClass().getSimpleName(), "yippie!");
                        } else {
                            ClientSingleton.toLog(this.getClass().getSimpleName(), "kacka!");
                        }
                        connection.close();
                    }
                } else {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "keine Services gefunden");
                }
            }
            catch (Exception ex) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Huston we have a problem: {0} " + ex);
            }
        }
    }

    public BluetoothTest() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "BluetoothTest");
        TimerExecutor.getInstance().start(this::startDeviceAccessTest);
    }

    public void deviceDiscovered(RemoteDevice rd, DeviceClass dc) {
        this.foundRemoteDevices.add(rd);
    }

    public void servicesDiscovered(int i, ServiceRecord[] srs) {
        this.foundRemoteServices.addAll(Arrays.asList(srs));
    }

    public void serviceSearchCompleted(int i, int i1) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Servicesuche thread beendet");
    }

    public void inquiryCompleted(int i) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Ger\u00e4tesuche thread beendet");
    }
}

