/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.click2dial;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.TimeUnit;
import net.sipsnet.client.click2dial.Click2Dial;
import net.sipsnet.client.click2dial.GetSelectedText;
import net.sipsnet.client.connector.ClientSingleton;

public class KeyHook {
    private static boolean down = false;
    private static WinUser.HHOOK hhk;
    private static User32 lib;
    private static PublishSubject<String> makeCallObserver;
    private static CompositeDisposable disposable;

    private KeyHook() {
    }

    public static void startHookTheKey() {
        new Thread(() -> {
            int result;
            lib = null;
            try {
                lib = User32.INSTANCE;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (lib == null) {
                return;
            }
            KeyHook.initUpdateObserver();
            ClientSingleton.toLog("KeyHook", "startHookTheKey");
            WinDef.HMODULE hMod = Kernel32.INSTANCE.GetModuleHandle(null);
            WinUser.LowLevelKeyboardProc keyboardHook = (nCode, wParam, info) -> {
                if (nCode >= 0) {
                    switch (wParam.intValue()) {
                        case 256: {
                            if (info.vkCode == 19 || lib.GetAsyncKeyState(162) != 0 && info.vkCode == 117) {
                                ClientSingleton.toLog("KeyHook", "get Key : " + info.vkCode);
                                KeyHook.makeCall();
                                break;
                            }
                            if (!(lib.GetAsyncKeyState(162) != 0 ? info.vkCode != 38 && info.vkCode == 40 : lib.GetAsyncKeyState(160) == 0 || info.vkCode == 77 || info.vkCode == 72)) break;
                            break;
                        }
                    }
                }
                Pointer ptr = info.getPointer();
                long peer = Pointer.nativeValue((Pointer)ptr);
                return lib.CallNextHookEx(hhk, nCode, wParam, new WinDef.LPARAM(peer));
            };
            hhk = lib.SetWindowsHookEx(13, (WinUser.HOOKPROC)keyboardHook, (WinDef.HINSTANCE)hMod, 0);
            if (hhk == null) {
                ClientSingleton.toLog("KeyHook", "Error registered hook");
                return;
            }
            WinUser.MSG msg = new WinUser.MSG();
            ClientSingleton.toLog("KeyHook", "looking for result");
            while ((result = lib.GetMessage(msg, null, 0, 0)) != 0 && !down) {
                if (result == -1) {
                    ClientSingleton.toLog("KeyHook", "error in get message");
                    break;
                }
                ClientSingleton.toLog("KeyHook", "got message msg=" + msg);
                lib.TranslateMessage(msg);
                lib.DispatchMessage(msg);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            lib.UnhookWindowsHookEx(hhk);
            ClientSingleton.toLog("KeyHook", "unhook and down");
        }).start();
    }

    public static void stopHookTheKey() {
        ClientSingleton.toLog("KeyHook", "stopHookTheKey");
        down = true;
        KeyHook.sendKey();
        if (lib != null && hhk != null) {
            lib.UnhookWindowsHookEx(hhk);
        }
        KeyHook.dispose();
    }

    private static void makeCall() {
        String number = GetSelectedText.getSelectedText();
        ClientSingleton.toLog("KeyHook", "in callback, number =" + number);
        if (number != null && !number.isEmpty()) {
            makeCallObserver.onNext((Object)number);
        }
    }

    private static void sendKey() {
        WinUser.INPUT input = new WinUser.INPUT();
        input.input.ki.wVk = new WinDef.WORD(65L);
        input.input.ki.dwFlags = new WinDef.DWORD(0L);
        User32.INSTANCE.SendInput(new WinDef.DWORD(1L), (WinUser.INPUT[])input.toArray(1), input.size());
        input.input.ki.wVk = new WinDef.WORD(65L);
        input.input.ki.dwFlags = new WinDef.DWORD(2L);
        User32.INSTANCE.SendInput(new WinDef.DWORD(1L), (WinUser.INPUT[])input.toArray(1), input.size());
    }

    private static void initUpdateObserver() {
        makeCallObserver = PublishSubject.create();
        if (disposable == null) {
            disposable = new CompositeDisposable();
        }
        disposable.add(makeCallObserver.debounce(300L, TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).switchMap(Observable::just).subscribe(number -> {
            ClientSingleton.toLog("KeyHook", "makeCall : " + number);
            Click2Dial.makeCall(number.trim());
        }, Throwable::printStackTrace));
    }

    public static void dispose() {
        if (disposable != null) {
            disposable.dispose();
            disposable.clear();
            disposable = null;
        }
        makeCallObserver = null;
    }
}

