/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector;

import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Timed;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.swing.JEditorPane;
import net.sipsnet.client.annotations.Version;
import net.sipsnet.client.bluetooth.BluetoothController;
import net.sipsnet.client.click2dial.Click2Dial;
import net.sipsnet.client.click2dial.Kernel32NamedPipe;
import net.sipsnet.client.click2dial.KeyHook;
import net.sipsnet.client.connector.ClientSingletonUtil;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.clientlisteners.ClientListenersModel;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.connector.utils.resources.ImageResource;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.MyPair;
import net.sipsnet.client.utils.image.ImageUtil;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.stage.ResizeHelper;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.usb.UsbHidController;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.MyAlert;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.contextmenu.MyContextMenu;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.calls.audiocontrolls.LineInfoPane;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.mainview.model.MainViewModel;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallDateHandler;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.reactfx.value.Var;
import smile.cti.client.ClientConnector;
import smile.cti.client.ClientEventListener;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;
import smile.util.MyLogger;
import smile.util.ResourceStore;
import smile.util.Utils;

@Version
public class ClientSingleton
extends ClientSingletonUtil {
    public static final String LOCATION_PREFIX = "https://www.google.com/maps/search/";
    private static ClientSingleton clientSingleton = null;
    private Kernel32NamedPipe kernel32NamedPipe;
    private UsbHidController usbHidController;
    private BluetoothController bluetoothController;
    private ResourceBundle resourceBundle;
    private ClientConnector clientConnector;
    private boolean isWithSpellControl;
    private final String TAG = this.getClass().getSimpleName();
    private ClientListenersModel clientListenersModel;
    private final ImageUtil imageUtil;
    private String currentLanguage;
    private Font currentFont;
    private MainViewModel mainViewModel;
    private final ClientUtil clientUtil;
    private ResizeHelper resizeHelper;
    private final Map<Text, String> mapLinksText = new HashMap<Text, String>();
    private MyContextMenu myContextMenu;
    private final List<String> openedPopupsList = new ArrayList<String>();
    private final List<String> openedMenusList = new ArrayList<String>();
    private boolean isChatWithTrunks;
    private boolean isConferenceOwner;
    private boolean notRegistered = true;
    private final SimpleStringProperty lastAction = new SimpleStringProperty();
    private String tmpTerminalId;
    private final Map<LineInfo, Boolean> lineInfoVideoMode = new HashMap<LineInfo, Boolean>();

    public boolean isConferenceOwner() {
        return this.isConferenceOwner;
    }

    public void setConferenceOwner(boolean conferenceOwner) {
        this.isConferenceOwner = conferenceOwner;
    }

    public void setNotRegistered(boolean notRegistered) {
        this.notRegistered = notRegistered;
    }

    public Collection<? extends ContactInfo> getContactFromGroupsList(String inputText) {
        ArrayList contactInfoList = new ArrayList();
        HashSet hashSet = (HashSet)this.clientConnector.getContactListNames();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getContactListNames()=" + hashSet);
        if (hashSet != null && !hashSet.isEmpty()) {
            ArrayList list = new ArrayList(hashSet);
            for (String title : list) {
                List ids = this.clientConnector.getContactList(title);
                if (ids == null || ids.isEmpty()) continue;
                contactInfoList.addAll(ids.stream().map(id -> this.clientConnector.getContact(id)).filter(contactInfo -> ClientSingleton.getInstance().isContactInfoInTheList((ContactInfo)contactInfo, inputText)).filter(this.distinctByKey(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList()));
            }
        }
        return contactInfoList;
    }

    public MyPair<Long, List<ContactInfo>> getServiceContacts(String serviceId, String prefix) {
        MyPair<Long, Object> myPair = null;
        try {
            ClientSingleton.toLog(this.TAG, " getServiceContacts start prefix=[" + prefix + "] serviceId=" + serviceId);
            List contacts = this.clientConnector.getServiceContacts(serviceId, prefix, (list, s) -> {
                ClientSingleton.toLog(this.TAG, " getServiceContacts listener prefix = " + prefix + " contacts=" + list.size() + " serviceid=" + serviceId);
                Collections.sort(list);
                this.mainViewModel.setServiceContacts(s, list);
            });
            ClientSingleton.toLog(this.TAG, " getServiceContacts prefix = " + prefix + " contacts=" + contacts.size());
            if (!contacts.isEmpty()) {
                Collections.sort(contacts);
            }
            myPair = new MyPair<Long, List>(System.currentTimeMillis(), contacts);
            if (prefix.isEmpty()) {
                ClientSingleton.toLog(this.TAG, " getServiceContacts done");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientSingleton.toLog(this.TAG, "Saving ServiceContacts - 123 " + e);
            myPair = new MyPair<Long, Object>(System.currentTimeMillis(), null);
            myPair.setLastException(e);
        }
        return myPair;
    }

    private ClientSingleton() {
        this.initValues();
        this.imageUtil = new ImageUtil();
        this.clientUtil = new ClientUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientSingleton getInstance() {
        Class<ClientSingleton> clazz = ClientSingleton.class;
        synchronized (ClientSingleton.class) {
            if (clientSingleton == null) {
                clientSingleton = new ClientSingleton();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return clientSingleton;
        }
    }

    public String getUserID(ContactInfo contactInfo) {
        if (contactInfo == null) {
            return "null";
        }
        Optional<String> userId = Optional.ofNullable(contactInfo.getUserID());
        return userId.orElseGet(() -> contactInfo.getId() == null ? String.valueOf(contactInfo.hashCode()) : contactInfo.getId());
    }

    public String getSessionId(SessionInfo sessionInfo) {
        Optional<String> userId = Optional.ofNullable(sessionInfo.getSessionId());
        return userId.orElseGet(() -> String.valueOf(sessionInfo.hashCode()));
    }

    public boolean isWithSpellControl() {
        return this.isWithSpellControl;
    }

    public MainViewModel getMainViewModel() {
        return this.mainViewModel;
    }

    public void initMainController(Stage parentWindow) {
        this.mainViewModel = new MainViewModel(parentWindow);
    }

    public Stage getParentWindow() {
        return this.mainViewModel.getParentWindow();
    }

    public void showWindow() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "showRingotel isShowing = " + this.mainViewModel.getParentWindow().isShowing() + " isIconified()" + this.mainViewModel.getParentWindow().isIconified());
        this.runLater(() -> {
            if (this.mainViewModel.getParentWindow().isIconified()) {
                ClientSingleton.getInstance().setIconified(false);
            }
            if (!this.mainViewModel.getParentWindow().isShowing()) {
                this.mainViewModel.getParentWindow().show();
            }
            this.mainViewModel.getParentWindow().toFront();
            this.mainViewModel.getParentWindow().requestFocus();
        });
    }

    public void setStatusBarIcon(int count) {
        this.mainViewModel.setStatusBarIcon(count);
    }

    public String getString(String name) {
        return this.getResourceBundle().getString(name);
    }

    public Font getCurrentFont() {
        return this.currentFont;
    }

    public void setCurrentFont(Font currentFont) {
        this.currentFont = currentFont;
    }

    public void setCurrentLanguage(String currentLanguage) {
        this.currentLanguage = currentLanguage;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public boolean isSound(FileInfo fileInfo) {
        return fileInfo.isSound() || fileInfo.getContent().toLowerCase().endsWith(".wav") || fileInfo.getContent().toLowerCase().endsWith(".mp3");
    }

    public synchronized void putWritableImage(String messageInfo, Image writableImage) {
        this.imageUtil.putWritableImage(messageInfo, writableImage);
    }

    public void setBackground(Pane pane, String backgroundPath) {
        this.imageUtil.setBackground(pane, backgroundPath);
    }

    public void setBackgroundInCenter(Pane pane, String path) {
        this.imageUtil.setBackgroundInCenter(pane, path);
    }

    public void setBackgroundInCenter(Pane pane, String path, Color color) {
        this.imageUtil.setBackgroundInCenter(pane, path, color);
    }

    public void setImageToImageView(ImageButton imageView, String imgPath) {
        imageView.setImagePath(imgPath);
    }

    public void setImageToImageView(ImageView imageView, String imgPath) {
        this.imageUtil.setPngImage(imageView, imgPath);
    }

    public Optional<Image> getImageFromResources(String imgName) {
        return Optional.ofNullable(this.imageUtil.getImageFromResourcesFile(imgName));
    }

    public Optional<Image> getEmojiImage(String imgName) {
        return Optional.ofNullable(this.imageUtil.getEmojiImage(imgName));
    }

    public boolean setAvatarImage(ImageView imageView, String id, File file, int width, int height, boolean withSave) {
        return this.imageUtil.setAvatarImage(imageView, id, file, width, height, withSave);
    }

    public boolean setAvatarImage(ImageView imageView, String id) {
        return this.setAvatarImage(imageView, id, -1, -1);
    }

    public boolean setAvatarImage(String id, int width, int height) {
        return this.imageUtil.setAvatar(null, id, width, height);
    }

    public boolean setAvatarImage(ImageView imageView, String id, int width, int height) {
        return this.imageUtil.setAvatar(imageView, id, width, height);
    }

    public void removeAvatar(String id) {
        this.imageUtil.removeAvatar(id);
    }

    public boolean setPreloadAvatar(ImageView imageView, Object objectInfo, int width, boolean withSave) {
        return this.imageUtil.setPreloadAvatar(imageView, objectInfo, width, withSave);
    }

    public <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        return this.clientUtil.distinctByKey(keyExtractor);
    }

    public String getPath() {
        return this.imageUtil.getPath();
    }

    public void setArrowPngName(ImageView imageView, MessageInfo messageInfo) {
        this.clientUtil.setArrowImage(imageView, messageInfo);
    }

    public boolean isWithChannels() {
        StringBuilder app_name = new StringBuilder();
        this.getStringProperty("application_mode").ifPresent(app_name::append);
        return "channels".contentEquals(app_name);
    }

    public void setMouseCursor(Node node) {
        this.clientUtil.setMouseCursor(node);
    }

    public void removeMouseCursor(Node node) {
        this.clientUtil.removeMouseCursor(node);
    }

    public void changeWidth(Control pane, double width) {
        this.clientUtil.changeWidth(pane, width);
    }

    public void changeHeight(Pane pane, double height) {
        this.clientUtil.changeHeight(pane, height);
    }

    public long getDateInLong(long time) {
        return time - time % 86000L;
    }

    public String getDateMarker(String value) {
        return this.clientUtil.getDateMarker(value);
    }

    public String getDateWMonthString(long time) {
        return this.clientUtil.getDateWMonthString(time);
    }

    public String getTimeDuration(long duration) {
        return this.clientUtil.getTimeDuration(duration);
    }

    public String getDateTimeString(long time) {
        return this.clientUtil.getDateTimeString(time);
    }

    public void setStyledTextFont(Text text, boolean isHoover, String color) throws Exception {
        this.clientUtil.setStyledTextFont(text, isHoover, color);
    }

    public void setStyledTextFont(Text text, boolean isHoover, String color, int size) throws Exception {
        this.clientUtil.setStyledTextFont(text, isHoover, color, size);
    }

    public void setStyledTextFont(Text text, boolean isHoover, String color, int size, boolean isLink) throws Exception {
        this.clientUtil.setStyledTextFont(text, isHoover, color, size, isLink);
    }

    public void openNewContact(MessageInfo messageInfo) {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            String contactId = messageInfo.getContent();
            String name = null;
            if (contactId.contains("<")) {
                name = contactId.substring(0, contactId.indexOf("<")).trim();
                contactId = contactId.substring(contactId.indexOf("<")).trim();
                contactId = contactId.replace("<", "");
                contactId = contactId.replace(">", "");
            }
            if (contactId.isEmpty()) {
                return;
            }
            ContactInfo contactInfo = null;
            Optional<ContactInfo> aContactInfo = ClientSingleton.getInstance().getContactInfoByUserId(contactId);
            if (aContactInfo.isPresent()) {
                contactInfo = aContactInfo.get();
            } else {
                aContactInfo = ClientSingleton.getInstance().getContactInfoById(contactId);
                if (aContactInfo.isPresent()) {
                    contactInfo = aContactInfo.get();
                }
            }
            if (contactInfo == null) {
                try {
                    contactInfo = clientConnector.getContact(contactId, messageInfo.getSenderId());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (contactInfo != null) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("contactInfo", contactInfo);
                ClientSingleton.getInstance().doNotify(Constants.OPEN_PROFILE, data);
            }
        });
    }

    public Map<String, Object> getLinkData(String messageId) {
        return this.clientUtil.getLinkData(messageId);
    }

    public void setLinkData(String messageId, Map<String, Object> map) {
        this.clientUtil.setLinkData(messageId, map);
    }

    public void removeLinkData(String messageId) {
        this.clientUtil.removeLinkData(messageId);
    }

    public void openWebBrowser(String url) {
        this.clientUtil.openWebBrowser(url);
    }

    public void openFile(File file) {
        this.clientUtil.openFile(file);
    }

    public void showAlert(String message, String buttonTitle, EventHandler<MouseEvent> mouseEventEventHandler) {
        this.clientUtil.showAlert(message, buttonTitle, mouseEventEventHandler, true);
    }

    public void showAlert(String title, String message, String buttonTitle, EventHandler<MouseEvent> mouseEventEventHandler) {
        this.clientUtil.showAlert(title, message, buttonTitle, mouseEventEventHandler, true);
    }

    public void showAlert(String message) {
        ClientSingleton.getInstance().removeLoadingPane();
        this.clientUtil.showAlert(message);
    }

    public Optional<String> showInputAlert(String header, String message, String inputText, String buttonTitle) {
        return this.clientUtil.showInputAlert(header, message, inputText, buttonTitle);
    }

    public void saveCallRecordFile(String fileName) {
        this.clientUtil.saveCallRecordFile(fileName);
    }

    public void createChat() {
        this.clientUtil.createChat();
    }

    public void shareMessage(MessageInfo messageInfo) {
        this.clientUtil.shareMessage(messageInfo);
    }

    public void addParticipantToSession(SessionInfo sessionInfo) {
        this.clientUtil.addParticipantToSession(sessionInfo);
    }

    public void addParticipantToCall(LineInfo lineInfo, boolean isAddToOpenedPopupList) {
        this.addParticipantToCall(lineInfo, isAddToOpenedPopupList, false);
    }

    public void addParticipantToCall(LineInfo lineInfo, boolean isAddToOpenedPopupList, boolean isAlwaysOnTop) {
        this.clientUtil.addParticipantToCall(lineInfo, null, isAddToOpenedPopupList, isAlwaysOnTop);
    }

    public void addParticipantToCall(Stage stage, LineInfo lineInfo, boolean isAddToOpenedPopupList, boolean isAlwaysOnTop) {
        this.clientUtil.addParticipantToCall(stage, lineInfo, null, isAddToOpenedPopupList, isAlwaysOnTop);
    }

    public void addParticipantToCall(LineInfo lineInfo, ICallPanesVisibility iCallPanesVisibility, boolean isAddToOpenedPopupList) {
        this.clientUtil.addParticipantToCall(lineInfo, iCallPanesVisibility, isAddToOpenedPopupList, false);
    }

    public void transferCallTo(LineInfo lineInfo, boolean isAddToOpenedPopupList) {
        this.clientUtil.transferCallTo(lineInfo, null, isAddToOpenedPopupList, false);
    }

    public void transferCallTo(LineInfo lineInfo, boolean isAddToOpenedPopupList, boolean isAlwaysOnTop) {
        this.clientUtil.transferCallTo(lineInfo, null, isAddToOpenedPopupList, isAlwaysOnTop);
    }

    public void transferCallTo(LineInfo lineInfo, ICallPanesVisibility iCallPanesVisibility, boolean isAddToOpenedPopupList) {
        this.clientUtil.transferCallTo(lineInfo, iCallPanesVisibility, isAddToOpenedPopupList, false);
    }

    public void initClientConnector() {
        TimerExecutor.getInstance().setMyAction(() -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " createClientConnector: start");
            try {
                this.createClientConnector();
            }
            catch (Exception ex) {
                Logger.getLogger(ClientSingleton.class.getName()).log(Level.SEVERE, null, ex);
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " createClientConnector: done");
        }).startWithDelay(50L);
    }

    private void createClientConnector() throws Exception {
        if (this.clientConnector != null) {
            return;
        }
        ClientSingleton.toLog(this.TAG, "onCreate PackageName=" + this.getPackageName());
        ClientSingleton.toLog(this.TAG, "Service createClientConnector Thread: " + Thread.currentThread().getName());
        ClientSingleton.toLog(this.TAG, "user.home: " + System.getProperty("user.home"));
        ClientSingleton.toLog(this.TAG, "user.dir: " + System.getProperty("user.dir"));
        ClientSingleton.toLog(this.TAG, "java.io.tmpdir: " + System.getProperty("java.io.tmpdir"));
        ClientSingleton.toLog(this.TAG, "jdk.tls.client.protocols: " + System.getProperty("jdk.tls.client.protocols"));
        String deviceInfo = System.getProperty("os.name").concat(" (").concat(VERSION).concat(") ");
        ClientSingleton.toLog(this.TAG, "deviceInfo: " + deviceInfo);
        this.clientConnector = ClientConnector.getInstance((String)this.getPackageName(), (String)"P1234567890");
        this.clientConnector.setDeviceInfo(deviceInfo);
        this.clientListenersModel.initLineInfoListeners(this.mainViewModel);
        this.clientConnector.setClientEventListener((ClientEventListener)this.clientListenersModel.initClientListener());
        Optional<String> optional = this.getStringProperty("login");
        if (optional.isEmpty()) {
            this.tmpTerminalId = Utils.generateGUID((long)System.currentTimeMillis());
            this.clientConnector.setTerminalId(this.tmpTerminalId);
        } else {
            this.setTerminalId(optional.get());
        }
        this.setProperties();
        String initString = Click2Dial.getInitCallNumber();
        ClientSingleton.toLog(this.TAG, "Click2Dial.getInitCallNumber()=" + initString);
        if (initString != null && !initString.isEmpty() && (initString.contains("domain") || initString.contains("username") || initString.contains("password"))) {
            String[] tokens;
            initString = initString.replace("default:", "");
            for (String token : tokens = initString.split(";")) {
                if (token.contains("domain")) {
                    String domain = token.replace("domain:", "").replace("domain=", "");
                    ClientSingleton.getInstance().setProperty("domain", domain);
                    continue;
                }
                if (token.contains("username")) {
                    String login = token.replace("username:", "").replace("username=", "");
                    ClientSingleton.getInstance().setProperty("login", login);
                    continue;
                }
                if (!token.contains("password")) continue;
                String password = token.replace("password:", "").replace("password=", "");
                ClientSingleton.getInstance().setProperty("password", password.toCharArray());
            }
            Click2Dial.setInitCallNumber("");
            if (!initString.contains("password")) {
                ClientSingleton.getInstance().setProperty("password", "".toCharArray());
            }
            if (!initString.contains("username")) {
                ClientSingleton.getInstance().setProperty("login", "");
            }
            if (!initString.contains("domain")) {
                ClientSingleton.getInstance().setProperty("domain", "");
            }
        }
        this.currentLanguage = System.getProperty("user.language");
        if (this.currentLanguage == null) {
            this.currentLanguage = Locale.getDefault().getLanguage();
        }
        ClientSingleton.toLog(this.TAG, "version: " + VERSION);
        ClientSingleton.toLog(this.TAG, "currentLanguage: " + this.currentLanguage);
        this.connection();
    }

    public void setProperties() throws Exception {
        Map mapLocalProperties = this.clientConnector.getProperties();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setProperties mapLocalProperties = " + mapLocalProperties);
        HashMap<String, Comparable<Boolean>> localProperties = new HashMap<String, Comparable<Boolean>>();
        if (!mapLocalProperties.containsKey("AEC")) {
            localProperties.put("AEC", Boolean.valueOf(true));
        }
        if (!mapLocalProperties.containsKey("AEC tail")) {
            localProperties.put("AEC tail", Integer.valueOf(140));
        }
        if (!mapLocalProperties.containsKey("AGC IN")) {
            localProperties.put("AGC IN", Boolean.valueOf(true));
        }
        if (!mapLocalProperties.containsKey("AGC OUT")) {
            localProperties.put("AGC OUT", Boolean.valueOf(true));
        }
        if (!mapLocalProperties.containsKey("VAD")) {
            localProperties.put("VAD", Boolean.valueOf(false));
        }
        if (!mapLocalProperties.containsKey("minjitter")) {
            localProperties.put("minjitter", Integer.valueOf(120));
        }
        if (!mapLocalProperties.containsKey("exportContacts")) {
            localProperties.put("exportContacts", Boolean.valueOf(true));
        }
        this.clientConnector.setProperties(localProperties);
    }

    private void setTerminalId(String login) {
        AtomicReference<String> terminalId = new AtomicReference<String>(this.getTerminalIDFromSerial(System.getProperty("user.home") + "/." + this.getPackageName().toLowerCase() + "/serial"));
        File serial = new File(System.getProperty("user.home") + "/." + this.getPackageName().toLowerCase() + "/serial");
        if (serial.exists()) {
            ClientSingleton.toLog(this.TAG, "setTerminalId serial is deleted=" + serial.delete());
        }
        Optional<String> optional = this.getStringProperty("domain");
        ClientSingleton.toLog(this.TAG, "setTerminalId login : " + login);
        ClientSingleton.toLog(this.TAG, "setTerminalId domain : " + optional);
        ClientSingleton.toLog(this.TAG, "setTerminalId serial : " + terminalId);
        if (optional.isPresent()) {
            String domain = optional.get();
            if (terminalId.get() != null) {
                this.setTerminalIDToSerial(terminalId.get(), login, domain);
            } else {
                terminalId.set(this.getTerminalIDFromSerial(this.getSerialFileName(login, domain)));
            }
            if (terminalId.get() == null) {
                terminalId.set(Utils.generateGUID((long)System.currentTimeMillis()));
                this.setTerminalIDToSerial(terminalId.get(), login, domain);
            }
        } else {
            this.tmpTerminalId = Utils.generateGUID((long)System.currentTimeMillis());
            terminalId.set(this.tmpTerminalId);
        }
        ClientSingleton.toLog(this.TAG, "setTerminalId terminalId : " + terminalId);
        this.clientConnector.setTerminalId(terminalId.get());
    }

    public void saveTerminalId(String userName, String domain) {
        ClientSingleton.toLog(this.TAG, "saveTerminalId tmpTerminalId : " + this.tmpTerminalId);
        if (this.tmpTerminalId == null) {
            return;
        }
        this.setTerminalIDToSerial(this.tmpTerminalId, userName, domain);
    }

    private String getTerminalIDFromSerial(String fileName) {
        String termid = null;
        try (FileReader fileReader = new FileReader(fileName);){
            LineNumberReader reader = new LineNumberReader(fileReader);
            termid = reader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return termid;
    }

    private void setTerminalIDToSerial(String terminalId, String userName, String domain) {
        String fileName = this.getSerialFileName(userName, domain);
        File serialFile = new File(fileName);
        boolean exists = serialFile.exists();
        if (!exists) {
            try {
                exists = serialFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (exists) {
            try (PrintWriter prn = new PrintWriter(fileName);){
                prn.println(terminalId);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private String getSerialFileName(String userName, String domain) {
        return System.getProperty("user.home") + "/." + this.getPackageName().toLowerCase() + "/" + userName + "." + domain;
    }

    private String getTerminalIdGUID(File serial) {
        String termid = Utils.generateGUID((long)System.currentTimeMillis());
        try {
            PrintWriter prn = new PrintWriter(serial);
            prn.println(termid);
            prn.close();
        }
        catch (Exception ee) {
            ResourceStore.toLog((String)ee.toString());
        }
        return termid;
    }

    private void connection() {
        int iRegistered = -1;
        try {
            iRegistered = this.clientConnector.init(false);
        }
        catch (Exception ex) {
            iRegistered = 5;
            ex.printStackTrace();
        }
        this.notRegistered = iRegistered == 1 || iRegistered == 0 || iRegistered == 5;
        ClientSingleton.toLog(this.TAG, "iRegistered: " + iRegistered);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mode", iRegistered);
        if (!this.notRegistered) {
            this.onRegistrationApp();
        } else {
            this.onNotRegistrationApp(map);
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + "  : Call2Dial.getInitCallNumber() = " + Click2Dial.getInitCallNumber());
        if (Click2Dial.getInitCallNumber() != null && !Click2Dial.getInitCallNumber().isEmpty()) {
            AudioCaller.makeCall(Click2Dial.getInitCallNumber());
        } else if (!this.notRegistered) {
            TimerExecutor.getInstance().setMyAction(this::checkUpdates).startWithDelay(4000L);
        }
    }

    public void checkUpdates() {
        List updates;
        String binPath = System.getProperty("user.dir") + File.separator + "bin";
        File binDir = new File(binPath);
        if (!binDir.exists()) {
            binDir = new File(binPath);
        }
        String appName = ClientSingleton.getInstance().getPackageName().toLowerCase().replace(" ", "");
        ClientSingleton.toLog(this.getClass().getSimpleName(), "checkUpdates binPath =" + binPath + " appName =" + appName + " startExeName=" + startExeName);
        try {
            updates = this.clientConnector.checkUpdates(binDir, "v2");
            ClientSingleton.toLog(this.getClass().getSimpleName(), "checkUpdates updates =" + updates);
            for (int i = updates.size() - 1; i >= 0; --i) {
                String update = (String)updates.get(i);
                String resName = update.replace("res_", "").replace(".jar", "");
                if (!update.startsWith(Constants.RESOURCES_PREFIX) && !update.startsWith("beta/" + Constants.RESOURCES_PREFIX)) continue;
                ClientSingleton.toLog(this.getClass().getSimpleName(), "checkUpdates update = " + update + " WhiteLabels.needToUpdate(update) =" + WhiteLabels.needToUpdate(update) + " " + update.contains(startExeName) + " " + updates.contains(appName) + " " + startExeName.contains(resName) + " " + updates.contains(resName));
                if (WhiteLabels.needToUpdate(update) || update.contains(startExeName) || updates.contains(appName) || startExeName.contains(resName) || updates.contains(resName)) continue;
                boolean isRemove = updates.remove(update);
                ClientSingleton.toLog(this.getClass().getSimpleName(), "checkUpdates update =" + update + " isRemove=" + isRemove);
                if (isRemove) continue;
                ClientSingleton.toLog(this.getClass().getSimpleName(), "checkUpdates remove =" + updates.remove("beta/" + update));
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "checkUpdates to =" + updates);
            if (updates.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            AtomicReference<File> atomicReference = new AtomicReference<File>(binDir);
            this.runLater(() -> this.callUpdateAlert(updates, atomicReference));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.runLater(() -> {
                MyAlert myAlert = new MyAlert();
                myAlert.buildDialog(e.getMessage(), null, null);
                myAlert.showAndWait();
            });
        }
    }

    private void callUpdateAlert(List<String> updates, AtomicReference<File> atomicReference) {
        MyAlert myAlert = new MyAlert();
        myAlert.setMessage(ClientSingleton.getInstance().getString("updates_available")).addPositiveButton(ClientSingleton.getInstance().getString("updates_install"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            myAlert.close();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("updates", updates);
            data.put("targetDir", atomicReference.get());
            data.put("startExeName", startExeName);
            ClientSingleton.getInstance().doNotify("Load_Updates", data);
        })).addNegativeButton(ClientSingleton.getInstance().getString("updates_ask_next_time"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> myAlert.close())).setAlwaysOnTop(true).buildDialogAndShow();
    }

    public void createBluetoothController() {
        if (this.bluetoothController == null) {
            this.bluetoothController = new BluetoothController();
        }
        this.bluetoothController.create();
    }

    private void closeBluetoothController() {
        if (this.bluetoothController != null) {
            this.bluetoothController.close();
        }
    }

    public void startUsbHidController() throws Exception {
        if (this.usbHidController == null) {
            this.usbHidController = new UsbHidController();
            this.getLineInfoPanes().forEach(lineInfoPane -> lineInfoPane.setUsbNotification(this.usbHidController));
        }
        this.usbHidController.start();
    }

    private void stopUsbHidController() throws Exception {
        if (this.usbHidController != null) {
            this.usbHidController.stopUsbHidController();
        }
    }

    public void setUsbMute() {
        if (this.usbHidController != null) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> this.usbHidController.onMute(clientConnector.getMute()));
        }
    }

    public void setUsbHold(boolean isHold) {
        if (this.usbHidController != null) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> this.usbHidController.onHold(isHold));
        }
    }

    public void startKeyHookWatcher() {
        KeyHook.startHookTheKey();
    }

    public void stopKeyHookWatcher() {
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            KeyHook.stopHookTheKey();
        }
    }

    public void startPipeServer() {
        this.kernel32NamedPipe = Kernel32NamedPipe.getInstance().startPipeServer();
    }

    public void shutDownPipeServer() {
        if (this.kernel32NamedPipe != null) {
            this.kernel32NamedPipe.shutDownPipeServer();
        }
    }

    public void signIn(String login, String password, boolean isSave) {
        block8: {
            Optional<String> domain = this.getStringProperty("domain");
            Object sipAddress = domain.orElse("");
            Optional<String> proxy = this.getStringProperty("proxy");
            String sipProxy = proxy.orElse("");
            Optional<String> serverName = this.getStyle(Constants.NEW_DEFAULT_SERVER_NAME);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "signIn NEW_DEFAULT_SERVER_NAME : [" + serverName + "]");
            if (serverName.isPresent() && !((String)sipAddress).endsWith(serverName.get())) {
                sipAddress = (String)sipAddress + (!serverName.get().startsWith(".") ? "." : "") + serverName.get();
            } else if (!((String)sipAddress).endsWith(this.DefaultSipDomain) && !((String)sipAddress).endsWith(this.DefaultSipDomain1)) {
                sipAddress = (String)sipAddress + this.DefaultSipDomain;
            }
            if (!login.isEmpty() && !password.isEmpty()) {
                this.clientConnector.setServerAddress((String)sipAddress);
                try {
                    boolean isRegistered = this.clientConnector.signIn(login, password.toCharArray(), sipProxy.isEmpty() ? null : sipProxy, isSave);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "signIn isRegistered " + isRegistered);
                    if (isRegistered) {
                        this.notRegistered = false;
                        TimerExecutor.getInstance().setMyAction(() -> {
                            this.saveTerminalId(login, (String)domain.get());
                            this.checkUpdates();
                        }).startWithDelay(4000L);
                        break block8;
                    }
                    this.onNotRegistrationApp(null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    String message = "";
                    message = ex.getMessage() != null && ex.getMessage().contains("Untrusted certificate") ? ex.getMessage() : (ex.getMessage() != null && ex.getMessage().contains("certificate chain") ? domain.map(s -> "Can't establish a connection to the " + s + " due to an invalid certificate.\nPlease contact your system administrator for further assistance").orElseGet(() -> "Can't establish a connection to the domain due to an invalid certificate.\nPlease contact your system administrator for further assistance") : (ex.getMessage() != null && ex.getMessage().contains("Forbidden") ? this.getString("connect_forbidden_warning") : domain.map(s -> this.getString("connect_error_warning") + " " + s + this.getString("connect_error_warning_")).orElseGet(() -> this.getString("connect_error_warning__"))));
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put(Constants.THROW_MESSAGE, message);
                    this.onNotRegistrationApp(data);
                }
            } else {
                this.onNotRegistrationApp(null);
            }
        }
    }

    public void onNotRegistrationApp(Map<String, Object> data) {
        try {
            this.mainViewModel.onNotRegistrationApp(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onInitError(Map<String, Object> data) {
        try {
            this.mainViewModel.onNotRegistrationApp(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onRegistrationApp() {
        this.mainViewModel.onRegistrationApp();
    }

    public boolean isSaveConnectionParameters() {
        return this.getBooleanProperty("savepass").orElse(true);
    }

    public Optional<Boolean> getBooleanProperty(String key) {
        Optional<ClientConnector> optional = this.getClientConnector();
        return optional.map(connector -> (Boolean)connector.getProperty(key));
    }

    public Optional<String> getStringProperty(String key) {
        Optional<ClientConnector> optional = this.getClientConnector();
        return optional.map(connector -> (String)connector.getProperty(key));
    }

    public Optional<char[]> getCharArrProperty(String key) {
        Optional<ClientConnector> optional = this.getClientConnector();
        return optional.map(connector -> (char[])connector.getProperty(key));
    }

    public void setProperty(String key, Object value) {
        this.getClientConnector().ifPresent(cc -> {
            try {
                cc.setProperty(key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public boolean canRecord() {
        try {
            return this.clientConnector != null && this.clientConnector.canRecord();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean canSeeUsers() {
        try {
            return this.clientConnector != null && this.clientConnector.canSeeUsers();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean canVideo() {
        try {
            return this.clientConnector != null && this.clientConnector.canVideo();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean canChat() {
        try {
            return this.clientConnector != null && this.clientConnector.canChat();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean canShareContact(ContactInfo contactInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "canShareContact contactInfo=" + contactInfo + " getOwnerId = " + contactInfo.getOwnerId() + " getUserID = " + ClientSingleton.getInstance().getClientConnector().get().getUserId());
        return contactInfo.getOwnerId() == null || contactInfo.getOwnerId().equals(this.clientConnector.getUserId()) && (contactInfo.getStatus() & 0xF) >= 4;
    }

    public boolean isSharedContact(ContactInfo contactInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "isSharedContact contactInfo=" + contactInfo + " getOwnerId = " + contactInfo.getOwnerId() + " getUserID = " + ClientSingleton.getInstance().getClientConnector().get().getUserId());
        return contactInfo.getOwnerId() != null && !contactInfo.getOwnerId().equals(this.clientConnector.getUserId());
    }

    public boolean canSendSms() {
        try {
            return this.clientConnector != null && this.clientConnector.canSendSMS();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean canSendMMS() {
        try {
            return this.clientConnector != null && this.clientConnector.canSendMMS();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Optional<ClientConnector> getClientConnector() {
        return Optional.ofNullable(this.clientConnector);
    }

    public void doNotify(String action) {
        this.clientListenersModel.notifyMessage(action, new HashMap<String, Object>());
    }

    public void doNotify(String action, Map<String, Object> data) {
        this.clientListenersModel.notifyMessage(action, data);
    }

    public void initListeners() {
        this.clientListenersModel.initListeners();
    }

    public void addObserver(IGUIObservable iguiObservable, String[] actions) {
        if (this.clientListenersModel == null) {
            this.clientListenersModel = new ClientListenersModel();
        }
        this.clientListenersModel.registerObserver(iguiObservable, actions);
    }

    public void removeObserver(IGUIObservable iguiObservable, String[] actions) {
        if (this.clientListenersModel != null) {
            this.clientListenersModel.removeObserver(iguiObservable, actions);
        }
    }

    public void addContactListener(ContactInfo contactInfo) {
        this.clientListenersModel.addContactListener(contactInfo);
    }

    public void removeContactListener(ContactInfo contactInfo) {
        this.clientListenersModel.removeContactListener(contactInfo);
    }

    public void addSessionListener(SessionInfo sessionInfo) {
        this.clientListenersModel.addSessionListener(sessionInfo);
    }

    public boolean isContactInfoApproved(ContactInfo contactInfo) {
        if (contactInfo == null) {
            return false;
        }
        int status = this.getContactStatus(contactInfo);
        return !(status != 4 && status != 5 && status != 16 && status != 6 || !contactInfo.isUser() && !contactInfo.isSlot() && !contactInfo.isPhone());
    }

    public boolean isNotMember(ContactInfo contactInfo) {
        return contactInfo.getStatus() != 0 && !contactInfo.isFeature() && !contactInfo.isUser() && contactInfo.getName() != null && !contactInfo.getName().isEmpty() && contactInfo.toString() != null && !contactInfo.toString().isEmpty() && contactInfo.getStatus() != 3 && !"".equals(contactInfo.getName());
    }

    public int getContactStatus(ContactInfo contactInfo) {
        if (contactInfo.getStatus() == 16) {
            return 16;
        }
        if (contactInfo.isFavorite()) {
            return contactInfo.getStatus() & 0xF;
        }
        return contactInfo.getStatus();
    }

    public boolean isMemberOfList(ContactInfo contactInfo) {
        if (contactInfo.isSlot() || contactInfo.isFeature()) {
            return false;
        }
        if (contactInfo.getState() == -1 && contactInfo.getStatus() == 4) {
            return false;
        }
        int status = this.getContactStatus(contactInfo);
        return contactInfo.getState() != -1 && status >= 1 && status <= 5 || status == 16 || contactInfo.isAdmin();
    }

    public boolean hasSMSTrunks() {
        return !this.clientConnector.getSIPTrunksForSMS().isEmpty();
    }

    public Optional<ContactInfo> getContactInfo(SessionInfo sessionInfo) {
        return Optional.ofNullable(sessionInfo.getParties() == null || sessionInfo.getParties().isEmpty() ? null : (ContactInfo)sessionInfo.getParties().get(0));
    }

    public boolean isClientsChat(SessionInfo sessionInfo) {
        return sessionInfo.getStatus() != 3 && sessionInfo.getParties().size() == 1;
    }

    public Optional<ContactInfo> getContactInfoFromSession(SessionInfo sessionInfo) {
        ContactInfo contactInfo = null;
        if (sessionInfo.getParties().size() == 1) {
            contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
        }
        return Optional.ofNullable(contactInfo);
    }

    public Optional<String> getStateString(ContactInfo contactInfo) {
        int state = contactInfo.getState();
        if (ClientSingleton.getInstance().getUserID(contactInfo).equals(ClientSingleton.getInstance().getClientConnector().get().getUserId())) {
            state = ClientSingleton.getInstance().getCurrentClientState();
        }
        return Optional.ofNullable(this.getStateString(state));
    }

    public String getStateString(int currentState) {
        String state = null;
        switch (currentState) {
            case 1: {
                state = "state_online";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                state = "state_busy_label";
                break;
            }
            case 3: {
                state = "state_busy";
                break;
            }
            case 2: 
            case 5: {
                state = "state_online";
                break;
            }
            case -1: 
            case 0: {
                state = "state_offline";
                break;
            }
            case 4: {
                state = "state_at_the_desk";
            }
        }
        return state;
    }

    public void pinChat(SessionInfo sessionInfo) {
        TimerExecutor.getInstance().start(() -> {
            boolean isPin = false;
            if (sessionInfo.getProperty("PinChat") != null) {
                isPin = (Boolean)sessionInfo.getProperty("PinChat");
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "pinChat session.getProperties()=" + sessionInfo.getProperties());
            isPin = !isPin;
            sessionInfo.setProperty("PinChat", (Object)isPin);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "pinChat " + sessionInfo + "(" + sessionInfo.hashCode() + ") session.getProperties()=" + sessionInfo.getProperties());
            try {
                ClientSingleton.getInstance().getClientConnector().get().updateSession(sessionInfo, -1, new HashSet(), false);
                ClientSingleton.toLog(this.getClass().getSimpleName(), "pinChat " + sessionInfo + "(" + sessionInfo.hashCode() + ") =" + sessionInfo.getProperty("PinChat"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    public SessionInfo getSessionInfo(LineInfo lineInfo) {
        return lineInfo.getSessionInfo();
    }

    public Optional<ContactInfo> getContactInfo(LineInfo lineInfo) {
        if (lineInfo.isConference() || lineInfo.getContacts() == null || lineInfo.getContacts().isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ContactInfo)lineInfo.getContacts().iterator().next());
    }

    public SessionInfo getSessionInfo(ContactInfo contactInfo, boolean isDirectSession) {
        Optional<SessionInfo> optional = this.getSessionInfoStream().filter(sessionInfo -> sessionInfo.getParties().size() == 1 && sessionInfo.getParties().contains(contactInfo) && isDirectSession && (sessionInfo.getStatus() == 0 || sessionInfo.getStatus() == 1)).findAny();
        return optional.isEmpty() ? null : optional.get();
    }

    public SessionInfo getSessionInfo(ContactInfo contactInfo) {
        Optional<SessionInfo> optional = this.getSessionInfoStream().filter(sessionInfo -> sessionInfo.getStatus() != 5 && sessionInfo.getParties().size() == 1 && this.isEqualsContacts((SessionInfo)sessionInfo, contactInfo)).findFirst();
        return optional.orElse(null);
    }

    public boolean isEqualsContacts(SessionInfo sessionInfo, ContactInfo contactInfo) {
        return this.getUserID((ContactInfo)sessionInfo.getParties().get(0)).equals(this.getUserID(contactInfo)) || this.compareContactsExtension(contactInfo, (ContactInfo)sessionInfo.getParties().get(0)) || this.compareContactsNumbers(contactInfo, (ContactInfo)sessionInfo.getParties().get(0)) || contactInfo.getUserID() == null && contactInfo.getLocalId() == null && contactInfo.toString() != null && ((ContactInfo)sessionInfo.getParties().get(0)).toString().equals(contactInfo.toString());
    }

    private boolean compareContactsExtension(ContactInfo contactInfo1, ContactInfo contactInfo2) {
        String ext2;
        String ext1 = (String)contactInfo1.getProperty("extension");
        if (ext1 == null) {
            ext1 = (String)contactInfo1.getProperty("ext");
        }
        if ((ext2 = (String)contactInfo2.getProperty("extension")) == null) {
            ext2 = (String)contactInfo2.getProperty("ext");
        }
        boolean ret = ext1 != null && ext1.equals(ext2);
        return ret;
    }

    private boolean compareContactsNumbers(ContactInfo contactInfo1, ContactInfo contactInfo2) {
        List numbers1 = contactInfo1.getPhoneNumbers();
        List numbers2 = contactInfo2.getPhoneNumbers();
        boolean ret = numbers2.stream().anyMatch(item1 -> numbers1.stream().anyMatch(item1::equals));
        return ret;
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId) {
        AtomicReference atomicReference = new AtomicReference();
        if (sessionId != null) {
            this.getSessionInfoStream().forEach(sessionInfo -> {
                if (sessionInfo.getSessionId() != null && sessionId.equals(sessionInfo.getSessionId())) {
                    atomicReference.set(sessionInfo);
                } else if (sessionInfo.getParties().size() == 1 && sessionId.equals(this.getUserID((ContactInfo)sessionInfo.getParties().get(0)))) {
                    atomicReference.set(sessionInfo);
                } else if (sessionId.equals(String.valueOf(sessionInfo.hashCode()))) {
                    atomicReference.set(sessionInfo);
                }
            });
        }
        return atomicReference.get() != null ? Optional.of((SessionInfo)atomicReference.get()) : Optional.empty();
    }

    public Optional<SessionInfo> getSessionInfoByNumber(String number) {
        List list = this.getSessionInfoStream().filter(sessionInfo -> sessionInfo.getParties().size() == 1 && (number.equals(((ContactInfo)sessionInfo.getParties().get(0)).toString()) || number.equals(((ContactInfo)sessionInfo.getParties().get(0)).getNumber()) || this.getPhonesListForMenu((ContactInfo)sessionInfo.getParties().get(0)).contains(number))).collect(Collectors.toList());
        return !list.isEmpty() ? Optional.of((SessionInfo)list.get(0)) : Optional.empty();
    }

    public SessionInfo getExistSessionInfoByUserId(String userId) throws Exception {
        Optional<SessionInfo> optional = this.getSessionInfoStream().filter(sessionInfo1 -> sessionInfo1.getParties().size() == 1 && userId.equals(this.getUserID((ContactInfo)sessionInfo1.getParties().get(0)))).findAny();
        return optional.isEmpty() ? null : optional.get();
    }

    public Stream<ContactInfo> getContactInfoStream() {
        Iterator iterator = this.clientConnector.getContactInfos();
        if (!this.clientConnector.canSeeUsers()) {
            return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), true).filter(UpdateLists.getNotAutorizedContacts()).parallel();
        }
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), true).parallel();
    }

    public Stream<SessionInfo> getSessionInfoStream() {
        Iterator iterator = this.clientConnector.getSessionInfos();
        if (!this.clientConnector.canSeeUsers()) {
            return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), true).filter(sessionInfo -> sessionInfo.getStatus() != 0 && sessionInfo.getStatus() != 1).parallel();
        }
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), true).parallel();
    }

    public Optional<ContactInfo> getContactInfoByNumberOrByName(String number) {
        List list = this.getContactInfoStream().filter(contactInfo -> number.equals(contactInfo.getNumber()) || number.equals(contactInfo.toString())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ContactInfo)list.get(0));
    }

    public Optional<ContactInfo> getContactInfoByNumber(String number) {
        List list = ClientSingleton.getInstance().getContactInfoStream().filter(contactInfo -> contactInfo.getPhoneNumbers().contains(number) || number.equals(contactInfo.getNumber())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ContactInfo)list.get(0));
    }

    public Optional<ContactInfo> getContactInfoByName(String name) {
        List list = ClientSingleton.getInstance().getContactInfoStream().filter(contactInfo -> name.equals(contactInfo.toString())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ContactInfo)list.get(0));
    }

    public Optional<ContactInfo> getContactInfoByUserId(String userId) {
        if (userId == null) {
            return Optional.empty();
        }
        List list = ClientSingleton.getInstance().getContactInfoStream().filter(contactInfo -> userId.equals(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ContactInfo)list.get(0));
    }

    public Optional<ContactInfo> getContactInfoById(String id) {
        if (id == null) {
            return Optional.empty();
        }
        List list = ClientSingleton.getInstance().getContactInfoStream().filter(contactInfo -> id.equals(contactInfo.getId())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ContactInfo)list.get(0));
    }

    public Optional<ContactInfo> getContactInfoByUserIdOrExt(String id) {
        Predicate<ContactInfo> find = contactInfo -> {
            AtomicBoolean isFind = new AtomicBoolean(false);
            if (id.equals(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))) {
                isFind.set(true);
            } else {
                Optional<Object> prop = Optional.ofNullable(contactInfo.getProperty("extension"));
                if (prop.isPresent()) {
                    prop.ifPresent(o -> isFind.set(id.equals(o)));
                }
                if (!isFind.get()) {
                    prop = Optional.ofNullable(contactInfo.getProperty("ext"));
                    prop.ifPresent(o -> isFind.set(id.equals(o)));
                }
                if (!isFind.get()) {
                    isFind.set(id.equals(contactInfo.getNumber()));
                }
            }
            return isFind.get();
        };
        List list = ClientSingleton.getInstance().getContactInfoStream().filter(find).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ContactInfo)list.get(0));
    }

    public static void setConsoleLog() {
        MyLogger.getInstance().startLogger();
        MyThreadPoolManager.getInstance().execute(() -> {
            try {
                File log;
                ResourceStore.toLog((String)"init");
                File dir = new File(System.getProperty("user.dir"), "log");
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!(log = new File(dir, "debug.log")).exists()) {
                    log.createNewFile();
                }
                if (log.length() > 100000L) {
                    log.delete();
                }
                PrintStream syslog = new PrintStream(new FileOutputStream(log, true), true);
                System.setOut(syslog);
                System.setErr(syslog);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseViewResources(ArrayList<Pane> nodes) {
        ClientSingleton clientSingleton = this;
        synchronized (clientSingleton) {
            this.runLater(() -> {
                for (Pane pane : nodes) {
                    this.release(pane);
                    pane.getChildren().clear();
                    Object var3_3 = null;
                }
            });
        }
    }

    public void releaseViewResources(Pane parentNode) {
        if (Platform.isFxApplicationThread()) {
            this.release(parentNode);
            parentNode.getChildren().clear();
        } else {
            this.runLater(() -> {
                this.release(parentNode);
                parentNode.getChildren().clear();
            });
        }
    }

    private void release(Pane parentNode) {
        for (int i = parentNode.getChildren().size() - 1; i >= 0; --i) {
            Node node = (Node)parentNode.getChildren().get(i);
            if (node instanceof Pane) {
                Pane pane = (Pane)node;
                if (pane instanceof IActionOnRelease) {
                    ((IActionOnRelease)pane).onRelease();
                }
                if (pane.getChildren().isEmpty()) {
                    parentNode.getChildren().remove((Object)pane);
                    pane = null;
                    continue;
                }
                this.release(pane);
                continue;
            }
            parentNode.getChildren().remove((Object)node);
            Object var3_3 = null;
        }
    }

    public void setFocusNotTraversable(Pane parentNode) {
        if (Platform.isFxApplicationThread()) {
            this.focusTraversable(parentNode);
        } else {
            this.runLater(() -> this.focusTraversable(parentNode));
        }
    }

    private void focusTraversable(Pane parentNode) {
        for (int i = parentNode.getChildren().size() - 1; i >= 0; --i) {
            Pane pane;
            Node node = (Node)parentNode.getChildren().get(i);
            if (node instanceof Pane && !(pane = (Pane)node).getChildren().isEmpty()) {
                this.focusTraversable(pane);
            }
            node.setFocusTraversable(false);
        }
    }

    public boolean setContentImage(ImageView imageView, String messageId) {
        return this.imageUtil.setContentImage(imageView, messageId);
    }

    public void setCachedImage(ImageView imageView, String path) {
        this.imageUtil.setCachedImage(imageView, path);
    }

    public void setCachedImage(ImageButton imageButton, String path) {
        this.imageUtil.setCachedImage(imageButton, path);
    }

    public void removeImage(String messageId) {
        this.imageUtil.removeImage(messageId);
    }

    public int getContentTextHeight(int width, String content) {
        JEditorPane dummyEditorPane = new JEditorPane();
        dummyEditorPane.setFont(new Font("Arial", 0, 12));
        dummyEditorPane.setSize(width, Short.MAX_VALUE);
        dummyEditorPane.setText(content);
        return dummyEditorPane.getPreferredSize().height;
    }

    public int getContentTextWidth(int height, String content) {
        JEditorPane dummyEditorPane = new JEditorPane();
        dummyEditorPane.setSize(Short.MIN_VALUE, height);
        dummyEditorPane.setText(content);
        return dummyEditorPane.getPreferredSize().width;
    }

    public boolean isThumbnailImage(String fileName) {
        return this.clientUtil.isThumbnailImage(fileName);
    }

    public boolean isHasFileIcon(String suffix) {
        return this.clientUtil.isHasFileIcon(suffix);
    }

    public void toClipBoard(MessageInfo messageInfo, boolean isLink) {
        this.clientUtil.toClipBoard(messageInfo, isLink);
    }

    public void setIconified(boolean mode) {
        this.resizeHelper.setIconified(mode);
    }

    public void initDragListener(Pane pane) {
        Stage stage = ClientSingleton.getInstance().getParentWindow();
        this.initDragListener(pane, stage);
    }

    public void initDragListener(Pane pane, Stage stage) {
        if (this.resizeHelper == null) {
            this.resizeHelper = new ResizeHelper(stage);
        }
        this.resizeHelper.initDragListener((Node)pane);
    }

    public MyImageView getRoundedImage(Image image) {
        return this.imageUtil.getRoundedImage(image);
    }

    public SessionInfo getSessionInfoByMessageId(String messageId) {
        return this.clientConnector.getSessionInfoByMessageId(messageId);
    }

    public void shareContact(ContactInfo contactInfo) {
        this.clientUtil.shareContact(contactInfo);
    }

    public void shareContactList(List<ContactInfo> contactInfoList) {
        this.clientUtil.shareContactList(contactInfoList);
    }

    public void closeContactListView() {
        this.clientUtil.closeContactListView();
    }

    public boolean showBaseAlert(String text) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Ringotel");
        alert.setHeaderText("Test with argument");
        alert.setContentText(text);
        Optional option = alert.showAndWait();
        return ButtonType.OK.equals(option.get());
    }

    public void setFullScreen() {
        this.resizeHelper.setFullScreen();
    }

    public void setFullVideoScreen() {
        this.resizeHelper.setFullVideoScreen();
    }

    public void clearFullVideoScreen() {
        this.resizeHelper.clearLastVideoBounds();
    }

    public void setFullScreenByLayout() {
        if (this.resizeHelper != null) {
            this.resizeHelper.setFullScreenByLayout();
        }
    }

    public void setSmoothScrolling(VirtualFlow<?, ?> virtualFlow, Var<Double> estimatedScrollYProperty) {
        this.clientUtil.setSmoothScrolling(virtualFlow, estimatedScrollYProperty);
    }

    public List<String> getPhonesListForMenu(ContactInfo contactInfo) {
        ArrayList<String> numbers = new ArrayList<String>();
        if (contactInfo == null) {
            return numbers;
        }
        List userDetailList = contactInfo.getPhoneDetails();
        if (!userDetailList.isEmpty()) {
            for (ContactInfo.Detail detail : userDetailList) {
                String label = detail.getLabel();
                String sdetail = detail.getValue().toString();
                if (sdetail.isEmpty() || numbers.contains(sdetail)) continue;
                numbers.add(detail.getValue().toString());
            }
        }
        if (numbers.isEmpty() || contactInfo.isUser()) {
            Optional<String> ext = Optional.ofNullable(Optional.ofNullable((String)contactInfo.getProperty("extension")).orElse((String)contactInfo.getProperty("ext")));
            ext.ifPresent(s -> numbers.add(0, (String)s));
        }
        return numbers.stream().filter(number -> number != null && !number.equals(this.getUserID(contactInfo))).collect(Collectors.toList());
    }

    public boolean isPinnedChat(SessionInfo sessionInfo) {
        boolean isPin = false;
        if (sessionInfo.getProperty("PinChat") != null) {
            isPin = (Boolean)sessionInfo.getProperty("PinChat");
        }
        return isPin;
    }

    public Rectangle2D getCurrentScreenBounds() {
        Rectangle2D originalRectangle = this.resizeHelper.getCurrentScreen().getVisualBounds();
        double height = originalRectangle.getMinY() < 0.0 ? originalRectangle.getHeight() + originalRectangle.getMinY() : (originalRectangle.getMinY() > 0.0 ? originalRectangle.getHeight() - originalRectangle.getMinY() : originalRectangle.getHeight());
        return originalRectangle;
    }

    public boolean isOpenedPopupsListEmpty() {
        return this.openedPopupsList.isEmpty() && this.openedMenusList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToOpenedPopupsList(MyPopupWindow myPopupWindow) {
        if (!this.openedPopupsList.contains(myPopupWindow.toString())) {
            List<String> list = this.openedPopupsList;
            synchronized (list) {
                this.openedPopupsList.add(myPopupWindow.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromOpenedPopupsList(MyPopupWindow myPopupWindow) {
        List<String> list = this.openedPopupsList;
        synchronized (list) {
            this.openedPopupsList.remove(myPopupWindow.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToOpenedMenusList(MyContextMenu myContextMenu) {
        if (!this.openedMenusList.contains(myContextMenu.toString())) {
            List<String> list = this.openedMenusList;
            synchronized (list) {
                this.openedMenusList.add(myContextMenu.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromOpenedMenusList(MyContextMenu myContextMenu) {
        List<String> list = this.openedMenusList;
        synchronized (list) {
            this.openedMenusList.remove(myContextMenu.toString());
        }
    }

    public String getTimeLabel(long localTime) {
        return this.clientUtil.getTimeLabel(localTime);
    }

    public String getDateLabel(long localTime) {
        return this.clientUtil.getDateLabel(localTime);
    }

    public Screen getCurrentScreen() {
        return this.resizeHelper.getCurrentScreen();
    }

    public void toCenterInScreen(Stage stage) {
        this.resizeHelper.toCenterInScreen(stage);
    }

    public void initResizeHelper(Stage parent) {
        if (this.resizeHelper == null) {
            this.resizeHelper = new ResizeHelper(parent);
        }
    }

    public boolean isFullScreenMode() {
        return this.resizeHelper.isFullScreen();
    }

    public boolean isFullVideoScreenMode() {
        return this.resizeHelper.isFullVideoScreen();
    }

    public boolean isMyVideoEnabledFlag(LineInfo lineInfo) {
        if (!this.lineInfoVideoMode.containsKey(lineInfo)) {
            this.lineInfoVideoMode.put(lineInfo, false);
        }
        return this.lineInfoVideoMode.get(lineInfo);
    }

    public void setMyVideoEnabledFlag(LineInfo lineInfo, boolean myVideoEnabledFlag) {
        this.lineInfoVideoMode.put(lineInfo, myVideoEnabledFlag);
    }

    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = new ProgressIndicator();
        Theme.getInstance().applyTo(Constants.PROGRESS_INDICATOR_STYLE, (Control)progressIndicator);
        return progressIndicator;
    }

    public ObservableList<LineInfoPane> getLineInfoPanes() {
        return this.clientListenersModel.getLineInfoPanes();
    }

    public int getCurrentClientState() {
        return this.clientListenersModel.getCurrentState();
    }

    public boolean isChatWithTrunks() {
        return this.isChatWithTrunks;
    }

    public void setChatWithTrunks() {
        List trunks = ClientSingleton.getInstance().getClientConnector().get().getTrunks();
        this.isChatWithTrunks = trunks != null && trunks.size() > 1;
    }

    public void startServices() {
        try {
            ClientSingleton.getInstance().startUsbHidController();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientSingleton.getInstance().startPipeServer();
        TimerExecutor.getInstance().setMyAction(() -> {
            AtomicBoolean isDisableHighLightToCall = new AtomicBoolean(false);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                Map localProperties = clientConnector.getProperties();
                if (localProperties.get("disableHighLightToCall") != null) {
                    isDisableHighLightToCall.set((Boolean)localProperties.get("disableHighLightToCall"));
                }
            });
            ClientSingleton.toLog(this.getClass().getSimpleName(), "startServices isDisableHighLightToCall = " + isDisableHighLightToCall);
            if (!isDisableHighLightToCall.get()) {
                ClientSingleton.getInstance().startKeyHookWatcher();
            }
        }).startWithDelay(1000L);
    }

    public void closeServices() {
        this.shutDownPipeServer();
        try {
            this.stopKeyHookWatcher();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.stopUsbHidController();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clientListenersModel.releaseAllObservers();
        this.clientListenersModel.shutDown();
    }

    public void shutDownClientObserver() {
        this.clientListenersModel.shutDown();
    }

    public void initObservers() {
        this.clientListenersModel.initObservers();
    }

    public void setRecordingState(boolean mode) {
        try {
            this.clientConnector.setRecordingState(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkObserversStates() {
        this.clientListenersModel.checkObserversStates();
    }

    public Pane addServiceLocation(Map link) {
        return this.addServiceLocation(link, 0);
    }

    public Pane addServiceLocation(Map link, int rightPadding) {
        return this.clientUtil.addServiceLocation(link, rightPadding);
    }

    public void initImageAndTitle(Stage stage) {
        this.clientUtil.initImageAndTitle(stage);
    }

    public boolean isShowChatInputMessagePane(SessionInfo sessionInfo) {
        return this.clientConnector.canChat() && sessionInfo.canChat() || this.clientConnector.canSendSMS() && sessionInfo.canSMS();
    }

    public boolean canSMS(SessionInfo sessionInfo) {
        boolean isContactCanChat = false;
        if (this.isClientsChat(sessionInfo)) {
            isContactCanChat = this.clientConnector.canSendSMS((ContactInfo)sessionInfo.getParties().get(0));
        }
        return (isContactCanChat || sessionInfo.canSMS()) && !this.clientConnector.getSIPTrunksForSMS().isEmpty();
    }

    public boolean canMMS(SessionInfo sessionInfo) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            List list = clientConnector.getSIPTrunksForMMS();
            atomicBoolean.set(list != null && !list.isEmpty() && sessionInfo.canSMS());
        });
        return atomicBoolean.get();
    }

    public void removeLoadingPane() {
        this.mainViewModel.removeLoadingPane();
    }

    public void setStagePosition(boolean isMainScreen) {
        this.resizeHelper.setPosition(isMainScreen);
    }

    public void addLoadingPane(String text) {
        this.mainViewModel.addLoadingPane(text, true);
    }

    public void addLoadingPane(String text, boolean iaWithDelay) {
        this.mainViewModel.addLoadingPane(text, iaWithDelay);
    }

    public void switchTab(int tab) {
        this.mainViewModel.switchTab(tab);
    }

    public void sessionUpdated(SessionInfo sessionInfo) {
        this.mainViewModel.sessionUpdated(sessionInfo);
    }

    public Bounds getLastBounds() {
        return this.resizeHelper.getCurrentBounds();
    }

    public void hideStageOnExit() {
        this.resizeHelper.hideStageOnExit();
    }

    public void restoreStageBounds() {
        this.resizeHelper.restoreStageBounds();
    }

    public double getCurrentWidth() {
        return this.resizeHelper.getCurrentWidth();
    }

    public boolean isContactInfoInTheList(ContactInfo contactInfo, String prefix) {
        if (contactInfo == null || prefix == null || prefix.isEmpty()) {
            return false;
        }
        AtomicBoolean atomicReference = new AtomicBoolean(!contactInfo.toString().isEmpty() && !"IT Admin".equals(contactInfo.toString()) && contactInfo.toString().toLowerCase().contains(prefix.toLowerCase()) || this.hasPrefixInNumber(contactInfo, prefix));
        if (atomicReference.get()) {
            return true;
        }
        if (!atomicReference.get()) {
            atomicReference.set(this.checkPhone(contactInfo, prefix.toLowerCase()));
        }
        if (!atomicReference.get()) {
            ArrayList<ContactInfo.Detail> details = new ArrayList<ContactInfo.Detail>(contactInfo.getUserDetails());
            details.addAll(contactInfo.getCustomDetails());
            List<DetailValue> userDetails = TypeConstantsRT.getDetails(details, contactInfo);
            userDetails.forEach(detailValue -> {
                String val;
                boolean has;
                String value = detailValue.getValue();
                if (value != null && !value.isEmpty() && TypeConstantsRT.tagsOfPhones.contains(detailValue.getLabel()) && (has = (val = value.toLowerCase()).contains(prefix.toLowerCase()))) {
                    atomicReference.set(true);
                }
            });
        }
        return atomicReference.get();
    }

    private boolean hasPrefixInNumber(ContactInfo contactInfo, String prefix) {
        boolean isHas = false;
        Optional<Object> prop = Optional.ofNullable(contactInfo.getProperty("extension"));
        String extension = "";
        String number = contactInfo.getNumber();
        if (number == null || ClientSingleton.getInstance().getUserID(contactInfo).equals(number)) {
            number = "";
        }
        if (prop.isPresent()) {
            extension = (String)prop.get();
        }
        if (extension.isEmpty() && (prop = Optional.ofNullable(contactInfo.getProperty("ext"))).isPresent()) {
            extension = (String)prop.get();
        }
        if (!extension.isEmpty()) {
            isHas = extension.toLowerCase().contains(prefix.toLowerCase());
        }
        if (!(isHas || contactInfo.isUser() || number.isEmpty() || number.contains("@"))) {
            isHas = number.toLowerCase().contains(prefix.toLowerCase());
        }
        return isHas;
    }

    public String getNumberByPrefix(ContactInfo contactInfo, String prefix) {
        Optional<Object> prop = Optional.ofNullable(contactInfo.getProperty("extension"));
        String extension = "";
        String number = contactInfo.getNumber();
        if (number == null || ClientSingleton.getInstance().getUserID(contactInfo).equals(number)) {
            number = "";
        }
        if (prop.isPresent()) {
            extension = (String)prop.get();
        }
        if (extension.isEmpty() && (prop = Optional.ofNullable(contactInfo.getProperty("ext"))).isPresent()) {
            extension = (String)prop.get();
        }
        if (!extension.isEmpty() && extension.toLowerCase().contains(prefix.toLowerCase())) {
            return this.getString("Phone") + " : " + extension;
        }
        if (!contactInfo.isUser() && !number.isEmpty() && !number.contains("@") && number.toLowerCase().contains(prefix.toLowerCase())) {
            return this.getString("Phone") + " : " + number;
        }
        return "";
    }

    public long getNewMessagesCount(SessionInfo sessionInfo) {
        long count = 0L;
        if (sessionInfo.getStatus() < 4 && sessionInfo.getLastChatMessage() != null && !sessionInfo.isSlot()) {
            count = sessionInfo.getMessages().stream().filter(messageInfo -> messageInfo.getStatus() == 1).count();
        }
        return count;
    }

    public long getMissedCallsCount(SessionInfo sessionInfo) {
        long count = 0L;
        if (sessionInfo.getStatus() < 4 && sessionInfo.getLastCall() != null) {
            count = sessionInfo.getMessages().stream().filter(messageInfo -> messageInfo.getStatus() == 12).count();
        }
        return count;
    }

    public List<SessionInfo> getSessions(List<SessionInfo> mListValues, String inputText) {
        if (inputText == null || inputText.isEmpty()) {
            return mListValues;
        }
        return mListValues.stream().filter(sessionInfo -> sessionInfo.toString().toLowerCase().contains(inputText.toLowerCase())).collect(Collectors.toList());
    }

    public List<SessionInfo> getCalls(List<SessionInfo> mListValues, String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return mListValues;
        }
        return mListValues.stream().filter(sessionInfo -> !(sessionInfo instanceof CallDateHandler) && sessionInfo.toString() != null && sessionInfo.toString().toLowerCase().contains(prefix.toLowerCase()) || sessionInfo.getParties() != null && sessionInfo.getParties().size() == 1 && this.checkPhone((ContactInfo)sessionInfo.getParties().get(0), prefix)).collect(Collectors.toList());
    }

    private boolean checkPhone(ContactInfo contactInfo, String prefix) {
        Optional<String> ext = Optional.ofNullable(Optional.ofNullable((String)contactInfo.getProperty("extension")).orElse((String)contactInfo.getProperty("ext")));
        if (ext.isPresent() && ext.get().contains(prefix)) {
            return true;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        List details = contactInfo.getPhoneDetails();
        details.forEach(detail -> {
            boolean eqvPhone;
            String number = "";
            if (detail.getValue() instanceof Map) {
                Map m = (Map)detail.getValue();
                number = (String)m.get("value");
            } else {
                number = detail.getValue().toString();
            }
            if (number != null && !number.isEmpty() && (eqvPhone = (number = number.replaceAll("\\s+|\\(|\\)", "")).toLowerCase().contains(prefix))) {
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    public List<SessionInfo> getCalls() {
        return this.getCalls("");
    }

    public List<SessionInfo> getCalls(String prefix) {
        Stream<SessionInfo> stream1 = this.getSessionInfoStream();
        return ((Stream)stream1.parallel()).filter(sessionInfo -> {
            if (!sessionInfo.getMessages().isEmpty() && !sessionInfo.isChannel() && !sessionInfo.isPublic() && ClientSingleton.hasLastCall(sessionInfo)) {
                if (!prefix.isEmpty()) {
                    String pref;
                    MessageInfo messageInfo = sessionInfo.getLastCall();
                    String caller = messageInfo.getCallCallerNumber();
                    String called = messageInfo.getCallCalledNumber();
                    String name = sessionInfo.toString().toLowerCase();
                    return name.contains(pref = prefix.toLowerCase()) || caller != null && caller.contains(pref) || called != null && called.contains(pref);
                }
                return true;
            }
            return false;
        }).sorted().collect(Collectors.toList());
    }

    private static boolean hasLastCall(SessionInfo sessionInfo) {
        return sessionInfo.getMessages().stream().anyMatch(messageInfo -> messageInfo.getType() == 8 && (messageInfo.getCode() & 0x100) == 0);
    }

    public boolean isFocused() {
        return this.mainViewModel.isFocused();
    }

    public <T> ObservableTransformer<T, T> debounceTime(long time, TimeUnit unit, Scheduler scheduler, Consumer<? super T> dropped) {
        return o -> Observable.defer(() -> {
            AtomicLong index = new AtomicLong();
            ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
            return o.map(v -> {
                Timed t = new Timed(v, index.getAndIncrement(), TimeUnit.NANOSECONDS);
                queue.offer(t);
                return t;
            }).debounce(time, unit, scheduler).map(v -> {
                while (!queue.isEmpty()) {
                    Timed t = (Timed)queue.peek();
                    if (t.time() < v.time()) {
                        queue.poll();
                        dropped.accept(t.value());
                        continue;
                    }
                    if (t != v) continue;
                    queue.poll();
                    break;
                }
                return v.value();
            }).doOnComplete(() -> {
                while (!queue.isEmpty()) {
                    dropped.accept(((Timed)queue.poll()).value());
                }
            });
        });
    }

    public void setMinWidth(int viewModeWithoutChat) {
        this.resizeHelper.setMinWidth(viewModeWithoutChat);
    }

    public int getCurrentViewMode() {
        return this.resizeHelper.getCurrentViewMode();
    }

    public String getLastAction() {
        if (this.lastAction.get() == null) {
            this.lastAction.set("");
        }
        return this.lastAction.get();
    }

    public SimpleStringProperty lastActionProperty() {
        return this.lastAction;
    }

    public void setLastAction(String lastAction) {
        if (lastAction.isEmpty()) {
            TimerExecutor.getInstance().setMyAction(() -> this.lastAction.set(lastAction)).startWithDelay(3000L);
        } else {
            this.lastAction.set(lastAction);
        }
    }

    public void switchViewMode() {
        this.mainViewModel.switchViewMode();
    }

    public boolean isShareDesktopPaneShowing() {
        return this.mainViewModel.isShareDesktopPaneShowing();
    }

    public boolean isGroupAdmin(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            return false;
        }
        List administrator = sessionInfo.getAdmins();
        return administrator.contains(ClientSingleton.getInstance().getUserId()) || sessionInfo.getStatus() == 3 || this.isGroupWithAllAdmins(sessionInfo);
    }

    public boolean isGroupAdmin(SessionInfo sessionInfo, ContactInfo contactInfo) {
        if (sessionInfo == null) {
            return false;
        }
        List administrator = sessionInfo.getAdmins();
        return administrator.contains(ClientSingleton.getInstance().getUserID(contactInfo));
    }

    public boolean isGroupWithAllAdmins(SessionInfo sessionInfo) {
        return sessionInfo != null && sessionInfo.getDialogType() == 3 && sessionInfo.getStatus() == 1;
    }

    public boolean isExternalContact(ContactInfo contactInfo) {
        return contactInfo != null && contactInfo.getState() == -1 && contactInfo.getStatus() == 0;
    }

    public SessionInfo getCurrentSessionInfo() {
        return this.mainViewModel.getCurrentSessionInfo();
    }

    public void chatFireScrollEvent(ScrollEvent scrollEvent) {
        this.mainViewModel.chatFireScrollEvent(scrollEvent);
    }

    public boolean isRegistered() {
        return !this.notRegistered;
    }

    public boolean canVideo(LineInfo lineInfo) {
        return this.canVideo() && lineInfo.getSessionInfo() != null && lineInfo.getSessionInfo().canMakeVideoCall() && !lineInfo.getSessionInfo().isGroup();
    }

    public boolean canVideo(SessionInfo sessionInfo) {
        return sessionInfo.canMakeVideoCall() && (!sessionInfo.isGroup() && this.canVideo() || sessionInfo.isGroup() && this.hasMeetingServices());
    }

    public boolean hasMeetingServices() {
        AtomicReference list = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> list.set(clientConnector.getMeetingServices()));
        return list.get() != null && !((List)list.get()).isEmpty();
    }

    public void runLater(MyAction myAction) {
        TimerExecutor.getInstance().startInGUI(myAction);
    }

    public boolean isPhoneConnected() {
        return this.clientConnector.getProperty("callfromphone") != null && (Boolean)this.clientConnector.getProperty("callfromphone") != false;
    }

    public String getConnectedSipDevice() {
        return this.clientConnector.getSIPDevice();
    }

    public ContactInfo getUserInfo() {
        return this.clientConnector.getUserInfo(false);
    }

    public String getUserId() {
        return this.clientConnector.getUserId();
    }

    public boolean isMousePointerUnderWindow() {
        return this.resizeHelper.isMousePointerUnderWindow();
    }

    public Optional<Image> getImageFromFile(File file, int imageWidth, int imageHeight) {
        return this.imageUtil.getImageFromFile(file, imageWidth, imageHeight);
    }

    public ImageResource getImageResourceFromResourcesFile(String image) {
        return this.imageUtil.getImageResourceFromResourcesFile(image);
    }

    public void addTextAreaToReply(Pane pane, MessageInfo messageInfo) {
        this.addTextAreaToReply(pane, messageInfo, false);
    }

    public void addTextAreaToReply(Pane pane, MessageInfo messageInfo, boolean isReplay) {
        this.clientUtil.addTextAreaToReply(pane, messageInfo, isReplay);
    }

    public VirtualizedScrollPane<MyStyledTextArea> addTextAreaToPane(final Pane pane, final String text) {
        return this.clientUtil.addTextAreaToPane(pane, text, new IInnerMessageTextArea(){
            private final String t;
            {
                this.t = text;
            }

            @Override
            public void resizeParent(int height, int linesCount) {
                if (!this.t.contains("\n")) {
                    height = this.getHeight();
                }
                int h = Math.max(25 * linesCount + 30, height);
                pane.setPrefHeight((double)Math.min(200, h));
                pane.setMinHeight((double)Math.min(200, h));
                pane.setMaxHeight((double)Math.min(200, h));
            }

            @Override
            public void sendMessage(String message) {
            }

            @Override
            public void clearEditedMessage() {
            }

            @Override
            public void clearMessagePane(int height) {
            }

            private int getHeight() {
                Font font = new Font("Arial", 0, 12);
                Canvas c = new Canvas();
                FontMetrics metrics = c.getFontMetrics(font);
                int textLength = metrics.charWidth('a') * this.t.length();
                int linesCount = textLength / 290;
                return 25 * linesCount + 30;
            }
        });
    }

    public void onWakeUp() {
        TimerExecutor.getInstance().setMyAction(() -> {
            try {
                this.clientConnector.onWakeUp();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).startWithDelay(1000L);
    }

    public void loadRegistrationScene() {
        try {
            this.mainViewModel.loadRegistrationScene();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createMeeting(SessionInfo sessionInfo) {
        this.clientUtil.createMeeting(sessionInfo);
    }

    public void setStyledTextControl(Text text, boolean isBold, String color, int size, boolean isLink) {
        this.clientUtil.setStyledTextControl(text, isBold, color, size, isLink);
    }

    public TextFlow addStyledTextArea(String content, String text, String color, int size) {
        if (content == null) {
            content = "";
        }
        List<Text> indexRanges = null;
        TextFlow myStyledTextArea = new TextFlow();
        try {
            indexRanges = this.getIndexRanges(content, text, color, size);
            for (Text str : indexRanges) {
                myStyledTextArea.getChildren().add((Object)str);
            }
        }
        catch (Exception e) {
            myStyledTextArea.getChildren().add((Object)new Text(content));
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Error setContentToStyledTextArea : " + content + " e : " + e.getMessage());
        }
        myStyledTextArea.setStyle("-fx-cursor: hand;");
        return myStyledTextArea;
    }

    public List<Text> getIndexRanges(String content, String inputText, String color, int size) throws Exception {
        ArrayList<Text> parsedContent = new ArrayList<Text>();
        if (content == null) {
            return parsedContent;
        }
        int index = content.toLowerCase().indexOf(inputText.trim().toLowerCase());
        if (!inputText.isEmpty() && index != -1) {
            Text regularText;
            String sub;
            String searchTextSelectedColor = ClientSingleton.getInstance().getStyle(Constants.SEARCH_TEXT_SELECTED_COLOR).get();
            int startIndex = 0;
            while (index != -1) {
                sub = content.substring(startIndex, index);
                regularText = new Text(sub);
                ClientSingleton.getInstance().setStyledTextControl(regularText, false, color, size, false);
                parsedContent.add(regularText);
                sub = content.substring(index, index + inputText.length());
                Text selectedText = new Text(sub);
                ClientSingleton.getInstance().setStyledTextControl(selectedText, false, searchTextSelectedColor, size, false);
                parsedContent.add(selectedText);
                startIndex = index + inputText.length();
                index = content.toLowerCase().indexOf(inputText.toLowerCase(), index + 1);
            }
            if (startIndex < content.length()) {
                sub = content.substring(startIndex);
                regularText = new Text(sub);
                ClientSingleton.getInstance().setStyledTextControl(regularText, false, color, size, false);
                parsedContent.add(regularText);
            }
        }
        if (parsedContent.isEmpty()) {
            Text regularText = new Text(content);
            ClientSingleton.getInstance().setStyledTextControl(regularText, false, color, size, false);
            parsedContent.add(regularText);
        }
        return parsedContent;
    }

    public void setContentToStyledTextArea(TextFlow myStyledTextArea, String content, String inputText, String color, int size) {
        try {
            List<Text> indexRanges = ClientSingleton.getInstance().getIndexRanges(content, inputText, color, size);
            myStyledTextArea.getChildren().clear();
            for (Text str : indexRanges) {
                myStyledTextArea.getChildren().add((Object)str);
            }
        }
        catch (Exception e) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Error setContentToStyledTextArea : " + content + " e: " + e.getMessage());
            myStyledTextArea.getChildren().add((Object)new Text(content));
        }
    }

    public String getCallTitle(String sessionName, MessageInfo messageInfo) {
        return this.clientUtil.getCallTitle(sessionName, messageInfo);
    }

    public boolean isRegistrationPaneShow() {
        return this.mainViewModel != null && this.mainViewModel.isRegistrationPaneShow();
    }

    public void updateTransferView(String serviceId) {
        if (this.clientUtil != null && AudioCaller.getActiveLine() != null) {
            this.clientUtil.updateTransferView(serviceId);
        }
    }

    public void setBackgroundImage(ImageView fxIvBackground, String image) {
        this.resizeHelper.setBackgroundImage(fxIvBackground, image);
    }
}

