/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.css.CssParser;
import javafx.css.Selector;
import javafx.css.Stylesheet;
import javafx.css.converter.BooleanConverter;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import net.sipsnet.client.annotations.Version;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.resources.JarResources;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import smile.util.ResourceStore;

public class ClientSingletonUtil {
    private String packageName = "Ringotel";
    protected static String startExeName = "ringotel";
    protected String DefaultSipDomain = ".ringotel.co";
    protected String DefaultSipDomain1 = ".ringotel.net";
    private final String themeFileName = "theme";
    private final String resourceBaseFileName = "/res_base";
    private final String themeLightFileName = "/backgrounds.css";
    private final String themeDarkFileName = "/dark/backgrounds.css";
    public static String VERSION;
    private final Map<String, String> defaultStyleValues = new HashMap<String, String>();
    private final Map<String, String> lightStyleValues = new HashMap<String, String>();
    private final Map<String, String> darkStyleValues = new HashMap<String, String>();
    private String javaVersion;

    public boolean isJavaVersion11() {
        return this.javaVersion.startsWith("11");
    }

    public String getCSSResourcesFileName() {
        return Theme.getInstance().isDarkTheme() ? "/dark/backgrounds.css" : "/backgrounds.css";
    }

    private boolean readBaseFile() {
        boolean hasBaseFile = false;
        try (InputStream inputStream = ClientSingleton.class.getResourceAsStream("/res_base");
             InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            String text;
            while ((text = reader.readLine()) != null) {
                if (text.contains("app_name")) {
                    this.packageName = text.replace("app_name=", "");
                } else if (text.contains("start_name")) {
                    startExeName = text.replace("start_name=", "").toLowerCase();
                } else if (text.contains("theme")) {
                    String theme = text.replace("theme=", "").toLowerCase();
                    Theme.getInstance().setTheme(theme.contains("dark") ? Theme.ThemeType.DARK : Theme.ThemeType.LIGHT);
                    ClientSingletonUtil.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " ClientSingleton create constructor base theme=" + Theme.getInstance().getTheme());
                }
                if (hasBaseFile) continue;
                hasBaseFile = true;
            }
        }
        catch (Exception e) {
            hasBaseFile = false;
        }
        return hasBaseFile;
    }

    public void initValues() {
        this.initDefaultValues();
        boolean hasBaseFile = this.readBaseFile();
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " ClientSingleton create constructor check hasBaseFile=" + hasBaseFile);
        String themeMode = this.getThemeMode();
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " ClientSingleton create constructor check themeMode=" + themeMode);
        if (themeMode != null) {
            Theme.getInstance().setTheme(themeMode.contains("dark") ? Theme.ThemeType.DARK : Theme.ThemeType.LIGHT);
        }
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " ClientSingleton create constructor current theme=" + Theme.getInstance().getTheme());
        if (Theme.getInstance().isDarkTheme()) {
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " ClientSingleton create constructor check isHasDarkTheme");
            boolean isHasDarkTheme = JarResources.getInstance().isHasDarkTheme();
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " ClientSingleton create constructor isHasDarkTheme=" + isHasDarkTheme);
            if (!isHasDarkTheme) {
                Theme.getInstance().setTheme(Theme.ThemeType.LIGHT);
            }
        }
        this.javaVersion = System.getProperty("java.version");
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), System.currentTimeMillis() + " ClientSingleton create constructor javaVersion=" + this.javaVersion);
        this.readCssFiles();
        this.readBackgroundCSS("/backgrounds.css", hasBaseFile);
        this.readBackgroundCSS("/dark/backgrounds.css", hasBaseFile);
        Version version = ClientSingleton.class.getAnnotation(Version.class);
        VERSION = version.currentVersion();
        this.DefaultSipDomain = version.app_domain();
        Constants.colorForSmallFont = Theme.getInstance().isDarkTheme() ? MyStyledTextArea.getFontColor() : "#646a7e";
    }

    private void readCssFiles() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "init css: start");
        Theme.getInstance().setCSS_TEMPLATE(this.readResourcesCss("css_template"));
        Theme.getInstance().setCSS_SLIDER_BAR(this.readResourcesCss("css_slider_bar"));
        Theme.getInstance().setCSS_PROGRESS_BAR(this.readResourcesCss("css_progress_bar"));
        Theme.getInstance().setCSS_VIRTUALIZED_SCROLL(this.readResourcesCss("css_virtualized_scrollbar"));
        Theme.getInstance().setCSS_SCROLL_PANE(this.readResourcesCss("css_scroll_pane"));
        Theme.getInstance().setCSS_CONTEXT_MENU(this.readResourcesCss("css_context_menu"));
        Theme.getInstance().setCSS_ALERT_TEXT_AREA(this.readResourcesCss("css_alert_text_area"));
        Theme.getInstance().setCSS_TEXT_AREA(this.readResourcesCss("css_text_area"));
        Theme.getInstance().setCSS_PROFILES_PANE(this.readResourcesCss("css_profile_pane"));
        Theme.getInstance().setCSS_KEY_TEMPLATE(this.readResourcesCss("css_key_template"));
        Theme.getInstance().setCSS_NOTIFICATION_BACKGROUND(this.readResourcesCss("css_notification_background"));
        ClientSingleton.toLog(this.getClass().getSimpleName(), "init css: done");
    }

    private String readResourcesCss(String fileName) {
        fileName = "/css/" + (String)fileName;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "fileName " + (String)fileName);
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStream inputStream = ClientSingleton.class.getResourceAsStream((String)fileName);
             InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            String text;
            while ((text = reader.readLine()) != null) {
                stringBuilder.append(text).append("\n");
            }
            if (this.isJavaVersion11()) {
                stringBuilder.delete(0, "data:text/css,".length());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stringBuilder.toString().trim();
    }

    private void readBackgroundCSS(String fileName, boolean hasBaseFile) {
        StringBuilder stringBuilder = null;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "readBackgroundCSS fileName = " + fileName);
        try (InputStream inputStream2 = ClientSingleton.class.getResourceAsStream(fileName);
             InputStreamReader streamReader = new InputStreamReader(inputStream2, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            String text;
            stringBuilder = new StringBuilder();
            while ((text = reader.readLine()) != null) {
                stringBuilder.append(text);
                if (hasBaseFile) continue;
                if (text.contains("app_name")) {
                    this.packageName = text.replace("app_name=", "");
                    continue;
                }
                if (!text.contains("start_name")) continue;
                startExeName = text.replace("start_name=", "").toLowerCase();
            }
        }
        catch (Exception inputStream2) {
            // empty catch block
        }
        if (stringBuilder != null) {
            boolean isDarkTheme = fileName.equals("/dark/backgrounds.css");
            int index = -1;
            while ((index = stringBuilder.indexOf("css")) != -1) {
                int start = stringBuilder.lastIndexOf(".", index);
                int end = stringBuilder.indexOf("}", index) + 1;
                String keyValue = stringBuilder.substring(start, end).replace(".", "");
                stringBuilder.replace(start, end, "");
                String name = keyValue.substring(0, keyValue.indexOf("{"));
                this.putStyleValues(isDarkTheme, name, "/css/" + name + ".css");
            }
            CssParser cssParser = new CssParser();
            Stylesheet stylesheet = cssParser.parse(stringBuilder.substring(0, stringBuilder.lastIndexOf("}") + 1));
            stylesheet.getRules().forEach(rule -> {
                if (!rule.getSelectors().isEmpty()) {
                    Selector selector = (Selector)rule.getSelectors().get(0);
                    String name = selector.toString().replace("*.", "");
                    rule.getDeclarations().forEach(declaration -> {
                        String tag;
                        StringBuffer stringBuffer1 = new StringBuffer();
                        String parsedValue = declaration.getParsedValue().toString();
                        Object styleValue = null;
                        if (declaration.getParsedValue().getConverter() instanceof BooleanConverter) {
                            styleValue = BooleanConverter.getInstance().convert(declaration.getParsedValue(), null);
                        } else if (parsedValue.contains("SequenceConverter")) {
                            parsedValue = parsedValue.replace("\\\n", "").replace("<Value><value values=", "");
                            tag = "<value>";
                            parsedValue = parsedValue.substring(parsedValue.indexOf(tag) + tag.length());
                            tag = "</value>";
                            styleValue = parsedValue.substring(0, parsedValue.indexOf(tag)).replace("0x", "#").substring(0, 7) + ";";
                        } else if (parsedValue.contains("0x") && parsedValue.contains("ff")) {
                            tag = "<value>";
                            parsedValue = parsedValue.substring(parsedValue.indexOf(tag) + tag.length());
                            tag = "</value>";
                            styleValue = parsedValue.substring(0, parsedValue.indexOf(tag)).replace("0x", "#").substring(0, 7) + ";";
                        } else if (parsedValue.contains("<converter>null</converter>")) {
                            tag = "<value>";
                            parsedValue = parsedValue.substring(parsedValue.indexOf(tag) + tag.length());
                            tag = "</value>";
                            styleValue = parsedValue.substring(0, parsedValue.indexOf(tag));
                            String property = styleValue.toString();
                            this.putStyleValues(isDarkTheme, name, property);
                            styleValue = null;
                        }
                        if (styleValue != null) {
                            stringBuffer1.append(declaration.getProperty()).append(":").append(styleValue);
                            if (name.equals(Constants.BLUE_ALTERNATIVE_COLOR)) {
                                this.putStyleValues(isDarkTheme, Constants.BLUE_ALTERNATIVE_COLOR, styleValue.toString().replace(";", ""));
                            } else {
                                if (name.equals(Constants.BUTTON_BACKGROUND_STYLE)) {
                                    this.putStyleValues(isDarkTheme, Constants.BUTTON_INNER_BACKGROUND_STYLE, stringBuffer1.toString().replace("-fx-background-color", "-fx-control-inner-background"));
                                }
                                String property = ClientSingletonUtil.getString(stringBuffer1);
                                this.putStyleValues(isDarkTheme, name, property);
                            }
                        }
                    });
                }
            });
            ClientSingleton.toLog(this.getClass().getSimpleName(), "darkStyleValues = " + this.darkStyleValues);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "lightStyleValues = " + this.lightStyleValues);
        }
    }

    private static String getString(StringBuffer stringBuffer1) {
        String property = stringBuffer1.toString();
        if (stringBuffer1.toString().contains("-fx-background-color")) {
            property = stringBuffer1.toString().replace("-fx-background-color", "");
        } else if (stringBuffer1.toString().contains("-fx-text-fill")) {
            property = stringBuffer1.toString().replace("-fx-text-fill", "");
        } else if (stringBuffer1.toString().contains("-fx-progress-color")) {
            property = stringBuffer1.toString().replace("-fx-progress-color", "");
        }
        property = property.replace("value", "").replace(";", "").replace(":", "").replace("\"", "");
        return property;
    }

    private void putStyleValues(boolean isDarkTheme, String name, String stringBuffer1) {
        if (isDarkTheme) {
            this.darkStyleValues.put(name, stringBuffer1);
        } else {
            this.lightStyleValues.put(name, stringBuffer1);
        }
    }

    private void initDefaultValues() {
        this.defaultStyleValues.put(Constants.BASE_COLOR, "#f1f2f5");
        this.defaultStyleValues.put(Constants.SECOND_BASE_COLOR, "#f1f2f5");
        this.defaultStyleValues.put(Constants.TABS_SEARCH_BACKGROUND, "white");
        this.defaultStyleValues.put(Constants.POPUP_WINDOWS_BACKGROUND, "#FDFEFE");
        this.defaultStyleValues.put(Constants.SUBJECT_TEXT_FILL, "#656a7c");
        this.defaultStyleValues.put(Constants.TAB_CELL_TEXT_FILL, "#252b40");
        this.defaultStyleValues.put(Constants.TAB_CELL_DATE_TEXT_FILL, "#646a7e");
        this.defaultStyleValues.put(Constants.TABS_TITLE_TEXT_FILL, "#252b40");
        this.defaultStyleValues.put(Constants.PROFILES_PANE_BACKGROUND, "#ffffff");
        this.defaultStyleValues.put(Constants.TABS_SELECTED_CELL, "#d9e0ef");
        this.defaultStyleValues.put(Constants.CONTACT_SELECTED_CELL, "#d9e0ef");
        this.defaultStyleValues.put(Constants.TABS_UNSELECTED_CELL, "transparent");
        this.defaultStyleValues.put(Constants.LOGIN_BACKGROUND_STYLE, "#ffffff");
        this.defaultStyleValues.put(Constants.LOGIN_LABEL_TEXT_FILL, "#636a80");
        this.defaultStyleValues.put(Constants.LOGIN_BUTTON_TEXT_FILL, "#ffffff");
        this.defaultStyleValues.put(Constants.LOGIN_BUTTON_BACKGROUND_STYLE, "#4b96d5");
        this.defaultStyleValues.put(Constants.PROGRESS_INDICATOR_STYLE, "#4b96d5");
        this.defaultStyleValues.put(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL, "#252b40");
        this.defaultStyleValues.put(Constants.TABS_PANE_STYLE, "#252b40");
        this.defaultStyleValues.put(Constants.TABS_PANE_STYLE_1, "#252b40");
        this.defaultStyleValues.put(Constants.SELECTED_LINE_STYLE, "#252b40");
        this.defaultStyleValues.put(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND, "#dce0ec");
        this.defaultStyleValues.put(Constants.CHAT_MESSAGE_TEXT_FILL, "#252b40");
        this.defaultStyleValues.put(Constants.CHAT_CELL_HEADER_TEXT_FILL, "#656a7c");
        this.defaultStyleValues.put(Constants.CHAT_DATE_LABEL_STYLE, "#dce0ec");
        this.defaultStyleValues.put(Constants.CHAT_DATE_LABEL_TEXT_FILL, "#ffffff");
        this.defaultStyleValues.put(Constants.CHAT_INCOMING_MESSAGE_BACKGROUND, "#ffffff");
        this.defaultStyleValues.put(Constants.CHAT_OUTGOING_MESSAGE_BACKGROUND, "#dce0ec");
        this.defaultStyleValues.put(Constants.CHAT_COMMENT_MESSAGE_BACKGROUND, "#fff3bd");
        this.defaultStyleValues.put(Constants.CHAT_REPLY_MESSAGE_BACKGROUND, "#969aae");
        this.defaultStyleValues.put(Constants.CHAT_REPLY_INCOMING_MESSAGE_BACKGROUND, "#969aae");
        this.defaultStyleValues.put(Constants.CHAT_REPLY_OUTGOING_MESSAGE_BACKGROUND, "#969aae");
        this.defaultStyleValues.put(Constants.CHAT_REPLY_MESSAGE_BACKGROUND, "#969aae");
        this.defaultStyleValues.put(Constants.CHAT_REPLY_MESSAGE_TEXT_FILL, "#252b40");
        this.defaultStyleValues.put(Constants.CHAT_MISSED_CALL_BACKGROUND, "#ffb0b0");
        this.defaultStyleValues.put(Constants.CHAT_LINKS_TEXT_FILL, "#0a5ca1");
        this.defaultStyleValues.put(Constants.BUTTON_BACKGROUND_STYLE, "#4b96d5");
        this.defaultStyleValues.put(Constants.BUTTON_INNER_BACKGROUND_STYLE, "#4b96d5");
        this.defaultStyleValues.put(Constants.CALL_LINE_STYLE, "#232b44");
        this.defaultStyleValues.put(Constants.CALL_CHAT_LINE_STYLE, "#232b44");
        this.defaultStyleValues.put(Constants.CALL_NOTIFICATION_STYLE, "#4b96d5");
        this.defaultStyleValues.put(Constants.CALL_HOLD_STYLE, "#5d668c");
        this.defaultStyleValues.put(Constants.BLUE_ALTERNATIVE_COLOR, "#4B96D5");
        this.defaultStyleValues.put(Constants.SEARCH_TEXT_SELECTED_COLOR, "#8B8000");
        this.defaultStyleValues.put(Constants.CALL_TRANSFER_STYLE, "#252b40");
        this.defaultStyleValues.put(Constants.NOTIFICATION_STYLE, "rgba( 17, 24, 46, 0.9)");
        this.defaultStyleValues.put(Constants.BUTTONS_COLOR, "");
        this.defaultStyleValues.put(Constants.IS_CUSTOM_ICONS, "");
        this.defaultStyleValues.put(Constants.IS_CUSTOM_MENU_ONLINE_STATUS, "");
        this.defaultStyleValues.put(Constants.IS_CUSTOM_HANGUP_BUTTON, "");
        this.defaultStyleValues.put(Constants.IS_CUSTOM_ANSWER_BUTTON, "");
        this.defaultStyleValues.put(Constants.HAS_LOGIN_BACKGROUND_IMAGE, "true");
        this.defaultStyleValues.put(Constants.NEW_DEFAULT_SERVER_NAME, "");
        Theme.getInstance().setTheme(Theme.ThemeType.LIGHT);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public static String getStartExeName() {
        return startExeName;
    }

    public static void toLog(String tag, String message) {
        ResourceStore.toLog((String)(tag + " : " + Thread.currentThread().getName() + " " + VERSION + " : " + message));
    }

    public static void memoryReport() {
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memBean.getHeapMemoryUsage();
        ResourceStore.toLog((String)("memoryReport : " + Thread.currentThread().getName() + "(" + ManagementFactory.getThreadMXBean().getThreadCount() + ") " + heapMemoryUsage));
    }

    private static String formatSize(long v) {
        if (v < 1024L) {
            return v + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(v)) / 10;
        return String.format("%.1f %sB", (double)v / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }

    public static void errorLog(String tag, Throwable ex) {
        ResourceStore.error((String)tag, (Throwable)ex);
    }

    public void setStyle(Pane pane, String key) {
        this.getStyle(key).ifPresent(arg_0 -> ((Pane)pane).setStyle(arg_0));
    }

    public void setStyle(Button button, String key) {
        this.getStyle(key).ifPresent(arg_0 -> ((Button)button).setStyle(arg_0));
    }

    public Optional<String> getStyle(String key) {
        if (Theme.getInstance().isDarkTheme()) {
            if (this.darkStyleValues.containsKey(key)) {
                return Optional.of(this.darkStyleValues.get(key));
            }
        } else if (this.lightStyleValues.containsKey(key)) {
            return Optional.of(this.lightStyleValues.get(key));
        }
        return this.defaultStyleValues.get(key).isEmpty() ? Optional.empty() : Optional.of(this.defaultStyleValues.get(key));
    }

    public String getStyleValue(Theme.ThemeType themeType, String key) {
        String style = null;
        switch (themeType) {
            case DARK: {
                if (this.darkStyleValues.containsKey(key)) {
                    style = this.darkStyleValues.get(key);
                    break;
                }
                style = this.defaultStyleValues.get(key);
                break;
            }
            case LIGHT: {
                style = this.lightStyleValues.containsKey(key) ? this.lightStyleValues.get(key) : this.defaultStyleValues.get(key);
            }
        }
        return style;
    }

    public String getStyleValue(String key) {
        String style = null;
        switch (Theme.getInstance().getTheme()) {
            case DARK: {
                if (this.darkStyleValues.containsKey(key)) {
                    style = this.darkStyleValues.get(key);
                    break;
                }
                style = this.defaultStyleValues.get(key);
                break;
            }
            case LIGHT: {
                style = this.lightStyleValues.containsKey(key) ? this.lightStyleValues.get(key) : this.defaultStyleValues.get(key);
            }
        }
        return style;
    }

    private String getThemeMode() {
        String themeMode = null;
        try (FileReader fileReader = new FileReader(this.getFileName());){
            LineNumberReader reader = new LineNumberReader(fileReader);
            themeMode = reader.readLine().replace("theme=", "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return themeMode;
    }

    private void setThemeMode(Theme.ThemeType themeType) {
        String fileName = this.getFileName();
        File theme = new File(fileName);
        boolean exists = theme.exists();
        if (!exists) {
            try {
                exists = theme.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Files.newBufferedWriter(Path.of(System.getProperty("user.home"), "." + this.getPackageName().toLowerCase(), "theme"), StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (exists) {
            try (PrintWriter prn = new PrintWriter(fileName);){
                prn.println("theme:" + (themeType == Theme.ThemeType.DARK ? "dark" : "light"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private String getFileName() {
        return System.getProperty("user.home") + File.separator + "." + this.getPackageName().toLowerCase() + File.separator + "theme";
    }
}

