/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.clientlisteners.listeners;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.clientlisteners.ClientListenersModel;
import net.sipsnet.client.constants.IntentConstants;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactEventListener;
import smile.cti.client.ContactInfo;

public class ContactListener
implements ContactEventListener,
Serializable {
    static final long serialVersionUID = 6378408992536443243L;
    private final ClientListenersModel clientListenersModel;

    public ContactListener(ClientListenersModel clientListenersModel) {
        this.clientListenersModel = clientListenersModel;
    }

    public void statusChanged(ContactInfo contactInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contactInfo", contactInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.CONTACT_STATUS_CHANGED, data);
    }

    public void stateChanged(ContactInfo contactInfo) {
        Optional<ClientConnector> optionalClientConnector;
        ClientSingleton.toLog("ContactListener", contactInfo.hashCode() + " stateChanged contactInfo=" + contactInfo + " getState() = " + contactInfo.getState() + " getState() = " + contactInfo.getStatus() + " isFeature = " + contactInfo.isFeature() + " isSlot = " + contactInfo.isSlot());
        if (!contactInfo.isFeature() && (optionalClientConnector = ClientSingleton.getInstance().getClientConnector()).isPresent() && ClientSingleton.getInstance().getUserID(contactInfo).equals(optionalClientConnector.get().getUserId())) {
            return;
        }
        ClientSingleton.getInstance().getMainViewModel().onContactInfoStateChanged(contactInfo);
    }

    public void imageLoaded(ContactInfo contactInfo) {
        ClientSingleton.toLog("ContactListener", "imageLoaded contactInfo=" + contactInfo + " contactInfo.hasAvatar()=" + contactInfo.hasAvatar());
        if (contactInfo.hasAvatar()) {
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            optionalClientConnector.ifPresent(clientConnector -> {
                File file;
                ClientSingleton.toLog("ContactListener", "imageLoaded contactInfo=" + contactInfo + " file=" + file + " file.exists() = " + (Serializable)((file = clientConnector.getAvatar(contactInfo)) != null ? Boolean.valueOf(file.exists()) : "false"));
                if (file != null && file.exists() && ClientSingleton.getInstance().setAvatarImage(null, ClientSingleton.getInstance().getUserID(contactInfo), file, 32, 32, true)) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("contactInfo", contactInfo);
                    this.clientListenersModel.notifyMessage(IntentConstants.CONTACT_IMAGE_LOAD, data);
                }
            });
        }
    }

    public void dataChanged(ContactInfo contactInfo) {
        ClientSingleton.toLog("ContactListener", "dataChanged contactInfo=" + contactInfo);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contactInfo", contactInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.CONTACT_DATA_UPDATED, data);
    }
}

