/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.MyActionWithParameter;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.phonesmenu.MyPhonesMenu;
import net.sipsnet.client.utils.viewers.trunksmenu.MyTrunksMenu;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;

public class AudioCaller {
    private static final String TAG = "AudioCaller";
    private static String outboundTrunk;

    public static String getOutboundTrunk() {
        return outboundTrunk;
    }

    public static void setMute(boolean isMute) {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            clientConnector.setMute(isMute);
            ClientSingleton.toLog(TAG, " isMute=" + isMute + " clientConnector.getMute()=" + clientConnector.getMute());
            ClientSingleton.getInstance().doNotify(IntentConstants.LINE_INFO_MUTE_LINE);
        });
    }

    public static void setMute() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.setMute(!clientConnector.getMute()));
    }

    public static boolean isMute() {
        AtomicBoolean isMute = new AtomicBoolean();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> isMute.set(clientConnector.getMute()));
        return isMute.get();
    }

    public static void unMute() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (clientConnector.getMute()) {
                AudioCaller.setMute(false);
            }
        });
    }

    public static void dropCall(LineInfo lineInfo) {
        if (lineInfo == null) {
            return;
        }
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            boolean wasInHold;
            LineInfo connectedLine = AudioCaller.getConnectedLine(lineInfo);
            boolean bl = wasInHold = lineInfo.getState() == 4;
            if (wasInHold) {
                AudioCaller.setActiveLine(clientConnector, lineInfo);
            }
            boolean isVideo = lineInfo.isVideoEnabled() || ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo);
            ClientSingleton.toLog("CallLineUtil", "getHangupCallImageButton LineInfo = " + lineInfo + " isVideo=" + isVideo);
            if (isVideo) {
                ClientSingleton.getInstance().getMainViewModel().getVideoProcessor().setCapturing(false);
                clientConnector.stopVideo();
            }
            TimerExecutor.getInstance().setMyAction(() -> {
                ClientSingleton.toLog("CallLineUtil", "getHangupCallImageButton LineInfo = " + lineInfo + " dropCall. connectedLine = " + connectedLine + " state = " + (connectedLine != null ? connectedLine.getState() : -1));
                clientConnector.dropCall(lineInfo);
                if (wasInHold && connectedLine != null && connectedLine.getState() != 3) {
                    TimerExecutor.getInstance().setMyAction(() -> AudioCaller.setActiveLine(clientConnector, connectedLine)).startWithDelay(1000L);
                }
            }).startWithDelay(isVideo && ClientUtil.getOS() == ClientUtil.OS.MAC ? 1500L : 500L);
        });
    }

    public static void makeCall(SessionInfo sessionInfo, boolean isVideoEnabled) {
        try {
            throw new Exception("makeCall");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            outboundTrunk = null;
            ClientSingleton.toLog(TAG, "makeCall (" + sessionInfo.hashCode() + ") sessionInfo=" + sessionInfo + " id=" + sessionInfo.getSessionId() + " isVideoEnabled=" + isVideoEnabled + " sessionInfo.getParties().size()=" + sessionInfo.getParties().size() + " getPartyNumbers = " + sessionInfo.getPartyNumbers());
            if (!isVideoEnabled && sessionInfo.getParties().size() == 1) {
                ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
                ClientSingleton.toLog(TAG, "makeCall contactInfo=" + contactInfo + " isContactInfoApproved=" + ClientSingleton.getInstance().isContactInfoApproved(contactInfo));
                if (ClientSingleton.getInstance().isContactInfoApproved(contactInfo)) {
                    AudioCaller.makeCall(contactInfo);
                    return;
                }
            }
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> TimerExecutor.getInstance().start(() -> clientConnector.makeCall(sessionInfo, isVideoEnabled)));
            return;
        }
    }

    public static void makeCall(ContactInfo contactInfo) {
        outboundTrunk = null;
        if (!ClientSingleton.getInstance().isContactInfoApproved(contactInfo)) {
            List<String> numbers = ClientSingleton.getInstance().getPhonesListForMenu(contactInfo);
            ClientSingleton.toLog(TAG, "makeCall numbers=" + numbers);
            if (!numbers.isEmpty()) {
                if (numbers.size() == 1) {
                    String number = numbers.get(0);
                    List<String> trunks = AudioCaller.getPBXTrunks(Collections.singletonList(number));
                    if (!trunks.isEmpty() && trunks.size() > 1) {
                        ClientSingleton.getInstance().runLater(() -> {
                            MyTrunksMenu myTrunksMenu = new MyTrunksMenu(ClientSingleton.getInstance().getString("action_call_action"));
                            myTrunksMenu.showAndWait(number, trunks, trunk -> AudioCaller.makeCall(number, trunk));
                        });
                        return;
                    }
                } else {
                    String number = MyPhonesMenu.getInstance().showAndWait(numbers);
                    ClientSingleton.toLog(TAG, "makeCall number=" + number);
                    AudioCaller.makeCall(number, true);
                    return;
                }
            }
        }
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> TimerExecutor.getInstance().start(() -> clientConnector.makeCall(contactInfo)));
    }

    public static void transferCall(ContactInfo contactInfo) {
        outboundTrunk = null;
        if (!ClientSingleton.getInstance().isContactInfoApproved(contactInfo)) {
            List<String> numbers = ClientSingleton.getInstance().getPhonesListForMenu(contactInfo);
            ClientSingleton.toLog(TAG, "makeCall numbers=" + numbers);
            if (!numbers.isEmpty()) {
                if (numbers.size() == 1) {
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.transferCall(contactInfo));
                } else {
                    String number = MyPhonesMenu.getInstance().showAndWait(numbers);
                    ClientSingleton.toLog(TAG, "makeCall number=" + number);
                    List<String> trunks = AudioCaller.getPBXTrunks(Collections.singletonList(number));
                    ClientSingleton.toLog(TAG, "makeCall number=" + number + " trunks=" + trunks);
                    if (trunks.size() > 1) {
                        ClientSingleton.getInstance().runLater(() -> {
                            MyTrunksMenu myTrunksMenu = new MyTrunksMenu(ClientSingleton.getInstance().getString("action_transfer_action"));
                            myTrunksMenu.showAndWait(number, trunks, trunk -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.transferCall(number)));
                        });
                    } else {
                        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.transferCall(number));
                    }
                }
            }
        } else {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.transferCall(contactInfo));
        }
    }

    public static void setHoldLine(LineInfo lineInfo) {
        ClientSingleton.getInstance().setUsbHold(true);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.holdCall(lineInfo));
    }

    public static void setActiveLine(LineInfo lineInfo) {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.setActiveLine(clientConnector, lineInfo));
    }

    public static void setActiveLine(ClientConnector clientConnector, LineInfo lineInfo) {
        ClientSingleton.getInstance().setUsbHold(false);
        clientConnector.setActiveLine(lineInfo);
    }

    public static void makeAudioCallToExternal(SessionInfo sessionInfo, boolean withAllNumbersAndTrunks) {
        if (sessionInfo.isGroup()) {
            AudioCaller.makeCall(sessionInfo, false);
        } else {
            ArrayList<String> numbers = new ArrayList<String>();
            if (!withAllNumbersAndTrunks) {
                numbers.addAll(sessionInfo.getPartyNumbers());
                if (!numbers.isEmpty()) {
                    AudioCaller.makeCall((String)numbers.get(0), withAllNumbersAndTrunks);
                    return;
                }
            }
            ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
            numbers.addAll(ClientSingleton.getInstance().getPhonesListForMenu(contactInfo));
            AtomicReference<String> atomicReference = new AtomicReference<String>((String)numbers.get(0));
            if (numbers.size() > 1) {
                atomicReference.set(MyPhonesMenu.getInstance().setTitle(sessionInfo.toString()).showAndWait(numbers));
            } else {
                atomicReference.set((String)numbers.get(0));
            }
            ClientSingleton.toLog(TAG, "makeAudioCallToExternal number=" + atomicReference);
            if (atomicReference.get() != null && !atomicReference.get().isEmpty()) {
                AudioCaller.makeCall(atomicReference.get(), withAllNumbersAndTrunks);
            }
        }
    }

    public static void makeAudioCallToExternal(String title, List<String> numbers, List<String> trunks) {
        AtomicReference<String> atomicReference = new AtomicReference<String>(numbers.get(0));
        if (numbers.size() > 1) {
            atomicReference.set(MyPhonesMenu.getInstance().setTitle(title).showAndWait(numbers));
        } else {
            atomicReference.set(numbers.get(0));
        }
        ClientSingleton.toLog(TAG, "makeAudioCallToExternal number=" + atomicReference);
        if (atomicReference.get() != null && !atomicReference.get().isEmpty()) {
            AudioCaller.makeCall(atomicReference.get(), trunks);
        }
    }

    public static void makeCall(String number, List<String> trunks) {
        outboundTrunk = null;
        if (number == null || number.isEmpty()) {
            return;
        }
        ClientSingleton.toLog(TAG, "makeCall number=" + number + " trunks=" + trunks);
        if (trunks.size() > 1) {
            ClientSingleton.getInstance().runLater(() -> {
                MyTrunksMenu myTrunksMenu = new MyTrunksMenu(ClientSingleton.getInstance().getString("action_call_action"));
                myTrunksMenu.showAndWait(number, trunks, trunk -> AudioCaller.makeCall(number, trunk));
            });
        } else if (trunks.size() == 1) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.makeCall(clientConnector, number, (String)trunks.get(0)));
        } else {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.makeCall(clientConnector, number));
        }
    }

    public static void makeCall(String number) {
        outboundTrunk = null;
        if (number == null || number.isEmpty()) {
            return;
        }
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            List trunks = clientConnector.getTrunks(null);
            AudioCaller.makeCall(number, trunks);
        });
    }

    public static void makeCall(String number, boolean isWithTrunks) {
        outboundTrunk = null;
        if (number == null || number.isEmpty()) {
            return;
        }
        List<String> trunks = AudioCaller.getPBXTrunks(List.of(number));
        ClientSingleton.toLog(TAG, "makeCall number=" + number + " trunks=" + trunks);
        if (isWithTrunks) {
            if (trunks.size() > 1) {
                ClientSingleton.getInstance().runLater(() -> {
                    MyTrunksMenu myTrunksMenu = new MyTrunksMenu(ClientSingleton.getInstance().getString("action_call_action"));
                    myTrunksMenu.showAndWait(number, trunks, trunk -> AudioCaller.makeCall(number, trunk));
                });
            } else if (trunks.size() == 1) {
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.makeCall(clientConnector, number, (String)trunks.get(0)));
            } else {
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.makeCall(clientConnector, number));
            }
        } else if (!trunks.isEmpty()) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.makeCall(clientConnector, number, (String)trunks.get(0)));
        } else {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.makeCall(clientConnector, number));
        }
    }

    private static void makeCall(ClientConnector clientConnector, String number) {
        TimerExecutor.getInstance().setMyAction(() -> clientConnector.makeCall(number)).startWithDelay(200L);
    }

    private static void makeCall(ClientConnector clientConnector, String number, String trunk) {
        TimerExecutor.getInstance().setMyAction(() -> clientConnector.makeCall(number, trunk)).startWithDelay(200L);
    }

    public static void makeCall(String number, String trunk) {
        outboundTrunk = trunk;
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> AudioCaller.makeCall(clientConnector, number, trunk));
    }

    public static void sendSmsMms(SessionInfo sessionInfo, Object value, boolean isWithAllTrunkList) {
        Optional<ClientConnector> oClientConnector;
        ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
        ArrayList<String> numbers = new ArrayList<String>();
        if (!isWithAllTrunkList) {
            numbers.addAll(sessionInfo.getPartyNumbers());
        }
        if (isWithAllTrunkList || numbers.isEmpty()) {
            numbers.addAll(ClientSingleton.getInstance().getPhonesListForMenu(contactInfo));
        }
        ClientSingleton.toLog(TAG, "sendSmsMms numbers = " + numbers);
        if (numbers.isEmpty()) {
            numbers.add(sessionInfo.toString());
        }
        String title = ClientSingleton.getInstance().getString(value instanceof String ? "action_sms_to_action" : "action_mms_to_action");
        AtomicReference<String> atomicReference = new AtomicReference<String>((String)numbers.get(0));
        ClientSingleton.toLog(TAG, "sendSmsMms first number = " + atomicReference);
        if (numbers.size() > 1) {
            atomicReference.set(MyPhonesMenu.getInstance().setTitle(title).showAndWait(numbers));
        }
        if (atomicReference.get() != null && !atomicReference.get().isEmpty() && (oClientConnector = ClientSingleton.getInstance().getClientConnector()).isPresent()) {
            List smsTrunks = oClientConnector.get().getSIPTrunksForSMS();
            List mmsTrunks = oClientConnector.get().getSIPTrunksForMMS();
            ClientSingleton.toLog(TAG, "sendSmsMms oClientConnector.get().getSIPTrunksForSMS()=" + smsTrunks);
            ClientSingleton.toLog(TAG, "sendSmsMms oClientConnector.get().getSIPTrunksForMMS()=" + mmsTrunks);
            ArrayList<String> trunks = new ArrayList<String>();
            if (isWithAllTrunkList) {
                trunks.addAll(value instanceof String ? smsTrunks : mmsTrunks);
            } else {
                trunks.addAll(value instanceof String ? smsTrunks : mmsTrunks);
            }
            ClientSingleton.toLog(TAG, "sendSmsMms trunks=" + trunks + " value.getClass() = " + value.getClass());
            MyActionWithParameter<String> myActionWithParameter = value instanceof String ? trunk -> {
                AudioCaller.clearChatMessagePane();
                TimerExecutor.getInstance().start(() -> ((ClientConnector)oClientConnector.get()).sendSMS(sessionInfo, (String)atomicReference.get(), (String)value, trunk));
            } : trunk -> {
                AudioCaller.clearChatMessagePane();
                ClientSingleton.toLog(TAG, "sendSmsMms exec");
                TimerExecutor.getInstance().start(() -> {
                    ClientSingleton.toLog(TAG, "sendSmsMms value=" + value);
                    ((ClientConnector)oClientConnector.get()).sendMMS(sessionInfo, (String)atomicReference.get(), (File)value, trunk);
                });
            };
            title = ClientSingleton.getInstance().getString(value instanceof String ? "action_sms_from_action" : "action_mms_from_action");
            AudioCaller.sendSmsMms(title, atomicReference.get(), trunks, myActionWithParameter);
        }
    }

    private static void clearChatMessagePane() {
        ClientSingleton.getInstance().getMainViewModel().clearChatMessagePane();
    }

    private static void sendSmsMms(String title, String number, List<String> trunks, MyActionWithParameter<String> myActionWithParameter) {
        if (trunks.isEmpty()) {
            return;
        }
        if (trunks.size() > 1) {
            ClientSingleton.getInstance().runLater(() -> {
                MyTrunksMenu myTrunksMenu = new MyTrunksMenu(title);
                myTrunksMenu.showAndWait(number, trunks, myActionWithParameter);
            });
        } else {
            myActionWithParameter.execute(trunks.get(0));
        }
    }

    public static void answerCall() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            for (LineInfo lineInfo : clientConnector.getLines()) {
                if (lineInfo.getState() != 2) continue;
                AudioCaller.answerCall(lineInfo, false);
                return;
            }
        });
    }

    public static void answerCall(LineInfo lineInfo) {
        AudioCaller.answerCall(lineInfo, false);
    }

    public static void answerCall(LineInfo lineInfo, boolean isVideo) {
        ClientSingleton.getInstance().setMyVideoEnabledFlag(lineInfo, isVideo);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> TimerExecutor.getInstance().start(() -> {
            try {
                clientConnector.answerCall(lineInfo, isVideo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    public static LineInfo getLineInfo(String sessionId) {
        AtomicReference atomicReference = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.getLines().stream().filter(lineInfo -> lineInfo.getState() != 0 && lineInfo.getState() != 18 && lineInfo.getState() != 8 && lineInfo.getState() != 5 && sessionId != null && lineInfo.getSessionInfo() != null && lineInfo.getSessionInfo().getSessionId() != null && sessionId.equals(lineInfo.getSessionInfo().getSessionId())).findAny().ifPresent(atomicReference::set));
        return (LineInfo)atomicReference.get();
    }

    public static LineInfo getActiveLine() {
        AtomicReference atomicReference = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (AudioCaller.getWorkingLinesCount() > 1) {
                clientConnector.getLines().stream().filter(lineInfo -> lineInfo.getState() == 2 || lineInfo.getState() == 1).findAny().ifPresent(atomicReference::set);
            }
            if (atomicReference.get() == null) {
                clientConnector.getLines().stream().filter(lineInfo -> lineInfo.getState() != 0 && lineInfo.getState() != 18 && lineInfo.getState() != 8).findAny().ifPresent(atomicReference::set);
            }
        });
        return (LineInfo)atomicReference.get();
    }

    public static LineInfo getIncomingCallLine() {
        AtomicReference atomicReference = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.getLines().stream().filter(lineInfo -> lineInfo.getState() == 2).findAny().ifPresent(atomicReference::set));
        return (LineInfo)atomicReference.get();
    }

    public static void joinToConference(LineInfo lineInfo) {
        MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ClientSingleton.getInstance().setConferenceOwner(true);
            LineInfo lineInfo2 = AudioCaller.getConnectedLine(lineInfo);
            if (lineInfo2 == null) {
                lineInfo2 = AudioCaller.getFirstActiveLine(lineInfo);
                if (lineInfo2.getState() == 4) {
                    clientConnector.setActiveLine(lineInfo2);
                    LineInfo li = lineInfo2;
                    TimerExecutor.getInstance().setMyAction(() -> clientConnector.joinToConference(li)).startWithDelay(250L);
                } else {
                    clientConnector.joinToConference(lineInfo);
                }
            } else {
                clientConnector.joinToConference(lineInfo);
            }
        }));
    }

    public static void transferCallTo(LineInfo lineInfo) {
        MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (AudioCaller.getWorkingLinesCount() == 2) {
                LineInfo lineInfo2 = AudioCaller.getFirstActiveLine(lineInfo);
                if (lineInfo2.getState() == 4 && lineInfo.getState() == 4) {
                    clientConnector.setActiveLine(lineInfo2);
                    TimerExecutor.getInstance().setMyAction(() -> clientConnector.transferCall(lineInfo.getState() != 4 ? lineInfo : lineInfo2, lineInfo.getState() == 4 ? lineInfo : lineInfo2)).startWithDelay(250L);
                } else {
                    clientConnector.transferCall(lineInfo.getState() != 4 ? lineInfo : lineInfo2, lineInfo.getState() == 4 ? lineInfo : lineInfo2);
                }
            } else {
                LineInfo lineInfo2 = AudioCaller.getConnectedLine(lineInfo);
                if (lineInfo2 != null) {
                    clientConnector.transferCall(lineInfo.getState() != 4 ? lineInfo : lineInfo2, lineInfo.getState() == 4 ? lineInfo : lineInfo2);
                }
            }
        }));
    }

    public static LineInfo getFirstActiveLine(LineInfo curLineInfo) {
        AtomicReference atomicReference = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            for (LineInfo lineInfo : clientConnector.getLines()) {
                if (curLineInfo.getName().equals(lineInfo.getName()) || lineInfo.getState() == 0 || lineInfo.getState() == 18 || lineInfo.getState() == 8) continue;
                atomicReference.set(lineInfo);
                break;
            }
        });
        return (LineInfo)atomicReference.get();
    }

    public static LineInfo getConnectedLine(LineInfo curLineInfo) {
        AtomicReference atomicReference = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            for (LineInfo lineInfo : clientConnector.getLines()) {
                if (curLineInfo.hashCode() == lineInfo.hashCode() || lineInfo.getState() != 3) continue;
                atomicReference.set(lineInfo);
                break;
            }
        });
        return (LineInfo)atomicReference.get();
    }

    public static boolean hasConnectedOrConferenceLine() {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> atomicBoolean.set(clientConnector.getLines().stream().anyMatch(lineInfo -> lineInfo.getState() == 3 || lineInfo.getState() == 10 || lineInfo.getState() == 5)));
        return atomicBoolean.get();
    }

    public static LineInfo getLineOnHold(LineInfo curLineInfo) {
        AtomicReference atomicReference = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            for (LineInfo lineInfo : clientConnector.getLines()) {
                if (curLineInfo.getName().equals(lineInfo.getName()) || lineInfo.getState() != 4) continue;
                atomicReference.set(lineInfo);
                break;
            }
        });
        return (LineInfo)atomicReference.get();
    }

    public static int getWorkingLinesCount() {
        AtomicInteger count = new AtomicInteger(0);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            for (LineInfo lineInfo : clientConnector.getLines()) {
                if (lineInfo.getState() == 0 || lineInfo.getState() == 18 || lineInfo.getState() == 8) continue;
                count.incrementAndGet();
            }
        });
        return count.get();
    }

    public static List<String> getPBXTrunks(List<String> numbers) {
        AtomicReference atomicReference = new AtomicReference(new ArrayList());
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ArrayList trunks = new ArrayList();
            for (String number : numbers) {
                List trs = clientConnector.getTrunks(number);
                if (trs == null || trs.isEmpty()) continue;
                trunks.addAll(trs);
            }
            atomicReference.set(trunks);
        });
        return atomicReference.get();
    }

    public static void addTrunkLabel(LineInfo lineInfo, Label label, Pane parent) {
        if (lineInfo == null) {
            parent.getChildren().remove((Object)label);
            return;
        }
        String trunk = AudioCaller.getTrunkLabel(lineInfo);
        if (!trunk.isEmpty()) {
            if (label != null) {
                label.setText(trunk);
                if (!parent.getChildren().contains((Object)label)) {
                    parent.getChildren().add((Object)label);
                }
            }
        } else {
            parent.getChildren().remove((Object)label);
        }
    }

    public static String getTrunkLabel(LineInfo lineInfo) {
        if (lineInfo == null || lineInfo.getCalledName() == null) {
            return "";
        }
        Object trunk = ClientSingleton.getInstance().getClientConnector().get().getTrunkName(lineInfo.getCalledName(), true);
        ClientSingleton.toLog(TAG, "getTrunkLabel getCalledName = " + lineInfo.getCalledName() + " trunk=" + (String)trunk);
        trunk = trunk != null && !((String)trunk).isEmpty() && !((String)trunk).equals(lineInfo.getPartyName()) ? (!lineInfo.isInbound() ? ClientSingleton.getInstance().getString("call_from_with_trunk") + " " + (String)trunk : ClientSingleton.getInstance().getString("call_to_with_trunk") + " " + (String)trunk) : "";
        return trunk;
    }
}

