/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils;

import java.awt.Font;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.StyledWord;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.MyAlert;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.FileInfo;

public class MyUtils {
    private static final HashMap<String, Image> imageCacheMap = new HashMap();
    private static final String pathToSVG = "/svg/";

    public static String getDateHString(long time) {
        SimpleDateFormat S1FMT = new SimpleDateFormat("dd.MM HH:mm");
        String date = S1FMT.format(time);
        return date;
    }

    public static void showAlert(String message) {
        MyUtils.showAlert(message, Alert.AlertType.ERROR);
    }

    public static void showAlert(String message, Alert.AlertType alertType) {
        ClientSingleton.getInstance().runLater(() -> {
            Alert alert = new Alert(alertType, message, new ButtonType[]{ButtonType.YES});
            alert.setResizable(true);
            alert.setTitle(ClientSingleton.getInstance().getPackageName());
            alert.showAndWait();
            if (alert.getResult() == ButtonType.YES || alert.getResult() == ButtonType.CLOSE) {
                // empty if block
            }
        });
    }

    public static void showBrowserAlert() {
        TimerExecutor.getInstance().startInGUI(() -> {
            MyAlert myMessageAlert = new MyAlert();
            myMessageAlert.setMessage(ClientSingleton.getInstance().getString("initialising_browser")).addPositiveButton("OK", (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> myMessageAlert.hide())).setAlwaysOnTop(true).buildDialogAndShow();
        });
    }

    public static ButtonType showOptionsAlert(String message) {
        ButtonType buttonTypeOpen = new ButtonType(ClientSingleton.getInstance().getResourceBundle().getString("button_open"), ButtonBar.ButtonData.YES);
        ButtonType buttonTypeSave = new ButtonType(ClientSingleton.getInstance().getResourceBundle().getString("button_save"), ButtonBar.ButtonData.NO);
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, message, new ButtonType[]{buttonTypeOpen, buttonTypeSave});
        alert.setResizable(true);
        alert.setTitle(ClientSingleton.getInstance().getPackageName());
        alert.showAndWait();
        if (alert.getResult() == ButtonType.YES || alert.getResult() == ButtonType.NO) {
            return (ButtonType)alert.getResult();
        }
        return null;
    }

    public static String getResourceUrl(Class loaderClass, String resourceName) {
        URL resourceUrl = loaderClass.getResource(resourceName);
        if (resourceUrl == null) {
            throw new NullPointerException("Can't find resource " + resourceName + " in package " + loaderClass.getPackage().toString());
        }
        return resourceUrl.toExternalForm();
    }

    public static void bind(TextFlow textFlow, String text, String searchText, boolean isHovered) {
        if (searchText.trim().length() < 3 || !text.toLowerCase().contains(searchText.toLowerCase())) {
            MyUtils.setTextFont(textFlow, text, isHovered);
        } else {
            textFlow.getChildren().clear();
            List tokenizer = MyUtils.getIndexes(text, searchText);
            for (String str : tokenizer) {
                Text title = new Text(str);
                textFlow.getChildren().addAll((Object[])new Node[]{title});
            }
            textFlow.getChildrenUnmodifiable().forEach(n -> {
                Text textText = (Text)n;
                if (textText.getText().toLowerCase().contains(searchText.toLowerCase())) {
                    textText.setFill((Paint)Color.rgb((int)102, (int)0, (int)51));
                } else {
                    MyUtils.setStyledTextFont(textText, isHovered);
                }
            });
        }
    }

    private static void setTextFont(TextFlow textFlow, String text, boolean isHovered) {
        ClientSingleton.getInstance().runLater(() -> {
            Text templateText = new Text(text);
            templateText.setTextAlignment(TextAlignment.LEFT);
            MyUtils.setStyledTextFont(templateText, isHovered);
            textFlow.getChildren().clear();
            textFlow.getChildren().addAll((Object[])new Node[]{templateText});
        });
    }

    public static void setStyledTextFont(Text text, boolean isHoovered) {
        boolean isLink;
        Font currentFont = ClientSingleton.getInstance().getCurrentFont();
        FontWeight weight = currentFont.isBold() ? FontWeight.BOLD : FontWeight.NORMAL;
        FontPosture posture = currentFont.isItalic() ? FontPosture.ITALIC : FontPosture.REGULAR;
        int size = currentFont.getSize();
        String family = currentFont.getFamily();
        javafx.scene.text.Font font = javafx.scene.text.Font.font((String)family, (FontWeight)weight, (FontPosture)posture, (double)size);
        boolean bl = isLink = text.getText().contains("http:") || text.getText().contains("https:");
        text.setFill((Paint)(isHoovered ? new Color(1.0, 1.0, 1.0, 1.0) : (!isLink ? new Color(0.4, 0.4, 0.4, 1.0) : Color.rgb((int)51, (int)51, (int)255))));
        text.setUnderline(isLink);
        text.setFont(font);
    }

    public static List getIndexes(String text, String search) {
        int index = 0;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<String> strs = new ArrayList<String>();
        while ((index = text.toLowerCase().indexOf(search.toLowerCase(), index)) >= 0) {
            indexes.add(index);
            indexes.add(index + search.length());
            ++index;
        }
        if (!indexes.isEmpty() && (Integer)indexes.get(0) != 0) {
            indexes.add(0, 0);
        } else if (indexes.isEmpty()) {
            strs.add(text);
            return strs;
        }
        for (int i = 0; i < indexes.size(); ++i) {
            int start = (Integer)indexes.get(i);
            int end = -1;
            end = i + 1 == indexes.size() ? text.length() - 1 : (Integer)indexes.get(i + 1);
            try {
                strs.add(text.substring(start, end));
                continue;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return strs;
    }

    public static List<String> bindLink(String mContent) {
        ArrayList<String> containedUrls = new ArrayList<String>();
        String urlRegex = "((https?|ftp|gopher|telnet|file):((//)|(\\\\))+[\\w\\d:#@%/;$~_?\\+-=\\\\\\.&]*)";
        Pattern pattern = Pattern.compile(urlRegex, 2);
        Matcher urlMatcher = pattern.matcher(mContent);
        while (urlMatcher.find()) {
            containedUrls.add(mContent.substring(urlMatcher.start(0), urlMatcher.end(0)));
        }
        return containedUrls;
    }

    public static ArrayList<StyledWord> getLinks(String mContent) {
        String content = mContent;
        ArrayList<StyledWord> urls = new ArrayList<StyledWord>();
        ArrayList<String> linked = new ArrayList<String>();
        if (mContent.contains("http:") || mContent.contains("https:") || mContent.contains("www.")) {
            int index2;
            do {
                String url;
                int i;
                String mess;
                int index1;
                if ((index1 = mContent.indexOf("http:")) == -1) {
                    index1 = mContent.indexOf("https:");
                }
                if (index1 == -1) {
                    index1 = mContent.indexOf("www.");
                }
                if ((index2 = mContent.indexOf("\n", index1)) == -1) {
                    index2 = mContent.indexOf(" ", index1);
                }
                if (index2 == -1) {
                    index2 = mContent.length();
                }
                if (!(mess = mContent.substring(0, index1)).isEmpty()) {
                    linked.add(mess);
                }
                if ((i = (url = mContent.substring(index1, index2)).indexOf(" ")) != -1) {
                    url = url.substring(0, i);
                    if (i > index1 && !(mess = mContent.substring(1, index2)).isEmpty()) {
                        linked.add(mess);
                    }
                } else {
                    while (!Character.isDigit(url.charAt(url.length() - 1)) && !Character.isLetter(url.charAt(url.length() - 1))) {
                        url = url.substring(0, url.length() - 1);
                    }
                }
                linked.add(url);
            } while ((mContent = mContent.substring(index2)).contains("http:") || mContent.contains("https:") || mContent.contains("www."));
            if (mContent.length() > 0) {
                linked.add(mContent);
            }
        }
        linked.forEach(link -> {
            boolean isLink = MessageInfoCellLabels.isLink(link);
            if (isLink) {
                urls.add(new StyledWord(content.indexOf((String)link), content.indexOf((String)link) + link.length(), (String)link));
            }
        });
        return urls;
    }

    public static boolean setOriginalFileName(FileInfo fileInfo) {
        int index;
        if (!fileInfo.isImage()) {
            return false;
        }
        String fileName = fileInfo.getFileName();
        if (fileName != null && fileName.toLowerCase().endsWith(".jpg") && (index = fileName.toLowerCase().indexOf(".jpg")) != -1) {
            fileName = fileName.toLowerCase().substring(0, index);
            boolean isImage = false;
            String[] suffixes = FileInfo.IMAGE;
            for (int i = 0; i < suffixes.length; ++i) {
                if (!fileName.endsWith("." + suffixes[i])) continue;
                isImage = true;
                break;
            }
            if (isImage) {
                fileInfo.setContent(fileName, fileInfo.getType());
                ClientSingleton.toLog("setOriginalFileName", "file name = " + fileInfo.getContent());
                return true;
            }
        }
        return false;
    }
}

