/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.audiocontrols;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import net.sipsnet.client.connector.ClientSingleton;

public class AudioLineControls {
    private static final String TAG = "AudioLineControls";
    private static final List<Mixer> muteControlMixers = new ArrayList<Mixer>();
    private static final List<Mixer> volumeControlMixers = new ArrayList<Mixer>();
    private static final List<Line> muteControlLines = new ArrayList<Line>();
    private static final List<Line> volumeControlLines = new ArrayList<Line>();

    public static void setAudioLineListeners() {
        try {
            BooleanControl booleanControl;
            Port line;
            Mixer mixer = AudioSystem.getMixer(null);
            ClientSingleton.toLog(TAG, "AudioSystem  HEADPHONE" + AudioSystem.isLineSupported(Port.Info.HEADPHONE) + " SPEAKER=" + AudioSystem.isLineSupported(Port.Info.SPEAKER) + " LINE_OUT=" + AudioSystem.isLineSupported(Port.Info.LINE_OUT));
            if (mixer.isLineSupported(Port.Info.LINE_IN)) {
                line = (Port)mixer.getLine(Port.Info.LINE_IN);
                line.open();
                FloatControl volCtrl = (FloatControl)line.getControl(FloatControl.Type.VOLUME);
                line.close();
            } else if (mixer.isLineSupported(Port.Info.LINE_OUT)) {
                // empty if block
            }
            if (AudioSystem.isLineSupported(Port.Info.HEADPHONE)) {
                line = (Port)AudioSystem.getLine(Port.Info.HEADPHONE);
                if (!line.isOpen()) {
                    line.open();
                }
                ClientSingleton.toLog(TAG, "HEADPHONE (FloatControl) " + line.getControl(FloatControl.Type.VOLUME));
                booleanControl = (BooleanControl)line.getControl(BooleanControl.Type.MUTE);
                ClientSingleton.toLog(TAG, "(BooleanControl) 1 = " + booleanControl);
                booleanControl.setValue(false);
                ClientSingleton.toLog(TAG, "(BooleanControl) 2 = " + booleanControl);
                if (line.isOpen()) {
                    line.close();
                }
            }
            if (AudioSystem.isLineSupported(Port.Info.SPEAKER)) {
                line = (Port)AudioSystem.getLine(Port.Info.SPEAKER);
                if (!line.isOpen()) {
                    line.open();
                }
                ClientSingleton.toLog(TAG, "SPEAKER (FloatControl) " + line.getControl(FloatControl.Type.VOLUME));
                booleanControl = (BooleanControl)line.getControl(BooleanControl.Type.MUTE);
                ClientSingleton.toLog(TAG, "(BooleanControl) 1 = " + booleanControl);
                booleanControl.setValue(false);
                ClientSingleton.toLog(TAG, "(BooleanControl) 2 = " + booleanControl);
                if (line.isOpen()) {
                    line.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed trying to find LINE_IN VOLUME control: exception = " + e);
        }
    }

    public static void setMute(boolean isMute) {
    }

    private static float limit(FloatControl control, float level) {
        return Math.min(control.getMaximum(), Math.max(control.getMinimum(), level));
    }
}

