/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.audioplayer;

import com.smile.sound.WavAudioFormat;
import com.smile.sound.WaveParser;
import com.smile.sound.audioFormat;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.audioplayer.IAudioPlayer;
import net.sipsnet.client.utils.viewers.slider.MySlider;
import smile.cti.phone.PhoneDevice;

public class AudioPlayer {
    private PhoneDevice device;
    private File file;
    private InputStream stream;
    private boolean playing;
    private long playtime;
    private final MySlider fx_Slider;
    private final IAudioPlayer iAudioPlayer;

    public AudioPlayer(MySlider fx_Slider, IAudioPlayer iAudioPlayer) {
        this.fx_Slider = fx_Slider;
        this.iAudioPlayer = iAudioPlayer;
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            this.device = clientConnector.getPhoneDevice();
        });
    }

    public void setSliderMaxDuration(long maxDuration) {
        this.fx_Slider.setMax(maxDuration / 1000L);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isHasFile() {
        return this.file != null;
    }

    public void startPlayback() {
        if (this.playing) {
            this.stopPlayback();
        }
        try {
            this.stream = this.getAudioStream(new FileInputStream(this.file));
            long skip = (long)this.fx_Slider.getValue() * 16000L;
            if (skip > 0L) {
                this.stream.skip(skip);
            }
            this.iAudioPlayer.onStartPlayback();
            this.device.startPlayback(this.stream, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.playing = true;
        Thread thread = new Thread(){

            @Override
            public void run() {
                AudioPlayer.this.progress();
            }
        };
        thread.start();
    }

    private synchronized void progress() {
        double seconds = this.fx_Slider.getValue();
        while (this.playing) {
            this.setTimeValue(seconds);
            double d = seconds;
            seconds = d + 1.0;
            if (d > this.fx_Slider.getMax()) {
                this.stopPlayback();
                this.setTotalTime();
                break;
            }
            try {
                this.wait(1000L);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void stopPlayback() {
        this.playing = false;
        this.device.stopPlayback(null);
        this.iAudioPlayer.onStopPlayback();
        try {
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notify();
    }

    public InputStream getAudioStream(InputStream is) throws Exception {
        wavFormatHeader hdr = new wavFormatHeader();
        InputStream voicedata = new WaveParser().parseWavHeader(is, hdr);
        WavAudioFormat codec = hdr.getAudioFormat();
        if (codec.equals((audioFormat)WavAudioFormat.PCM_LINEAR16)) {
            return voicedata;
        }
        WavAudioFormat[] wav_formats = new WavAudioFormat[]{WavAudioFormat.PCM_LINEAR16};
        AudioConverter acv = new AudioConverter();
        return acv.getInputStream(voicedata, codec, wav_formats);
    }

    private void setTimeValue(double seconds) {
        this.fx_Slider.setValue(seconds);
        this.iAudioPlayer.setTimeValue((int)seconds * 1000);
    }

    private void setTotalTime() {
        this.fx_Slider.setValue(0.0);
        this.iAudioPlayer.onEndPlayback();
        this.iAudioPlayer.setTimeValue(this.playtime);
    }
}

