/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.audioplayer;

import java.io.File;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.audioplayer.IAudioPlayer;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.slider.MySlider;
import smile.cti.client.ClientConnector;

public class MyMediaPlayer {
    private final MySlider fx_Slider;
    private final Label fx_lbTotalPlayingTime;
    private final IAudioPlayer iAudioPlayer;
    private Media media;
    private MediaPlayer mediaPlayer;
    private boolean isMousePressed = false;
    private boolean isSliderJumped = false;
    private final ChangeListener<MediaPlayer.Status> statusChangeListener = new ChangeListener<MediaPlayer.Status>(){

        public void changed(ObservableValue<? extends MediaPlayer.Status> observable, MediaPlayer.Status oldValue, MediaPlayer.Status newValue) {
            if (MyMediaPlayer.this.mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING) {
                Thread thread = new Thread(() -> MyMediaPlayer.this.progress());
                thread.start();
            }
        }
    };

    public MyMediaPlayer(final MySlider fx_Slider, Label fx_lbTotalPlayingTime, final IAudioPlayer iAudioPlayer) {
        this.fx_Slider = fx_Slider;
        this.fx_Slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (MyMediaPlayer.this.isMousePressed) {
                    return;
                }
                if (MyMediaPlayer.this.mediaPlayer != null && MyMediaPlayer.this.mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING) {
                    if (newValue.intValue() == 0 || newValue.intValue() == (int)fx_Slider.getMax()) {
                        TimerExecutor.getInstance().setMyAction(() -> {
                            MyMediaPlayer.this.stopPlayback();
                            MyMediaPlayer.this.setTotalTime();
                        }).startWithDelay(500L);
                    } else if (Math.abs(newValue.intValue() - oldValue.intValue()) > 3) {
                        MyMediaPlayer.this.isSliderJumped = true;
                        iAudioPlayer.setTimeValue((long)newValue.intValue() * 1000L);
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "---------------------------setTimeValue valueProperty newValue : " + newValue);
                        MyMediaPlayer.this.pausePlayback();
                        TimerExecutor.getInstance().setMyAction(() -> {
                            MyMediaPlayer.this.mediaPlayer.seek(Duration.seconds((double)newValue.intValue()));
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            iAudioPlayer.onStartPlayback();
                            MyMediaPlayer.this.mediaPlayer.play();
                            MyMediaPlayer.this.isSliderJumped = false;
                        }).startWithDelay(700L);
                    }
                } else if (Math.abs(newValue.intValue() - oldValue.intValue()) > 3) {
                    iAudioPlayer.setTimeValue((long)newValue.intValue() * 1000L);
                }
            }
        });
        this.fx_Slider.setOnMouseReleased(e -> {
            if (!this.isMousePressed) {
                return;
            }
            if (this.mediaPlayer != null) {
                if (fx_Slider.getValue() < fx_Slider.getMax()) {
                    TimerExecutor.getInstance().setMyAction(() -> {
                        this.mediaPlayer.seek(Duration.seconds((double)fx_Slider.getValue()));
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "move to value fx_Slider.getValue() = " + fx_Slider.getValue() + " sec max = " + fx_Slider.getMax() + " sec");
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        iAudioPlayer.onStartPlayback();
                        this.mediaPlayer.play();
                        this.isMousePressed = false;
                    }).startWithDelay(700L);
                } else {
                    this.stopPlayback();
                    this.setTotalTime();
                }
            }
        });
        this.fx_Slider.setOnMousePressed(e -> {
            if (this.mediaPlayer != null && !this.isSliderJumped) {
                this.isMousePressed = true;
                this.pausePlayback();
            }
        });
        this.fx_Slider.setOnMouseDragged(e -> {
            if ((this.isMousePressed || this.mediaPlayer == null || this.mediaPlayer.getStatus() != MediaPlayer.Status.PLAYING) && fx_Slider.getValue() < fx_Slider.getMax()) {
                iAudioPlayer.setTimeValue((long)((int)fx_Slider.getValue()) * 1000L);
            }
        });
        this.iAudioPlayer = iAudioPlayer;
        this.fx_lbTotalPlayingTime = fx_lbTotalPlayingTime;
    }

    public void setFile(File audiofile) {
        if (audiofile == null) {
            return;
        }
        if (this.mediaPlayer != null) {
            this.dispose();
            this.mediaPlayer = null;
        }
        this.media = new Media(audiofile.toURI().toString());
        this.media.durationProperty().addListener((ChangeListener)new ChangeListener<Duration>(){

            public void changed(ObservableValue<? extends Duration> observable, Duration oldValue, Duration newValue) {
                MyMediaPlayer.this.fx_Slider.setMax(newValue.toMillis() / 1000.0);
                ClientSingleton.toLog(MyMediaPlayer.this.getClass().getSimpleName(), "durationProperty=" + newValue + " " + newValue.toMillis() + " sec= " + newValue.toSeconds() + " fx_Slider.getMax()=" + MyMediaPlayer.this.fx_Slider.getMax() + " " + newValue.toMillis() / 1000.0);
                MyMediaPlayer.this.fx_lbTotalPlayingTime.setText(ClientSingleton.getInstance().getTimeDuration((long)newValue.toMillis()));
                MyMediaPlayer.this.media.durationProperty().removeListener((ChangeListener)this);
            }
        });
        try {
            this.mediaPlayer = new MediaPlayer(this.media);
            this.mediaPlayer.statusProperty().addListener(this.statusChangeListener);
            Optional<ClientConnector> clientConnector = ClientSingleton.getInstance().getClientConnector();
            if (clientConnector.isPresent()) {
                Number playbackLevel = (Number)clientConnector.get().getProperty("Playback level");
                if (playbackLevel == null) {
                    playbackLevel = Float.valueOf(clientConnector.get().getPhoneDevice().getPlaybackLevel());
                }
                this.mediaPlayer.setVolume(playbackLevel.doubleValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isPlaying() {
        return this.mediaPlayer != null && this.mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING;
    }

    public void startPlayback() {
        if (this.mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING) {
            this.mediaPlayer.pause();
        }
        try {
            Optional<ClientConnector> clientConnector = ClientSingleton.getInstance().getClientConnector();
            if (clientConnector.isPresent()) {
                Number playbackLevel = (Number)clientConnector.get().getProperty("Playback level");
                if (playbackLevel == null) {
                    playbackLevel = Float.valueOf(clientConnector.get().getPhoneDevice().getPlaybackLevel());
                }
                this.mediaPlayer.setVolume(playbackLevel.doubleValue());
            }
            if (this.fx_Slider.getValue() != 0.0) {
                this.mediaPlayer.play();
                this.mediaPlayer.setOnPlaying(() -> {
                    this.mediaPlayer.pause();
                    this.mediaPlayer.setOnPlaying(null);
                    this.mediaPlayer.seek(Duration.seconds((double)this.fx_Slider.getValue()));
                    this.iAudioPlayer.onStartPlayback();
                    TimerExecutor.getInstance().start(() -> this.mediaPlayer.play());
                });
            } else {
                this.iAudioPlayer.onStartPlayback();
                TimerExecutor.getInstance().start(() -> this.mediaPlayer.play());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void progress() {
        double seconds = this.fx_Slider.getValue();
        try {
            while (this.mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING && !this.isSliderJumped) {
                this.setTimeValue(seconds);
                double d = seconds;
                seconds = d + 1.0;
                if (d > this.fx_Slider.getMax()) {
                    this.stopPlayback();
                    this.setTotalTime();
                    break;
                }
                this.wait(1000L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "---------------------------setTimeValue progress interrupted");
    }

    public synchronized void stopPlayback() {
        this.mediaPlayer.stop();
        this.iAudioPlayer.onStopPlayback();
        this.notify();
    }

    public synchronized void pausePlayback() {
        this.mediaPlayer.pause();
        this.iAudioPlayer.onStopPlayback();
        this.notify();
    }

    private void setTimeValue(double seconds) {
        this.fx_Slider.setValue(seconds);
        this.iAudioPlayer.setTimeValue((long)((int)seconds) * 1000L);
    }

    private void setTotalTime() {
        this.fx_Slider.setValue(0.0);
        this.iAudioPlayer.onEndPlayback();
        this.iAudioPlayer.setTimeValue(0L);
    }

    public void dispose() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.statusProperty().removeListener(this.statusChangeListener);
            this.mediaPlayer.dispose();
        }
    }

    public boolean isMediaPlayerCreated() {
        return this.mediaPlayer != null;
    }

    public void setSliderMaxValue(Duration newValue) {
        if (this.fx_Slider != null) {
            this.fx_Slider.setMax(newValue.toSeconds());
        }
    }
}

