/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.contextmenu;

import java.util.ArrayList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.contextmenu.IMenuActionListener;

public class MyContextMenu {
    private final Stage stage;
    private final String FOCUSED_BACKGROUND = "-fx-background-color: dce0ec;";
    private final String NOT_FOCUSED_BACKGROUND = "-fx-background-color: white;";
    private final String labelStyle = "-fx-text-fill: #656a7c;-fx-font-family: \"Roboto\";-fx-font-size: 12px;-fx-font-weight: bold;-fx-line-height: 1.19;";
    private final VBox rootPane;
    private int maxHeight;
    private final int MAX_MENU_WIDTH = 145;
    private final int MAX_ITEM_HEIGHT = 40;
    private boolean withSelection = false;
    private int selectedIndex = -1;
    private final List<Object> items = new ArrayList<Object>();
    private final String menuDownStyle = "-fx-background-color: white;-fx-border-radius: 0 8 8 8;-fx-background-radius: 0 8 8 8;-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.23), 4, 0, 0, 0);";
    private final String menuUpStyle = "-fx-background-color: white;-fx-border-radius: 8 8 8 0;-fx-background-radius: 8 8 8 0;-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.23), 4, 0, 0, 0);";
    private IMenuActionListener IMenuActionListener;

    public MyContextMenu() {
        this(false);
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    private MyContextMenu(boolean withSelection) {
        this.withSelection = withSelection;
        this.rootPane = this.getRootPane();
        this.rootPane.setMaxWidth(145.0);
        this.rootPane.setPrefWidth(145.0);
        this.rootPane.setMinHeight(50.0);
        this.stage = new Stage();
        this.stage.initStyle(StageStyle.TRANSPARENT);
        Scene scene = new Scene((Parent)this.rootPane, 0.0, 0.0);
        scene.setFill((Paint)Color.TRANSPARENT);
        this.stage.setScene(scene);
        this.stage.setMinWidth(this.rootPane.minHeight(-1.0));
        this.stage.setMinHeight(this.rootPane.minHeight(-1.0));
        this.stage.initModality(Modality.NONE);
        this.stage.initOwner((Window)ClientSingleton.getInstance().getParentWindow());
        this.stage.widthProperty().addListener((observableValue, oldValue, newValue) -> this.stage.setMaxWidth(145.0));
        this.stage.heightProperty().addListener((observableValue, oldValue, newValue) -> this.stage.setMaxHeight((double)this.maxHeight));
        this.stage.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.hide();
            }
        });
    }

    public static MyContextMenu getInstance() {
        return new MyContextMenu();
    }

    public static MyContextMenu getInstance(boolean withSelection) {
        return new MyContextMenu(withSelection);
    }

    public void addItemsList(List<?> list, IMenuActionListener IMenuActionListener2) {
        for (Object item : list) {
            this.addMenuItem(item, IMenuActionListener2);
        }
        if (!list.isEmpty()) {
            this.setSelectedItem(list.get(0).toString());
            IMenuActionListener2.actionPerformed();
        }
    }

    public void addMenuItem(Object title, EventHandler eventHandler) {
        this.addMenuItem(title, eventHandler, null);
    }

    public void addMenuItem(Object title, IMenuActionListener IMenuActionListener2) {
        this.addMenuItem(title, null, IMenuActionListener2);
    }

    public void addMenuItem(Object title, EventHandler eventHandler, IMenuActionListener IMenuActionListener2) {
        this.IMenuActionListener = IMenuActionListener2;
        HBox hBox = new HBox();
        hBox.setMaxWidth(145.0);
        hBox.setMaxHeight(40.0);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        Label label = new Label(title.toString());
        label.setStyle("-fx-background-color: white;-fx-text-fill: #656a7c;-fx-font-family: \"Roboto\";-fx-font-size: 12px;-fx-font-weight: bold;-fx-line-height: 1.19;");
        label.setPadding(new Insets(0.0, 0.0, 0.0, 16.0));
        label.setPrefHeight(40.0);
        label.setPrefWidth(145.0);
        label.setId(title.toString());
        if (this.isWithSelection()) {
            label.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                Label labelItem = (Label)mouseEvent.getSource();
                this.setSelectedItem(labelItem.getId());
                labelItem.setStyle("-fx-background-color: dce0ec;-fx-text-fill: #656a7c;-fx-font-family: \"Roboto\";-fx-font-size: 12px;-fx-font-weight: bold;-fx-line-height: 1.19;");
                if (IMenuActionListener2 != null) {
                    IMenuActionListener2.actionPerformed();
                }
            });
        } else {
            if (eventHandler != null) {
                label.addEventFilter(MouseEvent.MOUSE_CLICKED, eventHandler);
            }
            label.addEventFilter(MouseEvent.MOUSE_ENTERED, mouseEvent -> {
                if (!this.isWithSelection()) {
                    Label labelItem = (Label)mouseEvent.getSource();
                    labelItem.setStyle("-fx-background-color: dce0ec;-fx-text-fill: #656a7c;-fx-font-family: \"Roboto\";-fx-font-size: 12px;-fx-font-weight: bold;-fx-line-height: 1.19;");
                }
            });
            label.addEventFilter(MouseEvent.MOUSE_EXITED, mouseEvent -> {
                if (!this.isWithSelection()) {
                    Label labelItem = (Label)mouseEvent.getSource();
                    labelItem.setStyle("-fx-background-color: white;-fx-text-fill: #656a7c;-fx-font-family: \"Roboto\";-fx-font-size: 12px;-fx-font-weight: bold;-fx-line-height: 1.19;");
                }
            });
        }
        ClientSingleton.getInstance().setMouseCursor((Node)label);
        hBox.getChildren().add((Object)label);
        this.rootPane.getChildren().add((Object)hBox);
        this.maxHeight = this.rootPane.getChildren().size() * 40 + 20;
        this.rootPane.setMaxHeight((double)this.maxHeight);
        this.items.add(title);
    }

    private boolean isWithSelection() {
        return this.withSelection;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedItem() {
        if (this.selectedIndex >= 0) {
            return this.items.get(this.selectedIndex);
        }
        return "";
    }

    public void setSelectedItem(Object title) {
        for (int i = 0; i < this.rootPane.getChildren().size(); ++i) {
            Node item = (Node)this.rootPane.getChildren().get(i);
            HBox hBox = (HBox)item;
            Label label = (Label)hBox.getChildren().get(0);
            if (label.getId().equals(title.toString())) {
                this.selectedIndex = i;
                label.setStyle("-fx-background-color: dce0ec;-fx-text-fill: #656a7c;-fx-font-family: \"Roboto\";-fx-font-size: 12px;-fx-font-weight: bold;-fx-line-height: 1.19;");
                continue;
            }
            label.setStyle("-fx-background-color: white;-fx-text-fill: #656a7c;-fx-font-family: \"Roboto\";-fx-font-size: 12px;-fx-font-weight: bold;-fx-line-height: 1.19;");
        }
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }

    public MyContextMenu clearItems() {
        this.rootPane.getChildren().clear();
        return this;
    }

    public void show(Node node) {
        Rectangle2D primaryScreenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        double width = primaryScreenBounds.getWidth() - primaryScreenBounds.getMinX();
        double height = primaryScreenBounds.getHeight() - primaryScreenBounds.getMinY();
        Bounds boundsInScreen = node.localToScreen(node.getBoundsInLocal());
        double y = boundsInScreen.getMinY() + boundsInScreen.getHeight();
        if (boundsInScreen.getMinY() + boundsInScreen.getHeight() + (double)this.maxHeight > height) {
            y = boundsInScreen.getMinY() - (double)this.maxHeight;
            this.rootPane.setStyle(this.menuUpStyle);
        } else {
            this.rootPane.setStyle(this.menuDownStyle);
        }
        this.stage.setX(boundsInScreen.getMinX());
        this.stage.setY(y);
        this.stage.show();
    }

    public void hide() {
        this.stage.hide();
        if (this.IMenuActionListener != null) {
            this.IMenuActionListener.dropDownHided();
        }
    }

    private VBox getRootPane() {
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(20.0, 5.0, 20.0, 4.0));
        vBox.setStyle("-fx-background-color: white;-fx-border-radius: 0 8 8 8;-fx-background-radius: 0 8 8 8;-fx-effect: dropshadow(three-pass-box, #f1f2f5, 4, 0, 0, 0);");
        vBox.setSpacing(2.0);
        return vBox;
    }
}

