/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.dnd.FileDnDListener;

public class FileDragNDrop {
    private Boolean supportsDnD;
    private DropTargetListener dropListener;
    private static final String ZERO_CHAR_STRING = "\u0000";

    public FileDragNDrop(Component c, boolean recursive, final FileDnDListener listener) {
        if (this.isSupportsDnD()) {
            this.dropListener = new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent evt) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "dragEnter");
                    if (FileDragNDrop.this.isDragOk(evt)) {
                        evt.acceptDrag(1);
                    } else {
                        evt.rejectDrag();
                    }
                }

                @Override
                public void dragOver(DropTargetDragEvent evt) {
                }

                @Override
                public void drop(DropTargetDropEvent evt) {
                    try {
                        Transferable tr = evt.getTransferable();
                        if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            evt.acceptDrop(1);
                            List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                            File[] filesTemp = new File[fileList.size()];
                            fileList.toArray(filesTemp);
                            if (listener != null) {
                                listener.filesDropped(filesTemp);
                            }
                            evt.getDropTargetContext().dropComplete(true);
                        } else {
                            DataFlavor[] flavors = tr.getTransferDataFlavors();
                            boolean handled = false;
                            for (int i = 0; i < flavors.length; ++i) {
                                if (!flavors[i].isRepresentationClassReader()) continue;
                                evt.acceptDrop(1);
                                Reader reader = flavors[i].getReaderForText(tr);
                                BufferedReader br = new BufferedReader(reader);
                                if (listener != null) {
                                    listener.filesDropped(FileDragNDrop.createFileArray(br));
                                }
                                evt.getDropTargetContext().dropComplete(true);
                                handled = true;
                                break;
                            }
                            if (!handled) {
                                evt.rejectDrop();
                            }
                        }
                    }
                    catch (IOException io) {
                        evt.rejectDrop();
                    }
                    catch (UnsupportedFlavorException ufe) {
                        ufe.printStackTrace();
                        evt.rejectDrop();
                    }
                }

                @Override
                public void dragExit(DropTargetEvent evt) {
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent evt) {
                    if (FileDragNDrop.this.isDragOk(evt)) {
                        evt.acceptDrag(1);
                    } else {
                        evt.rejectDrag();
                    }
                }
            };
            this.makeDropTarget(c, recursive);
        }
    }

    private boolean isSupportsDnD() {
        if (this.supportsDnD == null) {
            boolean support = false;
            try {
                Class<?> arbitraryDndClass = Class.forName("java.awt.dnd.DnDConstants");
                support = true;
            }
            catch (Exception e) {
                support = false;
            }
            this.supportsDnD = new Boolean(support);
        }
        return true;
    }

    private boolean isDragOk(DropTargetDragEvent evt) {
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        for (int i = 0; !ok && i < flavors.length; ++i) {
            DataFlavor curFlavor = flavors[i];
            if (!curFlavor.equals(DataFlavor.javaFileListFlavor) && !curFlavor.isRepresentationClassReader()) continue;
            ok = true;
        }
        return ok;
    }

    private static File[] createFileArray(BufferedReader bReader) {
        try {
            ArrayList<File> list = new ArrayList<File>();
            String line = null;
            while ((line = bReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(line)) continue;
                    File file = new File(new URI(line));
                    list.add(file);
                }
                catch (Exception exception) {}
            }
            return list.toArray(new File[list.size()]);
        }
        catch (IOException iOException) {
            return new File[0];
        }
    }

    private void makeDropTarget(final Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        c.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                } else {
                    new DropTarget(c, FileDragNDrop.this.dropListener);
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            Component[] comps = cont.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.makeDropTarget(comps[i], recursive);
            }
        }
    }
}

