/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.image;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sipsnet.client.connector.utils.resources.ImageResource;

public class ImageCacheHashMap {
    private final LinkedHashMap<String, ImageResource> map;
    private int size;
    private final int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public ImageCacheHashMap(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, false);
    }

    public final synchronized boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.map.containsKey(key);
    }

    public final synchronized ImageResource get(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        ImageResource result = this.map.get(key);
        if (result != null) {
            ++this.hitCount;
            return result;
        }
        ++this.missCount;
        result = this.create(key);
        if (result != null) {
            ++this.createCount;
            this.size += this.safeSizeOf(key, result);
            this.map.put(key, result);
            this.trimToSize(this.maxSize);
        }
        return result;
    }

    public final synchronized ImageResource put(String key, ImageResource value) {
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        ++this.putCount;
        this.size += this.safeSizeOf(key, value);
        ImageResource previous = this.map.put(key, value);
        if (previous != null) {
            this.size -= this.safeSizeOf(key, previous);
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    private void trimToSize(int maxSize) {
        ImageResource value;
        String key;
        Map.Entry<String, ImageResource> toEvict;
        while (this.size > maxSize && !this.map.isEmpty() && (toEvict = this.map.entrySet().iterator().next()) != null) {
            key = toEvict.getKey();
            value = toEvict.getValue();
            this.map.remove(key);
            this.size -= this.safeSizeOf(key, value);
            ++this.evictionCount;
            this.entryEvicted(key, value);
        }
        if (this.size < 0 && !this.map.isEmpty()) {
            while (!this.map.isEmpty() && (toEvict = this.map.entrySet().iterator().next()) != null) {
                key = toEvict.getKey();
                value = toEvict.getValue();
                this.map.remove(key);
                this.entryEvicted(key, value);
            }
            this.size = 0;
        } else if (this.map.isEmpty() && this.size != 0) {
            this.size = 0;
        }
    }

    public final synchronized ImageResource remove(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        ImageResource previous = (ImageResource)this.map.remove(key);
        if (previous != null) {
            this.size -= this.safeSizeOf(key, previous);
        }
        return previous;
    }

    protected void entryEvicted(String key, ImageResource value) {
    }

    protected ImageResource create(String key) {
        return null;
    }

    private int safeSizeOf(String key, ImageResource value) {
        int result = this.sizeOf(key, value);
        if (result < 0) {
            throw new IllegalStateException("Negative size: " + key + "=" + value);
        }
        return result;
    }

    protected int sizeOf(String key, ImageResource value) {
        return 1;
    }

    public final synchronized void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized int maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    public final synchronized Map snapshot() {
        return new LinkedHashMap<String, ImageResource>(this.map);
    }

    public final synchronized String toString() {
        int accesses = this.hitCount + this.missCount;
        int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, hitPercent);
    }

    public Set<String> getEntryKeys() {
        return this.map.keySet();
    }

    public Collection<ImageResource> getEntryValues() {
        return this.map.values();
    }
}

