/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.imageio.ImageIO;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.resources.ImageResource;
import net.sipsnet.client.connector.utils.resources.JarResources;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.image.ImageCacheHashMap;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.views.chat.holders.viewerholders.imageviewers.ImageViewerUtil;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class ImageUtil
extends ImageViewerUtil {
    public static List<String> loadAvatar = new ArrayList<String>();
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private String IMAGES_PATH = null;
    private final ImageCacheHashMap imageCacheMap;
    private final ImageCacheHashMap imageMessageContentCacheMap;
    private final ImageCacheHashMap imageAvatarCacheMap;

    public ImageUtil() {
        int memClassBytes = 0x5000000;
        int cacheSize = memClassBytes / 8;
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "cacheSize=" + cacheSize);
        this.imageCacheMap = new ImageCacheHashMap(cacheSize){

            @Override
            protected int sizeOf(String key, ImageResource image) {
                return (int)(image.getFitWidth() * image.getFitHeight() / 1024.0);
            }
        };
        this.imageMessageContentCacheMap = new ImageCacheHashMap(cacheSize){

            @Override
            protected int sizeOf(String key, ImageResource image) {
                return (int)(image.getFitWidth() * image.getFitHeight() / 1024.0);
            }
        };
        this.imageAvatarCacheMap = new ImageCacheHashMap(cacheSize){

            @Override
            protected int sizeOf(String key, ImageResource image) {
                return (int)(image.getFitWidth() * image.getFitHeight() / 1024.0);
            }
        };
    }

    public boolean setContentImage(ImageView imageView, String id) {
        if (id != null && this.imageMessageContentCacheMap.containsKey(id)) {
            ImageResource imageResource = this.imageMessageContentCacheMap.get(id);
            imageView.setFitWidth(imageResource.getFitWidth());
            imageView.setFitHeight(imageResource.getFitHeight());
            imageView.setImage(imageResource.getImage());
            return true;
        }
        return false;
    }

    public void putWritableImage(String messageId, Image image) {
    }

    public boolean setAvatar(ImageView imageView, String id, int width, int height) {
        if (id != null && this.imageAvatarCacheMap.containsKey(id)) {
            ImageResource imageResource = this.imageAvatarCacheMap.get(id);
            if (imageView != null) {
                if (width == -1) {
                    imageView.setFitWidth(imageResource.getFitWidth());
                    imageView.setFitHeight(imageResource.getFitHeight());
                } else {
                    imageView.setFitWidth((double)width);
                    imageView.setFitHeight((double)height);
                }
            }
            imageView.setImage(imageResource.getImage());
            return true;
        }
        return false;
    }

    private void putAvatar(String id, ImageResource image) {
        this.imageAvatarCacheMap.put(id, image);
    }

    public void removeAvatar(String id) {
        if (id != null) {
            this.imageAvatarCacheMap.remove(id);
        }
    }

    public synchronized boolean setPreloadAvatar(ImageView imageView, Object objectInfo, int width, boolean withSave) {
        String id;
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        File file = null;
        if (objectInfo instanceof ContactInfo) {
            ContactInfo contactInfo = (ContactInfo)objectInfo;
            file = clientConnector.getAvatar(contactInfo);
            id = ClientSingleton.getInstance().getUserID(contactInfo);
        } else {
            SessionInfo sessionInfo = (SessionInfo)objectInfo;
            file = clientConnector.getAvatar(sessionInfo);
            id = sessionInfo.getSessionId();
            if (file == null) {
                ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
                file = clientConnector.getAvatar(contactInfo);
                id = ClientSingleton.getInstance().getUserID(contactInfo);
            }
        }
        if (file != null && file.exists()) {
            return this.setAvatarImage(imageView, id, file, width, width, withSave);
        }
        return false;
    }

    public synchronized boolean setAvatarImage(ImageView imageView, String id, File file, int width, int height, boolean withSave) {
        if (file == null) {
            return false;
        }
        if (withSave && this.setAvatar(imageView, id, width, height)) {
            return true;
        }
        Image image = null;
        try {
            image = new Image((InputStream)new FileInputStream(file), (double)width, (double)height, true, true);
        }
        catch (Throwable e) {
            return false;
        }
        if (withSave) {
            if (imageView != null) {
                imageView.setImage(image);
                imageView.setFitWidth((double)width);
                imageView.setFitHeight((double)height);
            }
            this.putAvatar(id, new ImageResource(image, width, height));
            return true;
        }
        return false;
    }

    public Optional<Image> getImageFromFile(File pictureImagePath, int width, int height) {
        Image img = null;
        try {
            img = new Image((InputStream)new FileInputStream(pictureImagePath), (double)width, (double)height, true, true);
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        return Optional.of(img);
    }

    public void setCachedImage(ImageButton imageButton, String path) {
        this.setCachedImage(imageButton.getImageViewButton(), path);
    }

    public void setCachedImage(ImageView imageView, String path) {
        if (path == null || path.isEmpty()) {
            return;
        }
        if (this.imageCacheMap.containsKey(path)) {
            ImageResource image = this.imageCacheMap.get(path);
            if (image != null) {
                imageView.setImage(image.getImage());
                imageView.setFitWidth(image.getFitWidth());
                imageView.setFitHeight(image.getFitHeight());
            }
        } else {
            ImageResource image1 = this.setPngImage(imageView, path);
            if (image1 != null) {
                this.imageCacheMap.put(path, image1);
            }
        }
    }

    public ImageResource setPngImage(ImageView imageView, String imgName) {
        ImageResource imageResource;
        String path = (imgName.contains("/emoji/") || imgName.contains("/ext/") ? "" : this.getPath()) + imgName;
        if (imageView == null) {
            imageView = new ImageView();
        }
        if (JarResources.getInstance().hasResourceInJAR(path) && (imageResource = JarResources.getInstance().getResource(path)) != null && imageResource.getImage() != null) {
            imageView.setFitWidth(imageResource.getFitWidth());
            imageView.setFitHeight(imageResource.getFitHeight());
            imageView.setSmooth(true);
            imageView.setPreserveRatio(true);
            imageView.setImage(imageResource.getImage());
            return imageResource;
        }
        Image image = this.getImageFromResources(path);
        imageView.setImage(image);
        return new ImageResource(image);
    }

    public Image getImageFromResourcesFile(String imgName) {
        ImageResource imageResource;
        String path = this.getPath() + imgName;
        Image image = null;
        if (JarResources.getInstance().hasResourceInJAR(path) && (imageResource = JarResources.getInstance().getResource(path)) != null && imageResource.getImage() != null) {
            image = imageResource.getImage();
        }
        if (image != null) {
            return image;
        }
        image = this.getImageFromResources(path);
        return image;
    }

    public ImageResource getImageResourceFromResourcesFile(String imgName) {
        String path = this.getPath() + imgName;
        ImageResource imageResource = null;
        if (JarResources.getInstance().hasResourceInJAR(path)) {
            imageResource = JarResources.getInstance().getResource(path);
        }
        if (imageResource != null) {
            return imageResource;
        }
        Image image1 = this.getImageFromResources(path);
        imageResource = image1 != null ? new ImageResource(image1, image1.getWidth(), image1.getHeight()) : new ImageResource(image1, -1.0, -1.0);
        return imageResource;
    }

    private Image getImageFromResources(String path) {
        try {
            Image image = ClientSingleton.class.getResource("/dark" + path) != null ? new Image(ClientSingleton.class.getResource("/dark" + path).toExternalForm()) : new Image(ClientSingleton.class.getResource(path).toExternalForm());
            return image;
        }
        catch (Exception ex) {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Exception with path=" + path + " " + ex.getMessage());
            Image image1 = this.getImageFromResource("/dark" + path);
            if (image1 == null) {
                image1 = this.getImageFromResource(path);
            }
            return image1;
        }
    }

    private Image getImageFromResource(String path) {
        Image image;
        block8: {
            InputStream file = ClientSingleton.class.getResourceAsStream(path);
            try {
                Image image2;
                image = image2 = new Image(file);
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception io) {
                    ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Exception with path=" + io.getMessage());
                    return null;
                }
            }
            file.close();
        }
        return image;
    }

    public Image getPngScaledImage(String imgName, int size, boolean isEmoji) {
        Image image;
        block8: {
            String path = (isEmoji ? "" : this.getPath()) + imgName;
            InputStream file = ClientSingleton.class.getResourceAsStream(path);
            try {
                Image image2;
                image = image2 = new Image(file, (double)size, (double)size, true, true);
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception io) {
                    ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Error getPngScaledImage path :" + path + " " + io.getMessage());
                    return null;
                }
            }
            file.close();
        }
        return image;
    }

    public Image getEmojiImage(String imgName) {
        try {
            Image image = new Image(ClientSingleton.class.getResource(imgName).toExternalForm());
            return image;
        }
        catch (Exception ex) {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Exception with path=" + imgName + " " + ex.getMessage());
            return null;
        }
    }

    public synchronized String getPath() {
        if (this.IMAGES_PATH == null) {
            try {
                this.IMAGES_PATH = "/png/";
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "IMAGES_PATH :" + this.IMAGES_PATH);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.IMAGES_PATH = "/png/";
            }
        }
        return this.IMAGES_PATH;
    }

    public static boolean hasRetinaDisplay() {
        Object obj = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor");
        if (obj instanceof Float) {
            Float f = (Float)obj;
            int scale = f.intValue();
            return scale == 2;
        }
        return false;
    }

    private boolean isMacRetinaDisplay() {
        GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        AffineTransform transform = gfxConfig.getDefaultTransform();
        return !transform.isIdentity();
    }

    public void setBackgroundInCenter(Pane pane, String backgroundPath) {
        String color = ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR);
        this.setBackgroundInCenter(pane, backgroundPath, Color.web((String)color));
    }

    public void setBackgroundInCenter(Pane pane, String backgroundPath, Color color) {
        ImageResource imageResource = this.getImageResourceFromResourcesFile(backgroundPath);
        if (imageResource != null) {
            Background background = new Background(Collections.singletonList(new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)), Collections.singletonList(new BackgroundImage(imageResource.getImage(), BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(imageResource.getFitWidth(), imageResource.getFitHeight(), false, false, false, false))));
            pane.setBackground(background);
        }
    }

    public void setBackground(Pane pane, String backgroundPath) {
        Optional<Image> optionalImage = ClientSingleton.getInstance().getImageFromResources(backgroundPath);
        if (optionalImage.isPresent()) {
            Background background = new Background(Collections.singletonList(new BackgroundFill((Paint)Color.web((String)ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)), CornerRadii.EMPTY, Insets.EMPTY)), Collections.singletonList(new BackgroundImage(optionalImage.get(), BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT, BackgroundPosition.CENTER, BackgroundSize.DEFAULT)));
            pane.setBackground(background);
        }
    }

    public MyImageView getRoundedImage(Image writableImage) {
        MyImageView myImageView = new MyImageView((int)writableImage.getWidth(), (int)writableImage.getHeight());
        myImageView.setImage(writableImage);
        Rectangle clip = new Rectangle(myImageView.getFitWidth(), myImageView.getFitHeight());
        int ARC_WIDTH = 20;
        clip.setArcWidth((double)ARC_WIDTH);
        int ARC_HEIGHT = 20;
        clip.setArcHeight((double)ARC_HEIGHT);
        myImageView.setClip((Node)clip);
        return myImageView;
    }

    public static BufferedImage getPngBufferedImage(String imgName) {
        BufferedImage img = null;
        String path = (Theme.getInstance().isDarkTheme() ? "/dark" : "") + ClientSingleton.getInstance().getPath() + imgName;
        try (InputStream file = ImageUtil.class.getResourceAsStream(path);){
            img = ImageIO.read(file);
        }
        catch (IOException io) {
            ClientSingleton.toLog(ImageUtil.class.getName(), io.getMessage());
        }
        return img;
    }

    public void removeImage(String messageId) {
        this.imageMessageContentCacheMap.remove(messageId);
    }
}

