/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ScaledImage {
    private BufferedImage image;
    private int width;
    private int height;

    public ScaledImage(File file, int w, int h, int radius, boolean crop) throws Exception {
        this(ImageIO.read(file), w, h, radius, crop);
    }

    public ScaledImage(InputStream stream, int w, int h, int radius, boolean crop) throws Exception {
        this(ImageIO.read(stream), w, h, radius, crop);
    }

    public ScaledImage(BufferedImage image, int w, int h, int radius, boolean c) throws Exception {
        this.width = w;
        this.height = h;
        if (c) {
            this.crop(image, w, h, radius);
        } else {
            this.resize(image, w, h, radius);
        }
    }

    private void resize(BufferedImage src, int w, int h, int radius) {
        int sHeight;
        this.image = new BufferedImage(this.width, this.height, 1);
        int sWidth = src.getWidth();
        double sr = (double)sWidth / (double)(sHeight = src.getHeight());
        if (sr > 1.0) {
            sWidth = (int)((double)this.width * sr);
            sHeight = this.height;
        } else {
            sWidth = this.width;
            sHeight = (int)((double)this.height / sr);
        }
        Image img = src.getScaledInstance(sWidth, sHeight, 4);
        int x = 0;
        int y = 0;
        if (sr > 1.0) {
            this.height = (int)((double)this.width / sr);
            y = (h - this.height) / 2;
        } else if (sr < 1.0) {
            this.width = (int)((double)this.height * sr);
            x = (w - this.width) / 2;
        }
        Graphics2D g = this.image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (radius > 0) {
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.WHITE);
            g.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, radius, radius));
            g.setComposite(AlphaComposite.SrcIn);
        }
        g.drawImage(img, x, y, x + this.width, y + this.height, 0, 0, sWidth, sHeight, null);
        g.dispose();
    }

    private void crop(BufferedImage src, int w, int h, int radius) {
        int sHeight;
        this.image = new BufferedImage(w, h, 1);
        int sWidth = src.getWidth();
        double sr = (double)sWidth / (double)(sHeight = src.getHeight());
        if (sr > 1.0) {
            sWidth = (int)((double)this.width * sr);
            sHeight = this.height;
        } else {
            sWidth = this.width;
            sHeight = (int)((double)this.height / sr);
        }
        Image img = src.getScaledInstance(sWidth, sHeight, 4);
        double ratio = (double)w / (double)h;
        int x = 0;
        int y = 0;
        int d = sWidth - sHeight;
        if (d > 0) {
            x = (int)((double)d / ratio / 2.0);
            sWidth = (int)((double)sHeight * ratio);
        } else {
            y = (int)((double)(-d) / ratio / 2.0);
            sHeight = (int)((double)sWidth * ratio);
        }
        Graphics2D g = this.image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (radius > 0) {
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.WHITE);
            g.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, radius, radius));
            g.setComposite(AlphaComposite.SrcIn);
        }
        g.drawImage(img, 0, 0, w, h, x, y, x + sWidth, y + sHeight, null);
        g.dispose();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getBytes() throws Exception {
        return this.getBytes("jpg");
    }

    public byte[] getBytes(String format) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        MemoryCacheImageOutputStream mos = new MemoryCacheImageOutputStream(bos);
        ImageIO.write((RenderedImage)this.image, format, mos);
        mos.close();
        return bos.toByteArray();
    }
}

