/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.mac_menubar;

import de.jangassen.MenuToolkit;
import de.jangassen.model.AppearanceMode;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import net.sipsnet.client.connector.ClientSingleton;

public class StandardMacApp {
    private static MenuToolkit toolkit;

    public static void createMacMenuBar() throws Exception {
        String APP_NAME = ClientSingleton.getInstance().getPackageName();
        ClientSingleton.toLog("StandardMacApp", "createMacMenuBar APP_NAME=" + APP_NAME + " start");
        toolkit = MenuToolkit.toolkit();
        MenuBar bar = new MenuBar();
        bar.setUseSystemMenuBar(true);
        ImageView ivLogo = StandardMacApp.getLogo();
        Menu appMenu = ivLogo != null ? new Menu(APP_NAME, (Node)ivLogo) : new Menu(APP_NAME);
        appMenu.getItems().addAll((Object[])new MenuItem[]{toolkit.createHideMenuItem(APP_NAME), toolkit.createHideOthersMenuItem(), toolkit.createUnhideAllMenuItem(), new SeparatorMenuItem(), toolkit.createQuitMenuItem(APP_NAME)});
        bar.getMenus().addAll((Object[])new Menu[]{appMenu});
        toolkit.setAppearanceMode(AppearanceMode.AUTO);
        toolkit.setGlobalMenuBar(bar);
        toolkit.setTrayMenu(appMenu);
        ClientSingleton.toLog("StandardMacApp", "createMacMenuBar done");
    }

    public static void hide() throws Exception {
        toolkit.hide();
    }

    private static ImageView getLogo() {
        ImageView imageViewButton = new ImageView();
        Optional<Image> optional = ClientSingleton.getInstance().getImageFromResources("taskbar/logo_tray.png");
        if (optional.isPresent()) {
            imageViewButton.setImage(optional.get());
        } else {
            imageViewButton = null;
        }
        return imageViewButton;
    }
}

