/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.popupstage;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.stage.ResizeHelper;

public class MyPopupWindow {
    private double xOffset;
    private double yOffset;
    private Stage stage;
    private final Pane rootPane;
    private final double screenPadding = ClientUtil.getOS() == ClientUtil.OS.MAC ? 0.0 : 20.0;
    private boolean isUpStyle;
    private final boolean hideWhenLostFocus = false;

    public boolean isUpStyle() {
        return this.isUpStyle;
    }

    public boolean isHideWhenLostFocus() {
        return false;
    }

    public boolean isShowing() {
        if (this.stage == null) {
            return false;
        }
        return this.stage.isShowing();
    }

    private MyPopupWindow(Pane pane, Window owner, boolean isTransparent) {
        this.rootPane = pane;
        this.stage = new Stage();
        this.stage.setTitle("");
        this.stage.initStyle(StageStyle.TRANSPARENT);
        Scene scene = new Scene((Parent)this.rootPane, 0.0, 0.0);
        scene.setFill((Paint)Color.TRANSPARENT);
        this.stage.setScene(scene);
        this.stage.setMinWidth(this.rootPane.minWidth(-1.0));
        this.stage.setMinHeight(this.rootPane.minHeight(-1.0));
        if (owner != null) {
            ClientSingleton.getInstance().initImageAndTitle(this.stage);
            this.stage.initOwner(owner);
        }
        this.stage.initModality(Modality.WINDOW_MODAL);
        this.stage.widthProperty().addListener((observableValue, oldValue, newValue) -> {
            this.stage.setMaxWidth(this.rootPane.getMaxWidth() + 10.0);
            this.stage.setWidth(this.rootPane.getMaxWidth() + 10.0);
        });
        this.stage.heightProperty().addListener((observableValue, oldValue, newValue) -> {
            this.stage.setMinHeight(this.rootPane.getMaxHeight() + 10.0);
            this.stage.setMaxHeight(this.rootPane.getMaxHeight() + 10.0);
            this.stage.setHeight(this.rootPane.getMaxHeight() + 10.0);
        });
        this.stage.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (!newValue.booleanValue() && this.isHideWhenLostFocus()) {
                this.hide();
            }
        });
        if (!isTransparent) {
            Theme.getInstance().applyTo(Constants.POPUP_WINDOWS_BACKGROUND, this.rootPane);
        }
        this.stage.setOnShown(event -> {
            this.rootPane.applyCss();
            this.rootPane.requestFocus();
            this.stage.requestFocus();
        });
    }

    public Stage getStage() {
        return this.stage;
    }

    public MyPopupWindow setApplicationModality() {
        this.stage.initModality(Modality.APPLICATION_MODAL);
        return this;
    }

    public MyPopupWindow setWindowModality() {
        this.stage.initModality(Modality.WINDOW_MODAL);
        return this;
    }

    public MyPopupWindow setNoneModality() {
        this.stage.initModality(Modality.NONE);
        return this;
    }

    public void setStageY(double y) {
        this.stage.setY(y);
    }

    public MyPopupWindow setMaxHeight(double height) {
        this.rootPane.setMaxHeight(height);
        this.stage.setMaxHeight(height + 10.0);
        this.stage.setMinHeight(height + 10.0);
        this.stage.setHeight(height + 10.0);
        return this;
    }

    public MyPopupWindow setMaxWidth(double width) {
        this.stage.setMaxWidth(width + 10.0);
        this.stage.setWidth(width + 10.0);
        return this;
    }

    private void setBackground() {
        String style = "-fx-border-radius: 13 13 13 13;-fx-background-radius: 13 13 13 13;-fx-background-insets: 4 4 4 4;-fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.23), 8, 0, 0, 8)";
        this.rootPane.setStyle(style);
    }

    public static MyPopupWindow getNewInstance(Pane pane) {
        return new MyPopupWindow(pane, ClientSingleton.getInstance().getParentWindow().getScene().getWindow(), false);
    }

    public static MyPopupWindow getNewInstance(Pane pane, Window owner) {
        return new MyPopupWindow(pane, owner, false);
    }

    public static MyPopupWindow getNewInstance(Pane pane, Window owner, boolean isTransparent) {
        return new MyPopupWindow(pane, owner, isTransparent);
    }

    public void showAndWait() {
        this.stage.setWidth(this.rootPane.getMaxWidth());
        this.stage.setHeight(this.rootPane.getMaxHeight());
        ClientSingleton.getInstance().toCenterInScreen(this.stage);
        this.stage.showAndWait();
    }

    public void showInCenter() {
        this.stage.setWidth(this.rootPane.getMaxWidth());
        this.stage.setHeight(this.rootPane.getMaxHeight());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "showInCenter " + this.rootPane.getMaxWidth() + "x" + this.rootPane.getMaxHeight());
        ClientSingleton.getInstance().toCenterInScreen(this.stage);
        this.stage.show();
    }

    public MyPopupWindow setAlwaysOnTop(boolean mode) {
        this.stage.setAlwaysOnTop(mode);
        return this;
    }

    public void showFromRight(double paneWidth) {
        this.stage.show();
        this.stage.setAlwaysOnTop(true);
        this.stage.setWidth(this.rootPane.getMaxWidth());
        this.stage.setHeight(this.rootPane.getMaxHeight());
        Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        double toX = screenBounds.getMaxX() - paneWidth - 10.0;
        double toY = 10.0;
        if (Screen.getScreens().size() > 1) {
            SimpleDoubleProperty moveY = new SimpleDoubleProperty(screenBounds.getMinY());
            Timeline timelineY = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveY, (Object)toY)})});
            moveY.addListener((obs, oldValue, newValue) -> this.stage.setX(newValue.doubleValue()));
            this.stage.setX(toX);
            timelineY.play();
        } else {
            SimpleDoubleProperty moveX = new SimpleDoubleProperty(screenBounds.getMaxX());
            Timeline timelineX = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveX, (Object)toX)})});
            moveX.addListener((obs, oldValue, newValue) -> this.stage.setX(newValue.doubleValue()));
            this.stage.setY(toY);
            timelineX.play();
        }
    }

    public void showAtPosition(double height, boolean isAlwaysOnTop) {
        this.showAtPosition(height, isAlwaysOnTop, true);
    }

    public void showAtPosition(double height, boolean isAlwaysOnTop, boolean isShow) {
        this.stage.setAlwaysOnTop(isAlwaysOnTop);
        this.stage.setMaxWidth(this.rootPane.getMaxWidth());
        this.stage.setWidth(this.rootPane.getMaxWidth());
        this.stage.setHeight(this.rootPane.getMaxHeight());
        Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        double fromX = screenBounds.getMaxX();
        Pair<Double, Double> pair = ResizeHelper.getNotificationPosition(this.stage, (int)height);
        double toX = (Double)pair.getKey();
        double toY = (Double)pair.getValue();
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            this.stage.show();
            if (Screen.getScreens().size() > 1) {
                SimpleDoubleProperty moveY = new SimpleDoubleProperty(screenBounds.getMaxY());
                Timeline timelineY = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveY, (Object)toY)})});
                moveY.addListener((obs, oldValue, newValue) -> this.stage.setY(newValue.doubleValue()));
                this.stage.setX(toX);
                timelineY.play();
            } else {
                SimpleDoubleProperty moveX = new SimpleDoubleProperty(fromX);
                Timeline timelineX = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveX, (Object)toX)})});
                moveX.addListener((obs, oldValue, newValue) -> this.stage.setX(newValue.doubleValue()));
                this.stage.setY(toY);
                timelineX.play();
            }
        } else {
            this.stage.setX(toX);
            this.stage.setY(toY);
            if (isShow) {
                this.stage.show();
            }
        }
    }

    public void printPosition() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Screen stage.isShowing() " + this.stage.isShowing() + " stage.isAlwaysOnTop()=" + this.stage.isAlwaysOnTop());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Screen bounds " + ClientSingleton.getInstance().getCurrentScreenBounds());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Notification stage position x: " + this.stage.getX() + " y: " + this.stage.getY() + " size " + this.stage.getWidth() + "x" + this.stage.getHeight());
    }

    public void hideToRight(boolean withRelease) {
        this.hideToRight(withRelease, true);
    }

    public void hideToRight(boolean withRelease, boolean isWithHide) {
        ClientSingleton.getInstance().runLater(() -> this.onHideToRight(withRelease, isWithHide));
    }

    private void onHideToRight(boolean withRelease, boolean isWithHide) {
        this.stage.setAlwaysOnTop(false);
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
            if (Screen.getScreens().size() > 1) {
                SimpleDoubleProperty moveY = new SimpleDoubleProperty(this.stage.getY());
                Timeline timelineY = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveY, (Object)screenBounds.getMaxY())})});
                moveY.addListener((obs, oldValue, newValue) -> {
                    this.stage.setY(newValue.doubleValue());
                    if (this.stage.getY() > screenBounds.getMaxY() - 5.0 && isWithHide) {
                        this.hide();
                    }
                });
                timelineY.setOnFinished(actionEvent -> {
                    if (withRelease) {
                        this.release();
                    }
                });
                timelineY.play();
            } else {
                SimpleDoubleProperty moveX = new SimpleDoubleProperty(this.stage.getX());
                Timeline timelineX = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveX, (Object)screenBounds.getMaxX())})});
                moveX.addListener((obs, oldValue, newValue) -> {
                    this.stage.setX(newValue.doubleValue());
                    if (this.stage.getX() > screenBounds.getWidth() - 5.0 && isWithHide) {
                        this.hide();
                    }
                });
                timelineX.setOnFinished(actionEvent -> {
                    if (withRelease) {
                        this.release();
                    }
                });
                timelineX.play();
            }
        } else {
            if (isWithHide) {
                this.hide();
            }
            if (withRelease) {
                this.release();
            }
        }
    }

    public void release() {
        Node node;
        if (!this.rootPane.getChildren().isEmpty() && (node = (Node)this.rootPane.getChildren().remove(0)) instanceof Pane) {
            Pane pane = (Pane)node;
            ClientSingleton.getInstance().releaseViewResources(pane);
            this.stage.close();
            this.stage.setScene(null);
            this.stage = null;
        }
    }

    public MyPopupWindow initMotionListeners(Node node) {
        node.setOnMousePressed(event -> {
            node.setCursor(Cursor.MOVE);
            this.xOffset = this.stage.getX() - event.getScreenX();
            this.yOffset = this.stage.getY() - event.getScreenY();
        });
        node.setOnMouseReleased(event -> node.setCursor(Cursor.DEFAULT));
        node.setOnMouseDragged(event -> {
            this.stage.setX(event.getScreenX() + this.xOffset);
            this.stage.setY(event.getScreenY() + this.yOffset);
        });
        return this;
    }

    public Pane getContent() {
        return this.rootPane;
    }

    public void hide() {
        ClientSingleton.getInstance().removeFromOpenedPopupsList(this);
        ClientSingleton.getInstance().runLater(() -> {
            this.stage.hide();
            this.stage.setAlwaysOnTop(false);
        });
    }

    public void show() {
        if (!this.isShowing()) {
            this.show(null, true);
        }
    }

    public void show(Node pane, boolean isListDown) {
        if (pane == null) {
            this.stage.setWidth(this.rootPane.getMaxWidth());
            this.stage.setHeight(this.rootPane.getMaxHeight());
            ClientSingleton.getInstance().toCenterInScreen(this.stage);
        } else {
            double y;
            double x;
            Bounds boundsInScene = pane.localToScreen(pane.getBoundsInLocal());
            if (isListDown) {
                x = boundsInScene.getMinX() + 10.0;
                y = boundsInScene.getMinY() + pane.getLayoutBounds().getHeight();
            } else {
                x = boundsInScene.getMinX() + boundsInScene.getWidth() - this.rootPane.getMaxWidth() - 5.0;
                y = boundsInScene.getMinY() - this.rootPane.getMaxHeight() - 10.0;
            }
            this.stage.setMaxWidth(this.rootPane.getMaxWidth());
            this.stage.setWidth(this.rootPane.getMaxWidth());
            this.stage.setHeight(this.rootPane.getMaxHeight());
            this.stage.setX(x);
            this.stage.setY(y);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "show boundsInScene=" + boundsInScene);
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "show window x=" + this.stage.getX() + " y=" + this.stage.getY() + " size=" + this.stage.getWidth() + "x" + this.stage.getHeight());
        try {
            this.stage.showAndWait();
        }
        catch (Exception ex) {
            try {
                this.hide();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showAutoPosition(Node node) {
        this.showAutoPosition(node, true);
    }

    public void showAutoPosition(Node node, boolean isWait) {
        boolean isLeftStyle;
        Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        double width = screenBounds.getWidth() - screenBounds.getMinX();
        double height = screenBounds.getHeight() - screenBounds.getMinY();
        Bounds boundsInScreen = node.localToScreen(node.getBoundsInLocal());
        double y = boundsInScreen.getMinY() + boundsInScreen.getHeight() + 4.0;
        double x = boundsInScreen.getMinX();
        double maxHeight = this.rootPane.getMaxHeight() + 10.0;
        double maxWidth = this.rootPane.getMaxWidth() + 10.0;
        this.isUpStyle = boundsInScreen.getMinY() + boundsInScreen.getHeight() + maxHeight > height;
        boolean bl = isLeftStyle = boundsInScreen.getMinX() + boundsInScreen.getWidth() + (maxWidth > boundsInScreen.getWidth() ? maxWidth - boundsInScreen.getWidth() : 0.0) > width;
        if (this.isUpStyle) {
            y = boundsInScreen.getMinY() - maxHeight;
            if (y < screenBounds.getMinY()) {
                y = screenBounds.getMinY() + 10.0;
            }
            if (isLeftStyle) {
                x = boundsInScreen.getMinX() + (boundsInScreen.getWidth() - maxWidth) / 2.0;
            }
        } else if (isLeftStyle) {
            x = boundsInScreen.getMinX() + (boundsInScreen.getWidth() - maxWidth) / 2.0;
        }
        this.stage.setMaxWidth(this.rootPane.getMaxWidth());
        this.stage.setWidth(this.rootPane.getMaxWidth());
        this.stage.setHeight(this.rootPane.getMaxHeight());
        this.stage.setX(x);
        this.stage.setY(y);
        if (!this.stage.isShowing()) {
            if (isWait) {
                this.stage.showAndWait();
            } else {
                this.stage.show();
            }
        }
    }

    public void goToYLocation(int height) {
        Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        double toY = screenBounds.getHeight() - (double)height;
        SimpleDoubleProperty moveY = new SimpleDoubleProperty(this.stage.getY());
        Timeline timelineX = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveY, (Object)toY)})});
        moveY.addListener((obs, oldValue, newValue) -> this.stage.setY(newValue.doubleValue()));
        timelineX.play();
    }

    public void relocateStage(Pane node, int paneHeight) {
        boolean isLeftStyle;
        Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "relocateStage=" + screenBounds);
        double width = screenBounds.getWidth() - screenBounds.getMinX();
        double height = screenBounds.getHeight() - screenBounds.getMinY();
        Bounds boundsInScreen = node.localToScreen(node.getBoundsInLocal());
        double y = boundsInScreen.getMinY() + boundsInScreen.getHeight() + 4.0;
        double x = boundsInScreen.getMinX();
        double maxWidth = this.rootPane.getMaxWidth() + 10.0;
        this.isUpStyle = boundsInScreen.getMinY() + boundsInScreen.getHeight() + (double)(paneHeight += 10) > height;
        boolean bl = isLeftStyle = boundsInScreen.getMinX() + boundsInScreen.getWidth() + (maxWidth > boundsInScreen.getWidth() ? maxWidth - boundsInScreen.getWidth() : 0.0) > width;
        if (this.isUpStyle) {
            y = boundsInScreen.getMinY() - (double)paneHeight;
            if (y < screenBounds.getMinY()) {
                y = screenBounds.getMinY() + 10.0;
            }
            if (isLeftStyle) {
                x = boundsInScreen.getMinX() + boundsInScreen.getWidth() - maxWidth;
            }
        } else if (isLeftStyle) {
            x = boundsInScreen.getMinX() + boundsInScreen.getWidth() - maxWidth;
        }
        if (screenBounds.getMinY() < 0.0) {
            y = -this.stage.getHeight() - this.screenPadding;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Screen bounds toX " + x + " toY " + y + " stage.isShowing()=" + this.stage.isShowing());
        this.stage.setX(x);
        this.stage.setY(y);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " isShowing=" + this.isShowing();
    }
}

