/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.stage;

import java.awt.MouseInfo;
import java.awt.Point;
import java.util.HashMap;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.ClientSingletonUtil;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.connector.utils.resources.ImageResource;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.stage.ResizeListener;

public class ResizeHelper {
    private double lastWidth;
    private double lastHeight;
    private double lastX = -1.0;
    private double lastY = -1.0;
    private final SimpleBooleanProperty isFullScreen = new SimpleBooleanProperty((Object)false, "isFullScreen");
    private final SimpleBooleanProperty isFullVideoScreen = new SimpleBooleanProperty((Object)false, "isFullVideoScreen");
    private final SimpleDoubleProperty currentDPI = new SimpleDoubleProperty(1.0);
    private double xOffset;
    private double yOffset;
    private final Stage stage;
    private BoundingBox lastBounds;
    private BoundingBox lastVideoBounds;
    public static boolean isResize;
    private int currentViewMode = -1;

    public void setIconified(boolean mode) {
        boolean action = mode && !this.stage.isIconified() || !mode && this.stage.isIconified();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "showRingotel setIconified mode = " + mode + " action = " + action);
        if (action) {
            this.stage.setIconified(mode);
        }
    }

    public void setFullScreen() {
        if (AudioCaller.getActiveLine() != null && AudioCaller.getActiveLine().isVideoEnabled()) {
            this.setFullVideoScreen();
        } else {
            this.setFullScreen(!this.isFullScreen());
        }
    }

    public void setFullVideoScreen() {
        this.setFullVideoScreen(!this.isFullVideoScreen());
    }

    private void setShadowedStyle() {
        String menuStyle;
        String style;
        if (!this.isFullScreenMode()) {
            style = "-fx-border-radius: 13; -fx-background-radius: 13;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);";
            menuStyle = "-fx-border-radius: 13 0 0 13;-fx-background-radius: 13 0 0 13;";
        } else {
            style = "-fx-border-radius: 0; -fx-background-radius: 0;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);";
            menuStyle = "-fx-border-radius: 0;-fx-background-radius: 0;";
        }
        Pane shadowedPane = (Pane)this.stage.getScene().getRoot().getChildrenUnmodifiable().get(0);
        for (Node pane1 : this.stage.getScene().getRoot().getChildrenUnmodifiable()) {
            pane1.applyCss();
            if (!(pane1 instanceof Pane)) continue;
            ((Pane)pane1).layout();
        }
        shadowedPane.setStyle(style);
        Pane menuPane = (Pane)shadowedPane.getChildren().get(0);
        menuPane.setStyle(menuStyle);
        ((Pane)this.stage.getScene().getRoot()).setPadding(new Insets(this.isFullScreenMode() ? 0.0 : 10.0));
        this.stage.getScene().getRoot().applyCss();
        this.stage.getScene().getRoot().layout();
    }

    public void initDragListener(Node node) {
        node.setCursor(Cursor.DEFAULT);
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            if (!this.isFullScreenMode() && this.stage != null) {
                this.xOffset = this.stage.getX() - event.getScreenX();
                this.yOffset = this.stage.getY() - event.getScreenY();
                node.setCursor(Cursor.MOVE);
            }
            event.consume();
        });
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> node.setCursor(Cursor.DEFAULT));
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            if (!this.isFullScreenMode() && node.getCursor() != Cursor.DEFAULT) {
                try {
                    this.stage.setX(event.getScreenX() + this.xOffset);
                    this.stage.setY(event.getScreenY() + this.yOffset);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            event.consume();
        });
    }

    public ResizeHelper(Stage stage) {
        this.stage = stage;
        this.stage.setMinHeight(550.0);
        this.stage.setHeight(728.0);
        this.stage.xProperty().addListener((observable, oldValue, newValue) -> {
            this.lastX = !this.isFullScreenMode() ? newValue.doubleValue() : this.lastX;
        });
        this.stage.yProperty().addListener((observable, oldValue, newValue) -> {
            this.lastY = !this.isFullScreenMode() ? newValue.doubleValue() : this.lastY;
        });
        this.stage.widthProperty().addListener((observable, oldValue, newValue) -> {
            this.lastWidth = !this.isFullScreenMode() ? newValue.doubleValue() : this.lastWidth;
        });
        this.stage.heightProperty().addListener((observable, oldValue, newValue) -> {
            this.lastHeight = !this.isFullScreenMode() ? newValue.doubleValue() : this.lastHeight;
        });
        this.stage.setFullScreenExitHint(null);
        this.stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
        this.isFullScreen.addListener((event, oldValue, newValue) -> this.resize((boolean)newValue));
        this.isFullVideoScreen.addListener((event, oldValue, newValue) -> this.resize((boolean)newValue));
        this.currentDPI.addListener((event, oldValue, newValue) -> {
            if ((oldValue == null || oldValue.doubleValue() != newValue.doubleValue()) && ClientSingleton.getInstance().isFocused()) {
                TimerExecutor.getInstance().setMyAction(this::resize).startWithDelayInGUIThread(1500L);
            }
        });
        Screen.getScreens().addListener(change -> {
            if (change.getList().isEmpty() || stage.getScene() == null) {
                return;
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "SCREEN Screen.getScreens().size =  " + Screen.getScreens().size());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "SCREEN getCurrentScreen() =  " + this.getCurrentScreen().getVisualBounds());
            Screen screen = this.getCurrentScreen();
            this.currentDPI.set(screen.getDpi());
        });
        ClientSingleton.toLog(this.getClass().getSimpleName(), "SCREEN Screen.getScreens().size =  " + this.getCurrentScreen().getDpi());
        if (stage.getScene() != null) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "SCREEN " + this.getCurrentScreen().getVisualBounds().getWidth() + "x" + this.getCurrentScreen().getVisualBounds().getHeight());
        }
    }

    public void setMinWidth(int mode) {
        this.currentViewMode = mode;
        if (mode == 1) {
            if (this.isFullScreen() || this.isFullVideoScreen()) {
                if (this.isFullScreen()) {
                    this.setFullScreen(false);
                }
                if (this.isFullVideoScreen()) {
                    this.setFullVideoScreen(false);
                }
            }
            this.stage.setMinWidth(0.0);
            this.stage.setMaxWidth(this.getCurrentWidth());
            this.stage.setWidth(this.getCurrentWidth());
        } else if (ClientUtil.getOS() == ClientUtil.OS.LINUX) {
            double width = this.getCurrentScreen().getVisualBounds().getWidth();
            this.stage.setMinWidth(width);
            this.stage.setMaxWidth(width);
            this.stage.setWidth(width);
        } else {
            this.stage.setMinWidth(this.getCurrentMinWidth());
            this.stage.setMaxWidth(this.getCurrentScreen().getVisualBounds().getWidth());
            this.stage.setWidth(this.getCurrentWidth());
        }
    }

    public double getCurrentWidth() {
        double width = this.currentViewMode == 1 ? 370.0 : 1200.0;
        return width;
    }

    private double getCurrentMinWidth() {
        double width = this.currentViewMode == 1 ? 350.0 : 850.0;
        return width;
    }

    public int getCurrentViewMode() {
        return this.currentViewMode;
    }

    private void resize(boolean newValue) {
        ClientSingleton.getInstance().runLater(() -> this.onResize(newValue));
    }

    private void onResize(boolean newValue) {
        isResize = true;
        this.setShadowedStyle();
        if (newValue) {
            this.setLastVideoBounds();
            this.setFullScreenByLayout();
        } else {
            Bounds bounds = this.getLastVideoBounds();
            if (bounds != null) {
                if (this.currentViewMode == 1) {
                    bounds = new BoundingBox(bounds.getMinX(), bounds.getMinY(), this.getCurrentWidth(), 728.0);
                }
                this.setPosition(bounds);
            }
        }
        this.stage.getScene().getRoot().applyCss();
        this.stage.getScene().getRoot().layout();
        TimerExecutor.getInstance().setMyAction(() -> {
            isResize = false;
        }).startWithDelay(200L);
    }

    public void setPosition(boolean isMainScreen) {
        boolean isRepaint = false;
        if (isMainScreen) {
            if (this.stage.getWidth() != this.getCurrentWidth()) {
                this.resize(this.getCurrentWidth(), 728.0);
                isRepaint = true;
            }
        } else if (this.stage.getWidth() != 330.0) {
            this.resize(330.0, 625.0);
        }
        if (isRepaint) {
            this.stage.getScene().getRoot().applyCss();
            this.stage.getScene().getRoot().layout();
        }
        Rectangle2D primaryScreenBounds = this.getCurrentScreen().getVisualBounds();
        double width = primaryScreenBounds.getWidth() - primaryScreenBounds.getMinX();
        double height = primaryScreenBounds.getHeight() - primaryScreenBounds.getMinY();
        this.stage.setX((width - this.stage.getWidth()) / 2.0);
        this.stage.setY((height - this.stage.getHeight()) / 2.0);
        this.stage.getScene().addEventFilter(MouseEvent.ANY, (EventHandler)ResizeListener.getInstance(this.stage, 15));
        this.setShadowedStyle();
    }

    private void setPosition(Bounds bounds) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "SCREEN setPosition =  " + bounds.getWidth() + "x" + bounds.getHeight());
        if (Double.isNaN(bounds.getMinX()) || Double.isNaN(bounds.getMinY()) || Double.isNaN(bounds.getWidth()) || Double.isNaN(bounds.getHeight())) {
            return;
        }
        this.toNewBounds(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    public void setFullScreenByLayout() {
        Rectangle2D bounds = this.getCurrentScreen().getVisualBounds();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setFullScreenByLayout =  " + bounds.getWidth() + "x" + bounds.getHeight());
        this.toNewBounds(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    private void toNewBounds(double x, double y, double width, double height) {
        if (ClientSingleton.getInstance().getParentWindow().isFocused()) {
            this.stage.setOpacity(0.0);
        }
        TimerExecutor.getInstance().setMyAction(() -> {
            boolean withStageResized;
            try {
                this.resize(width, height);
                this.stage.setX(x);
                this.stage.setY(y);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.stage.setMaxWidth(width * 2.0);
            Timeline tl2 = new Timeline();
            boolean bl = withStageResized = AudioCaller.getActiveLine() == null || !AudioCaller.getActiveLine().isVideoEnabled();
            if (withStageResized) {
                tl2.setOnFinished(event1 -> {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("isFullScreen", this.isFullScreen());
                    ClientSingleton.getInstance().doNotify("smile.uccproject.RESIZE_PANE", data);
                });
            }
            if (this.stage.getOpacity() != 1.0) {
                KeyValue kvOpacity2 = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)1.0);
                KeyFrame frame2 = new KeyFrame(Duration.millis((double)20.0), new KeyValue[]{kvOpacity2});
                tl2.getKeyFrames().addAll((Object[])new KeyFrame[]{frame2});
                tl2.play();
            }
        }).startWithDelayInGUIThread(30L);
    }

    public Bounds getCurrentBounds() {
        return new BoundingBox(this.stage.getX(), this.stage.getY(), this.stage.getWidth(), this.stage.getHeight());
    }

    private void setLastVideoBounds() {
        this.lastVideoBounds = new BoundingBox(this.stage.getX(), this.stage.getY(), this.stage.getWidth(), this.stage.getHeight());
    }

    public void hideStageOnExit() {
        this.lastBounds = new BoundingBox(this.stage.getX(), this.stage.getY(), this.stage.getWidth(), this.stage.getHeight());
        this.stage.setWidth(1.0);
        this.stage.setHeight(1.0);
        this.stage.setMinWidth(1.0);
        this.stage.setMinHeight(1.0);
    }

    public void restoreStageBounds() {
        this.stage.setWidth(this.getCurrentWidth());
        this.stage.setHeight(728.0);
        this.stage.setMinWidth(this.getCurrentMinWidth());
        this.stage.setMinHeight(550.0);
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "SCREEN restoreStageBounds  size =" + this.stage.getWidth() + "x" + this.stage.getHeight());
        this.lastBounds = null;
        this.stage.getScene().getRoot().applyCss();
        this.stage.getScene().getRoot().requestLayout();
        this.stage.requestFocus();
        this.toCenterInScreen(this.stage);
    }

    private Bounds getLastVideoBounds() {
        return this.lastVideoBounds;
    }

    public void clearLastVideoBounds() {
        if (this.lastBounds != null) {
            if (!this.isFullScreen()) {
                this.setPosition((Bounds)this.lastBounds);
            }
        } else if (this.lastVideoBounds != null && !this.isFullScreen()) {
            this.setPosition((Bounds)this.lastVideoBounds);
        }
        this.lastVideoBounds = null;
        this.setFullVideoScreen(false);
    }

    public boolean isFullVideoScreen() {
        return this.isFullVideoScreen.get();
    }

    public void setFullVideoScreen(boolean isFullVideoScreen) {
        this.isFullVideoScreen.set(isFullVideoScreen);
    }

    public boolean isFullScreen() {
        return this.isFullScreen.get();
    }

    public void setFullScreen(boolean isFullScreen) {
        this.isFullScreen.set(isFullScreen);
    }

    private boolean isFullScreenMode() {
        return this.isFullScreen() || this.isFullVideoScreen();
    }

    public void toCenterInScreen(Stage stage) {
        Rectangle2D rectangle2D = stage.getScene() != null && stage.getScene().getWindow() != null ? this.getCurrentScreen().getVisualBounds() : this.getCurrentScreen_().getVisualBounds();
        double stageWidth = stage.getWidth();
        double stageHeight = stage.getHeight();
        double x = rectangle2D.getMinX() + (rectangle2D.getWidth() - stageWidth) / 2.0;
        double y = rectangle2D.getMinY() + (rectangle2D.getHeight() - stageHeight) / 2.0;
        stage.setX(x);
        stage.setY(y);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "toCenterInScreen x=" + x + " y=" + y + " size=" + stageWidth + "x" + stageHeight + " " + rectangle2D + "\nlastBounds = " + this.lastBounds);
    }

    public Screen getCurrentScreen() {
        if (this.stage.getScene() == null) {
            return Screen.getPrimary();
        }
        return ResizeHelper.getScreen(this.stage.getScene().getWindow());
    }

    public Screen getCurrentScreen_() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        ObservableList screens = Screen.getScreens();
        if (p != null && screens != null && screens.size() > 1) {
            for (Screen screen : screens) {
                Rectangle2D screenBounds = screen.getVisualBounds();
                if (!screenBounds.contains((double)p.x, (double)p.y)) continue;
                return screen;
            }
        }
        return Screen.getPrimary();
    }

    public boolean isMousePointerUnderWindow() {
        Point mousePointer = MouseInfo.getPointerInfo().getLocation();
        return mousePointer != null && this.getCurrentBounds().contains((double)mousePointer.x, (double)mousePointer.y);
    }

    private void resize() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "SCREEN resize =  " + this.isFullScreen());
        if (this.isFullScreen()) {
            this.setFullScreenByLayout();
        } else {
            this.toNewBounds(this.stage.getX(), this.stage.getY(), this.stage.getWidth() + 1.0E-4, this.stage.getHeight() + 1.0E-4);
            double newWidth = this.stage.getWidth() + 1.0E-4;
            double newHeight = this.stage.getHeight() + 1.0E-4;
            this.stage.getScene().getRoot().resize(newWidth, newHeight);
            this.stage.getScene().getRoot().applyCss();
            this.stage.getScene().getRoot().requestLayout();
            this.stage.requestFocus();
        }
    }

    private void resize(double width, double height) {
        if (height < 550.0) {
            height = 550.0;
        }
        if (width < this.getCurrentWidth()) {
            width = this.getCurrentWidth();
        }
        this.stage.setWidth(width);
        this.stage.setHeight(height);
    }

    public static Screen getScreen(Object obj) {
        Bounds parentBounds = ResizeHelper.getBounds(obj);
        Rectangle2D rect = new Rectangle2D(parentBounds.getMinX(), parentBounds.getMinY(), parentBounds.getWidth(), parentBounds.getHeight());
        return ResizeHelper.getScreenForRectangle(rect);
    }

    private static Bounds getBounds(Object obj) {
        if (obj instanceof Node) {
            Node n = (Node)obj;
            Bounds b = n.localToScreen(n.getLayoutBounds());
            return b != null ? b : new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        if (obj instanceof Window) {
            Window window = (Window)obj;
            return new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight());
        }
        return new BoundingBox(0.0, 0.0, 0.0, 0.0);
    }

    public static Screen getScreenForRectangle(Rectangle2D rect) {
        ObservableList screens = Screen.getScreens();
        double rectX0 = rect.getMinX();
        double rectX1 = rect.getMaxX();
        double rectY0 = rect.getMinY();
        double rectY1 = rect.getMaxY();
        Screen selectedScreen = null;
        double maxIntersection = 0.0;
        for (Screen screen : screens) {
            Rectangle2D screenBounds = screen.getBounds();
            double intersection = ResizeHelper.getIntersectionLength(rectX0, rectX1, screenBounds.getMinX(), screenBounds.getMaxX()) * ResizeHelper.getIntersectionLength(rectY0, rectY1, screenBounds.getMinY(), screenBounds.getMaxY());
            if (!(maxIntersection < intersection)) continue;
            maxIntersection = intersection;
            selectedScreen = screen;
        }
        if (selectedScreen != null) {
            return selectedScreen;
        }
        selectedScreen = Screen.getPrimary();
        double minDistance = Double.MAX_VALUE;
        for (Screen screen : screens) {
            double dy;
            Rectangle2D screenBounds = screen.getBounds();
            double dx = ResizeHelper.getOuterDistance(rectX0, rectX1, screenBounds.getMinX(), screenBounds.getMaxX());
            double distance = dx * dx + (dy = ResizeHelper.getOuterDistance(rectY0, rectY1, screenBounds.getMinY(), screenBounds.getMaxY())) * dy;
            if (!(minDistance > distance)) continue;
            minDistance = distance;
            selectedScreen = screen;
        }
        return selectedScreen;
    }

    private static double getOuterDistance(double a0, double a1, double b0, double b1) {
        if (a1 <= b0) {
            return b0 - a1;
        }
        if (b1 <= a0) {
            return b1 - a0;
        }
        return 0.0;
    }

    private static double getIntersectionLength(double a0, double a1, double b0, double b1) {
        return a0 <= b0 ? ResizeHelper.getIntersectionLengthImpl(b0, b1, a1) : ResizeHelper.getIntersectionLengthImpl(a0, a1, b1);
    }

    private static double getIntersectionLengthImpl(double v0, double v1, double v) {
        if (v <= v0) {
            return 0.0;
        }
        return v <= v1 ? v - v0 : v1 - v0;
    }

    public void setFx_BackgroundStackPane(StackPane fx_BackgroundStackPane) {
    }

    public static Pair<Double, Double> getNotificationPosition(Stage stage, int height) {
        int screenPadding = ClientUtil.getOS() == ClientUtil.OS.MAC ? 0 : 30;
        Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        ClientSingleton.toLog("ResizeHelper", "getNotificationPosition screenBounds " + screenBounds);
        double toX = screenBounds.getMaxX() - stage.getWidth() - 10.0;
        double toY = screenBounds.getMaxY() - (double)height - (double)screenPadding;
        ClientSingleton.toLog("ResizeHelper", "getNotificationPosition toX " + toX + " toY " + toY);
        if (screenBounds.getMinX() < 0.0) {
            toX = screenBounds.getMinX() + (screenBounds.getWidth() - stage.getWidth());
        } else if (toX < 30.0) {
            toX = screenBounds.getWidth() - stage.getWidth() - 10.0;
        }
        if (screenBounds.getMinY() < 0.0 && screenBounds.getMaxY() == 0.0) {
            toY = -stage.getHeight() - (double)screenPadding;
        } else if (toY < 30.0) {
            toY = screenBounds.getHeight() - stage.getHeight() - (double)screenPadding;
        }
        return new Pair((Object)toX, (Object)toY);
    }

    public void setBackgroundImage(ImageView fx_ivBackground, String image) {
        ImageResource imageResource = ClientSingleton.getInstance().getImageResourceFromResourcesFile(image);
        if (imageResource != null) {
            fx_ivBackground.setImage(imageResource.getImage());
            fx_ivBackground.setFitWidth(332.0);
            fx_ivBackground.setFitHeight(630.0);
            Rectangle clip = new Rectangle(fx_ivBackground.getFitWidth(), fx_ivBackground.getFitHeight());
            int ARC_WIDTH = 25;
            clip.setArcWidth((double)ARC_WIDTH);
            int ARC_HEIGHT = 25;
            clip.setArcHeight((double)ARC_HEIGHT);
            fx_ivBackground.setClip((Node)clip);
        }
    }
}

