/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.stage;

import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import net.sipsnet.client.connector.ClientSingleton;

public class ResizeListener
implements EventHandler<MouseEvent> {
    private final Stage stage;
    private Cursor cursorEvent = Cursor.DEFAULT;
    private final int border;
    private double startX = 0.0;
    private double startY = 0.0;
    private double minWidth;
    private double maxWidth;
    private double minHeight;
    private double maxHeight;

    private ResizeListener(Stage stage, int border) {
        this.stage = stage;
        this.border = border;
    }

    public static ResizeListener getInstance(Stage stage, int border) {
        return new ResizeListener(stage, border);
    }

    public void handle(MouseEvent mouseEvent) {
        try {
            EventType mouseEventType = mouseEvent.getEventType();
            Scene scene = this.stage.getScene();
            this.minWidth = this.stage.getMinWidth();
            this.maxWidth = this.stage.getMaxWidth();
            this.minHeight = this.stage.getMinHeight();
            this.maxHeight = this.stage.getMaxHeight();
            double mouseEventX = mouseEvent.getSceneX();
            double mouseEventY = mouseEvent.getSceneY();
            double sceneWidth = scene.getWidth();
            double sceneHeight = scene.getHeight();
            if (MouseEvent.MOUSE_MOVED.equals(mouseEventType)) {
                this.cursorEvent = ClientSingleton.getInstance().getCurrentViewMode() == 0 ? (mouseEventX < (double)this.border && mouseEventY < (double)this.border ? Cursor.NW_RESIZE : (mouseEventX < (double)this.border && mouseEventY > sceneHeight - (double)this.border ? Cursor.SW_RESIZE : (mouseEventX > sceneWidth - (double)this.border && mouseEventY < (double)this.border ? Cursor.NE_RESIZE : (mouseEventX > sceneWidth - (double)this.border && mouseEventY > sceneHeight - (double)this.border ? Cursor.SE_RESIZE : (mouseEventX < (double)this.border ? Cursor.W_RESIZE : (mouseEventX > sceneWidth - (double)this.border ? Cursor.E_RESIZE : (mouseEventY < (double)this.border ? Cursor.N_RESIZE : (mouseEventY > sceneHeight - (double)this.border ? Cursor.S_RESIZE : Cursor.DEFAULT)))))))) : (mouseEventY < (double)this.border ? Cursor.N_RESIZE : (mouseEventY > sceneHeight - (double)this.border ? Cursor.S_RESIZE : Cursor.DEFAULT));
                scene.setCursor(this.cursorEvent);
            } else if (MouseEvent.MOUSE_EXITED.equals(mouseEventType) || MouseEvent.MOUSE_EXITED_TARGET.equals(mouseEventType)) {
                scene.setCursor(Cursor.DEFAULT);
            } else if (MouseEvent.MOUSE_PRESSED.equals(mouseEventType)) {
                this.startX = this.stage.getWidth() - mouseEventX;
                this.startY = this.stage.getHeight() - mouseEventY;
                this.stage.getScene().getRoot().layout();
            } else if (MouseEvent.MOUSE_DRAGGED.equals(mouseEventType) && !Cursor.DEFAULT.equals(this.cursorEvent)) {
                if (!Cursor.W_RESIZE.equals(this.cursorEvent) && !Cursor.E_RESIZE.equals(this.cursorEvent)) {
                    double minHeight;
                    double d = minHeight = this.stage.getMinHeight() > (double)(this.border * 2) ? this.stage.getMinHeight() : (double)(this.border * 2);
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.N_RESIZE.equals(this.cursorEvent) || Cursor.NE_RESIZE.equals(this.cursorEvent)) {
                        if (this.stage.getHeight() > minHeight || mouseEventY < 0.0) {
                            this.setStageHeight(this.stage.getY() - mouseEvent.getScreenY() + this.stage.getHeight());
                            this.stage.setY(mouseEvent.getScreenY());
                        }
                    } else if (this.stage.getHeight() > minHeight || mouseEventY + this.startY - this.stage.getHeight() > 0.0) {
                        this.setStageHeight(mouseEventY + this.startY);
                    }
                }
                if (!Cursor.N_RESIZE.equals(this.cursorEvent) && !Cursor.S_RESIZE.equals(this.cursorEvent)) {
                    double minWidth;
                    double d = minWidth = this.stage.getMinWidth() > (double)(this.border * 2) ? this.stage.getMinWidth() : (double)(this.border * 2);
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.W_RESIZE.equals(this.cursorEvent) || Cursor.SW_RESIZE.equals(this.cursorEvent)) {
                        if (this.stage.getWidth() > minWidth || mouseEventX < 0.0) {
                            this.setStageWidth(this.stage.getX() - mouseEvent.getScreenX() + this.stage.getWidth());
                            this.stage.setX(mouseEvent.getScreenX());
                        }
                    } else if (this.stage.getWidth() > minWidth || mouseEventX + this.startX - this.stage.getWidth() > 0.0) {
                        this.setStageWidth(mouseEventX + this.startX);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void setStageWidth(double width) {
        if (ClientSingleton.getInstance().getCurrentViewMode() == 0 && width <= 850.0) {
            this.stage.getScene().setCursor(Cursor.DEFAULT);
            ClientSingleton.getInstance().switchViewMode();
        } else if (width > 850.0) {
            width = Math.min(width, this.maxWidth);
            width = Math.max(width, this.minWidth);
            this.stage.setWidth(width);
        }
    }

    private void setStageHeight(double height) {
        if (height > 550.0) {
            height = Math.min(height, this.maxHeight);
            height = Math.max(height, this.minHeight);
            this.stage.setHeight(height);
        }
    }
}

