/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.taskbar;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.WinDef;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sipsnet.client.utils.taskbar.User32Ex;

public class ImageConverter {
    private static final WinDef.DWORD ICO_VERSION = new WinDef.DWORD(196608L);
    private static final WinDef.DWORD DWORD_ZERO = new WinDef.DWORD(0L);

    public static byte[] writeTransparentIcoImage(BufferedImage src) {
        int t_scanline_size;
        int bitCount = 32;
        int scanline_size = (bitCount * src.getWidth() + 7) / 8;
        if (scanline_size % 4 != 0) {
            scanline_size += 4 - scanline_size % 4;
        }
        if ((t_scanline_size = (src.getWidth() + 7) / 8) % 4 != 0) {
            t_scanline_size += 4 - t_scanline_size % 4;
        }
        int imageSize = 40 + src.getHeight() * scanline_size + src.getHeight() * t_scanline_size;
        ByteBuffer bos = ByteBuffer.allocate(22 + imageSize);
        bos.order(ByteOrder.LITTLE_ENDIAN);
        bos.putShort((short)0);
        bos.putShort((short)1);
        bos.putShort((short)1);
        int iconDirEntryWidth = src.getWidth();
        int iconDirEntryHeight = src.getHeight();
        if (iconDirEntryWidth > 255 || iconDirEntryHeight > 255) {
            iconDirEntryWidth = 0;
            iconDirEntryHeight = 0;
        }
        bos.put((byte)iconDirEntryWidth);
        bos.put((byte)iconDirEntryHeight);
        bos.put((byte)0);
        bos.put((byte)0);
        bos.putShort((short)1);
        bos.putShort((short)bitCount);
        bos.putInt(imageSize);
        bos.putInt(22);
        bos.putInt(40);
        bos.putInt(src.getWidth());
        bos.putInt(2 * src.getHeight());
        bos.putShort((short)1);
        bos.putShort((short)bitCount);
        bos.putInt(0);
        bos.putInt(0);
        bos.putInt(0);
        bos.putInt(0);
        bos.putInt(0);
        bos.putInt(0);
        int bit_cache = 0;
        int bits_in_cache = 0;
        int row_padding = scanline_size - (bitCount * src.getWidth() + 7) / 8;
        for (int y = src.getHeight() - 1; y >= 0; --y) {
            int x;
            for (x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                bos.put((byte)(0xFF & argb));
                bos.put((byte)(0xFF & argb >> 8));
                bos.put((byte)(0xFF & argb >> 16));
                bos.put((byte)(0xFF & argb >> 24));
            }
            for (x = 0; x < row_padding; ++x) {
                bos.put((byte)0);
            }
        }
        int t_row_padding = t_scanline_size - (src.getWidth() + 7) / 8;
        for (int y = src.getHeight() - 1; y >= 0; --y) {
            int x;
            for (x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                int alpha = 0xFF & argb >> 24;
                bit_cache <<= 1;
                if (alpha == 0) {
                    bit_cache |= 1;
                }
                if (++bits_in_cache < 8) continue;
                bos.put((byte)(0xFF & bit_cache));
                bit_cache = 0;
                bits_in_cache = 0;
            }
            if (bits_in_cache > 0) {
                bos.put((byte)(0xFF & (bit_cache <<= 8 - bits_in_cache)));
                bit_cache = 0;
                bits_in_cache = 0;
            }
            for (x = 0; x < t_row_padding; ++x) {
                bos.put((byte)0);
            }
        }
        byte[] result = new byte[bos.position()];
        System.arraycopy(bos.array(), 0, result, 0, bos.position());
        return result;
    }

    public static WinDef.HICON createIcon(byte[] ico) {
        Memory buffer = new Memory((long)ico.length);
        buffer.write(0L, ico, 0, ico.length);
        int nSize = 100;
        int offset = User32Ex.INSTANCE.LookupIconIdFromDirectoryEx(buffer, true, nSize, nSize, 0);
        System.err.println("SetOverlayIcon offset = " + offset);
        if (offset != 0) {
            return User32Ex.INSTANCE.CreateIconFromResourceEx(buffer.share((long)offset), new WinDef.DWORD((long)ico.length), true, ICO_VERSION, nSize, nSize, 0);
        }
        return null;
    }
}

