/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.taskbar;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javafx.stage.Stage;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.utils.taskbar.ImageConverter;

public class TaskBarList3
extends Unknown {
    private static final Guid.GUID CLSID_TaskbarList = new Guid.GUID("{56FDF344-FD6D-11d0-958A-006097C9A090}");
    private static final Guid.GUID IID_ITaskbarList3 = new Guid.GUID("{ea1afb91-9e28-4b86-90e9-9e9f8a5eefaf}");
    private static TaskBarList3 instance;

    public static TaskBarList3 getInstance() {
        if (instance == null && ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            Ole32.INSTANCE.CoInitializeEx(Pointer.NULL, 0);
            PointerByReference p = new PointerByReference();
            WinNT.HRESULT hr = Ole32.INSTANCE.CoCreateInstance(CLSID_TaskbarList, Pointer.NULL, 23, IID_ITaskbarList3, p);
            COMUtils.checkRC((WinNT.HRESULT)hr);
            instance = new TaskBarList3(p.getValue());
        }
        return instance;
    }

    private TaskBarList3(Pointer p) {
        super(p);
        this.HrInit();
    }

    private void HrInit() {
        int hr = this._invokeNativeInt(3, new Object[]{this.getPointer()});
        COMUtils.checkRC((WinNT.HRESULT)new WinNT.HRESULT(hr));
    }

    private void SetOverlayIcon(WinDef.HWND hwnd, WinDef.HICON hIcon, String pszDescription) {
        int hr = this._invokeNativeInt(18, new Object[]{this.getPointer(), hwnd, hIcon, pszDescription});
        COMUtils.checkRC((WinNT.HRESULT)new WinNT.HRESULT(hr));
    }

    public void SetOverlayIcon(Component frame, BufferedImage image, String description) {
        WinDef.HICON ico = null;
        if (image != null) {
            byte[] iconBytes = ImageConverter.writeTransparentIcoImage(image);
            ico = ImageConverter.createIcon(iconBytes);
        }
        WinDef.HWND hwnd = new WinDef.HWND(Native.getComponentPointer((Component)frame));
        this.SetOverlayIcon(hwnd, ico, description);
    }

    private void SetOverlayIcon(Stage stage, BufferedImage image, String description) {
        WinDef.HWND hwnd = User32.INSTANCE.FindWindow(null, stage.getTitle());
        WinDef.HICON ico = null;
        if (image != null) {
            byte[] iconBytes = ImageConverter.writeTransparentIcoImage(image);
            ico = ImageConverter.createIcon(iconBytes);
        }
        if (hwnd != null) {
            this.SetOverlayIcon(hwnd, ico, description);
        }
    }

    public void SetOverlayIcon(Stage stage, BufferedImage bufferedImage) {
        this.SetOverlayIcon(stage, bufferedImage, null);
    }

    private static BufferedImage createOverlayImage(String text) {
        int size = 16;
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(new Color(255, 98, 89));
        g.fillRoundRect(0, 0, size, size, size, size);
        int mainRadius = 14;
        g.setPaint(new Color(255, 98, 89));
        g.fillRoundRect(size / 2 - mainRadius / 2, size / 2 - mainRadius / 2, mainRadius, mainRadius, size, size);
        Font font = g.getFont();
        g.setFont(new Font("Roboto", 1, 10));
        FontMetrics fontMetrics = g.getFontMetrics();
        int textWidth = fontMetrics.stringWidth(text);
        g.setColor(new Color(255, 255, 255));
        g.drawString(text, size / 2 - textWidth / 2 - 1, size / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
        return image;
    }
}

