/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.usb.planctronics_poly;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.utils.usb.planctronics_poly.PlantronicsREST;
import net.sipsnet.client.utils.usb.planctronics_poly.RESTConvenienceClass;
import smile.cti.client.LineInfo;

class EventsListenerThread
extends Thread {
    private Boolean quit = false;
    private Boolean deviceAttached;
    private String sessid = "";

    public EventsListenerThread(String sessid) {
        this.sessid = sessid;
        this.deviceAttached = !sessid.isEmpty();
    }

    @Override
    public void run() {
        ClientSingleton.toLog("PlantronicsREST", "Events Listener Starting quit=" + this.quit + " deviceAttached=" + this.deviceAttached);
        while (!this.quit.booleanValue()) {
            if (this.deviceAttached.booleanValue()) {
                String deviceEvents;
                if (PlantronicsREST.DEBUG) {
                    ClientSingleton.toLog("PlantronicsREST", this.hashCode() + "-- POLLING FOR EVENTS --");
                }
                if ((deviceEvents = RESTConvenienceClass.sendRESTCommandWithDebugPrompt("http://127.0.0.1:32017/Spokes/DeviceServices/Events?sess=" + this.sessid + "&queue=0", "DEVICE EVENTS")).contains("Invalid session id") || deviceEvents.contains("Empty session id")) {
                    ClientSingleton.toLog("PlantronicsREST", "-- ** DEVICE DETACHED / SESSION INVALID ** --");
                    this.deviceAttached = false;
                    PlantronicsREST.closeDevice();
                }
                this.sleepThread(200);
                if (this.quit.booleanValue() || !this.deviceAttached.booleanValue()) continue;
                String callEvents = RESTConvenienceClass.sendRESTCommandWithDebugPrompt("http://127.0.0.1:32017/Spokes/CallServices/CallEvents?name=Ringotel_Shell_Plantronics_Plugin", "CALL EVENTS");
                this.ParseCallEvents(callEvents);
                continue;
            }
            this.quit = true;
        }
        ClientSingleton.toLog("PlantronicsREST", "Events Listener Stopping");
    }

    public void shotDown() {
        this.quit = true;
        if (PlantronicsREST.DEBUG) {
            ClientSingleton.toLog("PlantronicsREST", this.hashCode() + "shotDown quit=" + this.quit);
        }
    }

    private void ParseCallEvents(String callEvents) {
        if (callEvents.contains("[") || callEvents.contains("\"Action\":")) {
            String[] actions;
            callEvents = callEvents.substring(callEvents.indexOf("["));
            callEvents = callEvents.substring(0, callEvents.indexOf("]"));
            for (String item : actions = callEvents.split("\"Action\":")) {
                int pos = item.indexOf(",");
                if (pos <= -1) continue;
                String callId = item.substring(item.indexOf("\"Id\":") + 5);
                callId = callId.substring(0, callId.indexOf(","));
                switch (RESTConvenienceClass.eCallState.get(item.substring(0, pos))) {
                    case "CALL_STATE_ACCEPT_CALL": {
                        LineInfo lineInfo = AudioCaller.getIncomingCallLine();
                        if (lineInfo == null) break;
                        AudioCaller.answerCall(lineInfo);
                        break;
                    }
                    case "CALL_STATE_TERMINATE_CALL": {
                        LineInfo lineInfo = AudioCaller.getActiveLine();
                        if (lineInfo == null) break;
                        AudioCaller.dropCall(lineInfo);
                        break;
                    }
                    case "CALL_STATE_MUTEON": {
                        AudioCaller.setMute(true);
                        break;
                    }
                    case "CALL_STATE_MUTEOFF": {
                        AudioCaller.setMute(false);
                    }
                }
                ClientSingleton.toLog("PlantronicsREST", "CallState: " + RESTConvenienceClass.eCallState.get(item.substring(0, pos)) + ", Call ID: " + callId);
            }
        }
    }

    private void sleepThread(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(EventsListenerThread.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

