/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers;

import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;

public class MyAlert
extends BorderPane {
    private final MyPopupWindow myPopupWindow;
    private String title = ClientSingleton.getInstance().getPackageName();
    private final int HEADER_HEIGHT = 60;
    private final int PANE_WIDTH = 350;
    private final HBox footer = this.getFooter();
    private final VBox textPane = new VBox();
    private final int MAX_HEIGHT = 300;
    private HBox header;
    private MyTextArea myTextArea;
    private final AtomicBoolean result = new AtomicBoolean(false);
    private boolean isAutoClose = false;

    public MyAlert() {
        this((Window)ClientSingleton.getInstance().getParentWindow());
        this.myPopupWindow.setWindowModality();
    }

    public MyAlert(Window owner) {
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this, owner);
        this.textPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        VBox.setVgrow((Node)this.textPane, (Priority)Priority.ALWAYS);
        this.textPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.footer.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.footer.maxWidthProperty().bind((ObservableValue)this.maxWidthProperty());
        this.footer.setAlignment(Pos.CENTER);
        this.footer.setPadding(new Insets(10.0, 0.0, 20.0, 10.0));
        this.setMaxWidth(360.0);
        this.setPrefWidth(360.0);
        this.setMaxHeight(300.0);
        this.setMinHeight(300.0);
    }

    public MyAlert setAlwaysOnTop(boolean mode) {
        this.myPopupWindow.setAlwaysOnTop(mode);
        return this;
    }

    public MyAlert moveToFront() {
        this.myPopupWindow.getStage().toFront();
        return this;
    }

    public void show() {
        this.myPopupWindow.show();
    }

    public boolean showAndWait() {
        this.myPopupWindow.showAndWait();
        return this.result.get();
    }

    private HBox getFooter() {
        HBox hBox = new HBox();
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setMinHeight(60.0);
        hBox.setMaxHeight(60.0);
        hBox.setAlignment(Pos.CENTER);
        return hBox;
    }

    private HBox getHeader() {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "getHeader header = " + this.header + " title=" + this.title);
        if (this.header != null) {
            return this.header;
        }
        HBox hBox = new HBox();
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setMinHeight(60.0);
        hBox.setMaxHeight(60.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        HBox hbAvatarBox = new HBox();
        hbAvatarBox.setMinHeight(60.0);
        hbAvatarBox.prefHeight(60.0);
        hbAvatarBox.setFillHeight(true);
        hbAvatarBox.setAlignment(Pos.CENTER);
        ImageView ivAvatar = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(ivAvatar, "notify_emblem.png");
        hbAvatarBox.getChildren().add((Object)ivAvatar);
        HBox.setMargin((Node)hbAvatarBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        hBox.getChildren().add((Object)hbAvatarBox);
        Label lbContactTitle = new Label(this.title);
        HBox.setMargin((Node)lbContactTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)lbContactTitle);
        HBox.setHgrow((Node)lbContactTitle, (Priority)Priority.ALWAYS);
        lbContactTitle.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        hBox.getChildren().add((Object)lbContactTitle);
        hBox.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        hBox.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        return hBox;
    }

    private void addButton(String buttonTitle, EventHandler<MouseEvent> event) {
        this.addButton(buttonTitle, event, false, true);
    }

    public MyAlert addButton(String buttonTitle, EventHandler<MouseEvent> event, boolean isPositive, boolean isEnable) {
        MyLabelButton myLabelButton = new MyLabelButton(buttonTitle, 30);
        ClientSingleton.getInstance().setMouseCursor((Node)myLabelButton);
        myLabelButton.setEnabled(isEnable);
        double width = new Text(buttonTitle).getLayoutBounds().getWidth();
        myLabelButton.setButtonWidth((int)width + 20);
        myLabelButton.setMaxWidth(170.0);
        HBox.setHgrow((Node)myLabelButton, (Priority)Priority.ALWAYS);
        myLabelButton.addMouseEventHandler(event);
        if (this.isAutoClose) {
            myLabelButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.close()));
        }
        if (isPositive) {
            HBox.setMargin((Node)myLabelButton, (Insets)new Insets(0.0, 5.0, 0.0, 50.0));
            this.footer.getChildren().add(0, (Object)myLabelButton);
        } else {
            HBox.setMargin((Node)myLabelButton, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
            this.footer.getChildren().add((Object)myLabelButton);
        }
        return this;
    }

    public void buildDialog(String text, String buttonTitle) {
        this.buildDialog(text, null, buttonTitle);
    }

    public void buildDialog(String text, String cancelButton, String buttonTitle) {
        this.myTextArea.setText(text);
        this.footer.getChildren().clear();
        if (buttonTitle != null) {
            this.addButton(buttonTitle, (EventHandler<MouseEvent>)((EventHandler)event -> {
                this.result.set(true);
                this.myPopupWindow.hide();
            }));
        }
        this.addButton(cancelButton == null ? ClientSingleton.getInstance().getString("cancel") : cancelButton, (EventHandler<MouseEvent>)((EventHandler)event -> {
            this.result.set(false);
            this.myPopupWindow.hide();
        }));
        this.setCoordinates(text);
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "result = " + this.result);
    }

    public void buildDialogAndShow(String message) {
        this.myTextArea.setText(message);
        this.footer.getChildren().clear();
        this.setCoordinates(message);
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "result = " + this.result);
    }

    private void setCoordinates(String message) {
        TimerExecutor.getInstance().setMyAction(() -> {
            int textHeight = ClientSingleton.getInstance().getContentTextHeight(350, message) + 40;
            this.textPane.setMinHeight((double)textHeight);
            this.textPane.setPrefHeight((double)textHeight);
            this.textPane.setMaxHeight((double)textHeight);
            this.textPane.setManaged(true);
            this.textPane.layout();
        }).startWithDelayInGUIThread(30L);
    }

    public void hide() {
        this.myPopupWindow.hide();
    }

    public void release() {
        this.myPopupWindow.release();
    }

    public void close() {
        this.myPopupWindow.hide();
        this.myPopupWindow.release();
    }

    public MyAlert setMessage(String text) {
        ClientSingleton.getInstance().runLater(() -> this.setTextAndGoToScreenOnTheScreen(text));
        return this;
    }

    public void setTextAndGoToScreenOnTheScreen(String text) {
        this.footer.getChildren().clear();
        this.myTextArea = new MyTextArea(text, (Pane)this.textPane);
        this.myTextArea.setAlertBackground();
        this.myTextArea.prefWidthProperty().bind((ObservableValue)this.textPane.widthProperty());
        this.textPane.getChildren().clear();
        this.textPane.setAlignment(text.length() > 200 ? Pos.CENTER_LEFT : Pos.CENTER);
        this.textPane.getChildren().add((Object)this.myTextArea);
        int textHeight = ClientSingleton.getInstance().getContentTextHeight(350, text) + 40;
        this.myTextArea.setMinHeight(textHeight);
        this.textPane.setMinHeight(0.0);
        this.textPane.setPrefHeight((double)textHeight);
        this.textPane.setMaxHeight(Double.MAX_VALUE);
        this.setTop((Node)this.getHeader());
        this.setCenter((Node)this.textPane);
        this.setBottom((Node)this.footer);
    }

    public MyAlert setContentPane(Pane pane) {
        this.textPane.getChildren().add((Object)pane);
        this.setTop((Node)this.getHeader());
        this.setCenter((Node)this.textPane);
        this.setBottom((Node)this.footer);
        return this;
    }

    public void clearFooter() {
        this.footer.getChildren().clear();
    }

    public MyAlert setHeader(HBox pane) {
        this.header = pane;
        return this;
    }

    public void setNewHeader(HBox pane) {
        this.header = pane;
        this.setHeader(this.header);
    }

    public void setNewContentPane(Pane pane) {
        this.setCenter((Node)pane);
    }

    public MyAlert setAutoClose(boolean autoClose) {
        this.isAutoClose = autoClose;
        return this;
    }

    public MyAlert addPositiveButton(String title, EventHandler<MouseEvent> eventHandler) {
        this.addButton(title, eventHandler);
        return this;
    }

    public MyAlert addNegativeButton(String title, EventHandler<MouseEvent> eventHandler, boolean isEnable) {
        this.addButton(title, eventHandler, false, isEnable);
        return this;
    }

    public MyAlert addNegativeButton(String title, EventHandler<MouseEvent> eventHandler) {
        this.addButton(title, eventHandler);
        return this;
    }

    public void buildDialogAndShow() {
        this.myPopupWindow.showAndWait();
    }

    public void showInCenter() {
        ClientSingleton.getInstance().runLater(this.myPopupWindow::showInCenter);
    }

    public MyAlert setTitle(String t) {
        if (!t.isEmpty()) {
            this.title = t;
        }
        return this;
    }
}

