/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.RichTextViwer;

import java.io.File;
import java.util.Optional;
import javafx.scene.Cursor;
import javafx.scene.effect.BlendMode;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Path;
import net.sipsnet.client.connector.ClientSingleton;
import smile.cti.client.ClientConnector;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;

public class Highlight
implements FileTransferListener {
    private final int startPosition;
    private final int endPosition;
    private final Path highlightPath = new Path();
    private final boolean isLink;
    private String highlightText;
    private FileInfo fileInfo;

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public Path getHighlightPath() {
        return this.highlightPath;
    }

    public void setHighlightText(String highlightText) {
        this.highlightText = highlightText;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public Highlight(int startPosition, int endPosition, boolean isLink, String style) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.isLink = isLink;
        if (isLink) {
            this.highlightPath.setCursor(Cursor.HAND);
        }
        this.highlightPath.setStyle(style);
        this.highlightPath.setManaged(false);
        this.highlightPath.setStroke(null);
        this.highlightPath.setBlendMode(BlendMode.ADD);
        this.highlightPath.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            Optional<ClientConnector> optionalClientConnector;
            if (this.highlightText != null && this.highlightText.contains("http:") || this.highlightText.contains("https:")) {
                ClientSingleton.getInstance().openWebBrowser(this.highlightText);
            } else if (this.fileInfo != null && (optionalClientConnector = ClientSingleton.getInstance().getClientConnector()).isPresent()) {
                if (this.fileInfo.isLoaded()) {
                    try {
                        File file = optionalClientConnector.get().getFile(this.fileInfo);
                        ClientSingleton.getInstance().openFile(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.fileInfo.addTransfrerListener((FileTransferListener)this);
                    optionalClientConnector.get().loadFile(this.fileInfo);
                }
            }
        });
    }

    public void transferStarted(FileInfo fileInfo) {
    }

    public void transferProgress(FileInfo fileInfo) {
    }

    public void transferEnded(FileInfo fileInfo) {
        fileInfo.removeTransfrerListener((FileTransferListener)this);
        if (fileInfo.isLoaded()) {
            try {
                File file = ClientSingleton.getInstance().getClientConnector().get().getFile(fileInfo);
                ClientSingleton.getInstance().openFile(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

