/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.RichTextViwer;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.RichTextViwer.InnerTextArea;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.FileInfo;
import smile.cti.client.MessageInfo;

public class MyTextArea
extends AnchorPane {
    private final InnerTextArea textArea;
    private MessageInfo messageInfo;
    private String searchingText;

    public MyTextArea(MessageInfo messageInfo, Pane node, String searchingText, boolean isNeedResize, EventHandler<? super MouseEvent> eventHandler) {
        this.messageInfo = messageInfo;
        this.searchingText = searchingText;
        this.textArea = new InnerTextArea(null, node, "rgb(69,90,100)", isNeedResize, eventHandler);
        this.getChildren().addAll((Object[])new Node[]{this.textArea});
        AnchorPane.setTopAnchor((Node)this.textArea, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.textArea, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.textArea, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.textArea, (Double)0.0);
        if (eventHandler != null) {
            this.addMenuEventHandler(eventHandler);
        }
        ClientSingleton.getInstance().runLater(this::spell);
    }

    public MyTextArea(String mContent, Pane node) {
        this(mContent, node, " rgb(69,90,100)", true, null);
    }

    public MyTextArea(String mContent, Pane node, boolean isNeedResize) {
        this(mContent, node, " rgb(69,90,100)", isNeedResize, null);
    }

    public MyTextArea(String mContent, Pane node, boolean isNeedResize, EventHandler<? super MouseEvent> eventHandler) {
        this(mContent, node, " rgb(69,90,100)", isNeedResize, eventHandler);
    }

    public MyTextArea(String mContent, Pane node, String textColor, boolean isNeedResize, EventHandler<? super MouseEvent> eventHandler) {
        this.textArea = new InnerTextArea(null, node, textColor, isNeedResize, eventHandler);
        HBox.setHgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
        this.textArea.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.textArea);
        AnchorPane.setTopAnchor((Node)this.textArea, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.textArea, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.textArea, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.textArea, (Double)0.0);
        if (eventHandler != null) {
            this.addMenuEventHandler(eventHandler);
        }
        if (mContent != null) {
            this.textArea.setText(mContent);
        }
    }

    public void clear() {
        if (this.textArea != null) {
            this.textArea.getStyleClass().clear();
        }
    }

    public String getText() {
        return this.textArea.getText();
    }

    public InnerTextArea getTextArea() {
        return this.textArea;
    }

    public void setEditable(boolean mode) {
        this.textArea.setEditable(mode);
    }

    private void spell() {
        ArrayList<String> linked = this.bindToTextArea(this.textArea);
        if (!this.searchingText.isEmpty()) {
            List<Pair<Integer, Integer>> searchIndexes = this.getSearchIndexes(this.searchingText);
            if (!searchIndexes.isEmpty()) {
                this.textArea.setHighlightStyle(this.textArea.SEARCH_HIGH_LITE);
                Pair<Integer, Integer> pair = searchIndexes.get(0);
                this.textArea.highlight((Integer)pair.getKey(), (Integer)pair.getValue());
            }
        } else if (!linked.isEmpty()) {
            linked.forEach(link -> {
                int startIndex;
                if (this.messageInfo instanceof FileInfo && (this.messageInfo.getType() == 2 && ((FileInfo)this.messageInfo).getFileName() == null || ((FileInfo)this.messageInfo).getFileName().isEmpty())) {
                    StringBuilder text = new StringBuilder(this.messageInfo.getContent());
                    startIndex = text.indexOf((String)link) + 1;
                    this.textArea.setHighlightStyle(this.textArea.LINK_HIGH_LITE);
                } else {
                    startIndex = 0;
                    this.textArea.setHighlightStyle(this.textArea.FILE_HIGH_LITE);
                }
                int endIndex = startIndex + link.length();
                this.textArea.highlight(startIndex, endIndex);
            });
        }
        if (this.messageInfo instanceof FileInfo) {
            String mContent = MessageInfoCellLabels.setContentLabel(this.messageInfo);
            mContent = MessageInfoCellLabels.checkFileName(mContent);
            this.textArea.setText(mContent);
        } else {
            this.textArea.setText(this.messageInfo.getContent());
        }
    }

    private ArrayList<String> bindToTextArea(TextArea messagePane) {
        FileInfo fileInfo;
        ArrayList<String> linked = new ArrayList<String>();
        String mContent = this.messageInfo.getContent();
        if (mContent.contains("http:") || mContent.contains("https:")) {
            int index2;
            StringBuilder text = new StringBuilder(messagePane.getText());
            do {
                int index1;
                if ((index1 = mContent.indexOf("http:")) == -1) {
                    index1 = mContent.indexOf("https:");
                }
                if ((index2 = mContent.indexOf(" ", index1)) == -1) {
                    index2 = mContent.indexOf("\n", index1);
                }
                if (index2 == -1) {
                    index2 = mContent.length();
                }
                String url = mContent.substring(index1, index2);
                while (!Character.isDigit(url.charAt(url.length() - 1)) && !Character.isLetter(url.charAt(url.length() - 1))) {
                    url = url.substring(0, url.length() - 1);
                }
                String mess = mContent.substring(0, index1);
                if (!mess.isEmpty()) {
                    text.append(mess);
                }
                linked.add(url);
                text.append(" ");
                text.append(url);
                text.append(" ");
            } while ((mContent = mContent.substring(index2)).contains("http:") || mContent.contains("https:"));
            if (mContent.length() > 0) {
                text.append(mContent);
            }
            messagePane.setText(text.toString());
        } else if (this.messageInfo.getType() == 2 && (fileInfo = (FileInfo)this.messageInfo).getFileName() != null && fileInfo.getFileName().length() > 0) {
            mContent = fileInfo.getFileName();
            String mess = mContent.replace("\\", "/");
            String fn = mess.substring(mess.lastIndexOf("/") + 1);
            if (fn.contains("_")) {
                fn = fn.substring(fn.indexOf("_") + 1);
            }
            messagePane.setText(fn);
            linked.add(fn);
        }
        return linked;
    }

    private List<Pair<Integer, Integer>> getSearchIndexes(String search) {
        int index = 0;
        ArrayList<Pair<Integer, Integer>> indexes = new ArrayList<Pair<Integer, Integer>>();
        if (search != null && !search.isEmpty()) {
            while ((index = this.messageInfo.getContent().toLowerCase().indexOf(search.toLowerCase(), index)) >= 0) {
                Pair pair = new Pair((Object)index, (Object)(index + search.length()));
                indexes.add((Pair<Integer, Integer>)pair);
                ++index;
            }
        }
        return indexes;
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public void setWhiteBackground() {
        this.textArea.setWhiteBackground();
    }

    public void setAlertBackground() {
        this.textArea.setAlertBackground();
    }

    public void setReplayBackground() {
        this.textArea.setReplayBackground();
    }

    public void setOutgoingBackground() {
        this.textArea.setOutgoingBackground();
    }

    public void setIncomingBackground() {
        this.textArea.setIncomingBackground();
    }

    public void setCommentBackground() {
        this.textArea.setCommentBackground();
    }

    public void setProfileBackground() {
        this.textArea.setProfileBackground();
    }

    public void setEventHandler(EventHandler<? super MouseEvent> eventHandler) {
        this.textArea.addEventHandler(MouseEvent.MOUSE_ENTERED, event -> this.textArea.setCursor(Cursor.HAND));
        this.textArea.addEventHandler(MouseEvent.MOUSE_EXITED, event -> this.textArea.setCursor(Cursor.DEFAULT));
        this.textArea.setOnMouseClicked(eventHandler);
    }

    private void addMenuEventHandler(EventHandler<? super MouseEvent> eventHandler) {
        this.setOnContextMenuRequested(Event::consume);
        this.textArea.setOnContextMenuRequested(Event::consume);
        this.textArea.addEventHandler(MouseEvent.MOUSE_ENTERED, event -> this.textArea.setCursor(Cursor.HAND));
        this.textArea.addEventHandler(MouseEvent.MOUSE_EXITED, event -> this.textArea.setCursor(Cursor.DEFAULT));
        this.textArea.addEventHandler(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, event -> this.textArea.setCursor(Cursor.HAND));
        this.addEventHandler(MouseEvent.MOUSE_EXITED, event -> this.textArea.setCursor(Cursor.DEFAULT));
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, eventHandler);
    }

    public StringProperty getTextProperty() {
        return this.textArea.getTextProperty();
    }

    public void setPromptText(String value) {
        this.textArea.setPromptText(value);
    }
}

