/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.buttoncombobox;

import java.util.List;
import java.util.function.Supplier;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.stage.WindowEvent;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.combobox.IContextMenuActionListener;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;

public class ContextMenuImageButton
extends ImageButton {
    private ContextMenu myContextMenu;
    private Supplier<Void> supplier;
    private Node showNode;
    private EventHandler<MouseEvent> exitEvent = event -> ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
    private EventHandler<MouseEvent> clickedEvent = event -> {
        if (!this.myContextMenu.isShowing()) {
            Bounds boundsInScene;
            Bounds bounds = boundsInScene = this.showNode == null ? this.localToScreen(this.getBoundsInLocal()) : this.showNode.localToScreen(this.showNode.getBoundsInLocal());
            if (this.supplier != null) {
                this.supplier.get();
            }
            Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
            double toX = boundsInScene.getMinX() + this.myContextMenu.getMaxWidth() + 10.0 > screenBounds.getMaxX() ? screenBounds.getMaxX() - boundsInScene.getMinX() - 10.0 : boundsInScene.getMinX();
            this.myContextMenu.show((Node)(this.showNode == null ? this : this.showNode), toX, boundsInScene.getMaxY());
        } else {
            this.myContextMenu.hide();
        }
    };

    public ContextMenu getMyContextMenu() {
        return this.myContextMenu;
    }

    @Override
    public void setImagePath(String image) {
        super.setImagePath(image);
    }

    public void setShowNode(Node showNode) {
        this.showNode = showNode;
    }

    public ContextMenuImageButton(Supplier<Void> supplier) {
        this();
        this.supplier = supplier;
    }

    public ContextMenuImageButton() {
        super.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, this.clickedEvent);
        this.myContextMenu = new MaxSizedContextMenu();
        Theme.getInstance().applyTo(Constants.CONTEXT_MENU, this);
        this.myContextMenu.setMaxHeight(300.0);
        this.myContextMenu.setMinWidth(200.0);
    }

    public void setMenuWidth(int width) {
        this.myContextMenu.setMinWidth((double)width);
    }

    public void clearItems() {
        if (this.myContextMenu != null) {
            this.myContextMenu.getItems().clear();
        }
    }

    public void setOnShowingHandler(EventHandler<WindowEvent> event) {
        this.myContextMenu.setOnShowing(event);
    }

    @Override
    public void setBackgroundColor(String backgroundColor) {
        super.setBackgroundColor(backgroundColor);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    public void clear() {
        if (this.myContextMenu != null) {
            this.myContextMenu.getItems().clear();
        }
    }

    public void addMenuItem(Object title, EventHandler<ActionEvent> eventHandler) {
        this.addItemToMenu(title, eventHandler, null);
    }

    public void addMenuItem(MenuItem menuItem) {
        this.myContextMenu.getItems().add((Object)menuItem);
    }

    public void addItemToMenu(Object title, EventHandler<ActionEvent> eventHandler, String color) {
        this.addItemToMenu(title, eventHandler, color, title.toString());
    }

    public void addItemToMenu(Object title, EventHandler<ActionEvent> eventHandler, String color, String id) {
        MenuItem menuItem = new MenuItem(title.toString());
        menuItem.setId(id);
        menuItem.setOnAction(eventHandler);
        if (color != null) {
            menuItem.setStyle("-fx-text-fill: " + color + ";");
        }
        this.myContextMenu.getItems().add((Object)menuItem);
    }

    public void addItemsListToMenu(List<?> titles, IContextMenuActionListener iContextMenuActionListener) {
        for (int i = 0; i < titles.size(); ++i) {
            Object title = titles.get(i);
            MenuItem menuItem = new MenuItem(title.toString());
            menuItem.setId(String.valueOf(i));
            menuItem.setOnAction(eventHandler -> {
                MenuItem menuItem1 = (MenuItem)eventHandler.getSource();
                iContextMenuActionListener.actionPerformed(menuItem1.getText(), Integer.parseInt(menuItem1.getId()));
            });
            this.myContextMenu.getItems().add((Object)menuItem);
        }
    }

    public void hideMenu() {
        if (this.myContextMenu != null && this.myContextMenu.isShowing()) {
            this.myContextMenu.hide();
        }
    }

    public boolean isShowing() {
        if (this.myContextMenu != null) {
            return this.myContextMenu.isShowing();
        }
        return false;
    }

    @Override
    public void onRelease() {
        super.onRelease();
        this.exitEvent = null;
        this.clickedEvent = null;
        if (this.myContextMenu != null) {
            this.myContextMenu.getItems().clear();
        }
    }

    public void removeMenuItemById(String menuItemId) {
        if (this.myContextMenu != null) {
            for (int i = this.myContextMenu.getItems().size() - 1; i >= 0; --i) {
                MenuItem menuItem = (MenuItem)this.myContextMenu.getItems().get(i);
                if (!menuItem.getId().equals(menuItemId)) continue;
                this.myContextMenu.getItems().remove(i);
                break;
            }
        }
    }

    public boolean containsMenuItemById(String menuItemId) {
        if (this.myContextMenu != null) {
            for (int i = this.myContextMenu.getItems().size() - 1; i >= 0; --i) {
                MenuItem menuItem = (MenuItem)this.myContextMenu.getItems().get(i);
                if (!menuItem.getId().equals(menuItemId)) continue;
                return true;
            }
        }
        return false;
    }

    public void setItemTitleById(String title, String menuItemId) {
        for (int i = this.myContextMenu.getItems().size() - 1; i >= 0; --i) {
            MenuItem menuItem = (MenuItem)this.myContextMenu.getItems().get(i);
            if (!menuItem.getId().equals(menuItemId)) continue;
            menuItem.setText(title);
        }
    }

    public void addIfAbsentMenuItemById(int index, String menuItemTitle, String menuItemId, EventHandler<ActionEvent> eventHandler) {
        if (this.myContextMenu != null) {
            for (int i = this.myContextMenu.getItems().size() - 1; i >= 0; --i) {
                MenuItem menuItem = (MenuItem)this.myContextMenu.getItems().get(i);
                if (!menuItem.getId().equals(menuItemId)) continue;
                return;
            }
        }
        MenuItem menuItem = new MenuItem(menuItemTitle);
        menuItem.setId(menuItemId);
        menuItem.setOnAction(eventHandler);
        this.myContextMenu.getItems().add(index, (Object)menuItem);
    }
}

