/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.buttons.imagebutton;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.IActionOnRelease;

public class ImageButton
extends StackPane
implements IActionOnRelease {
    private boolean isReleaseFocusAfterClick = false;
    private String[] clickImages = null;
    private int currentClickImage = -1;
    private final HBox imageBackground = new HBox();
    private int fixImageWidth = -1;
    private int fixImageHeight = -1;
    protected ImageView imageViewButton = new ImageView();
    private final Map<EventType<MouseEvent>, List<EventHandler<MouseEvent>>> events = new HashMap<EventType<MouseEvent>, List<EventHandler<MouseEvent>>>();
    private final SimpleBooleanProperty isRounded = new SimpleBooleanProperty((Object)false, "isRounded");
    private final SimpleBooleanProperty isClickScenario = new SimpleBooleanProperty((Object)true, "isClickScenario");
    private final SimpleBooleanProperty isCursorDefaultScenario = new SimpleBooleanProperty((Object)true, "isCursorDefaultScenario");
    private final SimpleIntegerProperty borderRadius = new SimpleIntegerProperty((Object)0, "setBorderRadius");
    private final SimpleIntegerProperty buttonWidth = new SimpleIntegerProperty((Object)10, "buttonWidth");
    private final SimpleIntegerProperty buttonHeight = new SimpleIntegerProperty((Object)10, "buttonHeight");
    private final Image focusedImage = null;
    private final SimpleStringProperty imagePath = new SimpleStringProperty((Object)"transparent", "setImagePath");
    private final SimpleStringProperty backgroundColor = new SimpleStringProperty((Object)"transparent", "backgroundColor");
    private final SimpleStringProperty focusedBackgroundColor = new SimpleStringProperty((Object)"transparent", "focusedBackgroundColor");
    private String baseStyle = "-fx-background-color: " + this.backgroundColor.get() + ";-fx-background-insets: 0 0 0 0;";
    private String focusedBaseStyle;
    private String focusedCustomStyle;
    private boolean isEnableDelay = false;
    private final HBox coverPane = new HBox();
    private final ChangeListener<Number> imageFixWidthListener = (observable, oldValue, newValue) -> {
        if (this.fixImageWidth != -1 && newValue.intValue() != this.fixImageWidth) {
            this.imageViewButton.setFitWidth((double)this.fixImageWidth);
            this.setImageBackgroundWidth(this.fixImageWidth);
        }
    };
    private final ChangeListener<Number> imageFixHeightListener = (observable, oldValue, newValue) -> {
        if (this.fixImageHeight != -1 && newValue.intValue() != this.fixImageHeight) {
            this.imageViewButton.setFitHeight((double)this.fixImageHeight);
            this.setImageBackgroundHeight(this.fixImageHeight);
        }
    };
    private ChangeListener<String> colorListener = (observable, oldValue, newValue) -> {
        if (newValue != null && !newValue.isEmpty()) {
            this.baseStyle = "-fx-background-color: " + newValue + ";-fx-background-insets: 0 0 0 0;";
            this.setStyle(this.baseStyle);
        }
        if (this.isIsRounded()) {
            double radius = (this.getMaxHeight() + this.getMaxWidth()) / 4.0;
            this.setRadius((int)radius);
        }
    };
    private final ChangeListener<String> focusedColorListener = (observable, oldValue, newValue) -> {
        if (newValue != null && !newValue.isEmpty()) {
            this.focusedBaseStyle = "-fx-background-color: " + newValue + ";-fx-background-insets: 0 0 0 0;";
        }
    };
    private ChangeListener<Number> widthListener = (observable, oldValue, newValue) -> {
        if (newValue.doubleValue() > 0.0) {
            this.setMinWidth(newValue.doubleValue());
            this.setMaxWidth(newValue.doubleValue());
        }
    };
    private ChangeListener<Number> heightListener = (observable, oldValue, newValue) -> {
        if (newValue.doubleValue() > 0.0) {
            this.setMinHeight(newValue.doubleValue());
            this.setMaxHeight(newValue.doubleValue());
        }
    };
    private ChangeListener<Number> radiusListener = (observable, oldValue, newValue) -> this.setRadius(newValue.intValue());
    private ChangeListener<Boolean> roundedListener = (observable, oldValue, newValue) -> {
        if (newValue.booleanValue()) {
            double radius = (this.getMaxHeight() + this.getMaxWidth()) / 4.0;
            this.setBorderRadius((int)radius);
        }
    };
    private ChangeListener<Boolean> scenarioListener = (observable, oldValue, newValue) -> this.setMouseCursor((boolean)newValue);
    private EventHandler<MouseEvent> exitEvent = event -> {
        ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
        this.doOnFocus(false);
    };
    private EventHandler<MouseEvent> enteredEvent = event -> {
        ((Node)event.getSource()).setCursor(Cursor.HAND);
        this.doOnFocus(true);
    };
    private EventHandler<MouseEvent> releasedEvent = event -> this.doOnFocus(!this.isReleaseFocusAfterClick);
    private final EventHandler<MouseEvent> clickedEvent = event -> this.makeClick();
    private Tooltip tooltip;

    public void setFixImageWidth(int fixImageWidth) {
        this.fixImageWidth = fixImageWidth;
    }

    public void setFixImageHeight(int fixImageHeight) {
        this.fixImageHeight = fixImageHeight;
    }

    public String getImagePath() {
        return this.imagePath.get();
    }

    public ImageView getImageViewButton() {
        return this.imageViewButton;
    }

    private void setImageBackgroundWidth(int width) {
        this.imageBackground.setMaxWidth((double)width);
        this.imageBackground.setMinWidth((double)width);
        this.imageBackground.setPrefWidth((double)width);
    }

    private void setImageBackgroundHeight(int height) {
        this.imageBackground.setMaxHeight((double)height);
        this.imageBackground.setMinHeight((double)height);
        this.imageBackground.setPrefHeight((double)height);
    }

    public void setFocusedBackgroundColor(String focusedBackgroundColor) {
        this.focusedBackgroundColor.set(focusedBackgroundColor);
    }

    public void setFocusedCustomStyle(String focusedCustomStyle) {
        this.focusedCustomStyle = focusedCustomStyle;
    }

    public ImageButton() {
        this(true);
    }

    public ImageButton(boolean withBackground) {
        this.initPropertiesControls();
        this.setAlignment(Pos.CENTER);
        this.setMouseCursor(true);
        this.setIsCursorDefaultScenario(true);
        this.setIsClickScenario(true);
        if (withBackground) {
            this.setBackgroundColor("white");
        }
        this.getChildren().add((Object)this.imageBackground);
        this.imageBackground.setAlignment(Pos.CENTER);
    }

    public void setClickImages(String[] clkImages) {
        this.setClickImages(clkImages, false);
    }

    public void setClickImages(String[] clkImages, boolean withPressedEvent) {
        this.clickImages = clkImages;
        this.currentClickImage = 0;
        if (withPressedEvent) {
            this.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, this.clickedEvent);
        } else {
            this.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, this.clickedEvent);
        }
        this.setCurrentImage(this.clickImages[this.currentClickImage]);
    }

    public void setSize(int width, int height) {
        this.setButtonWidth(width);
        this.setButtonHeight(height);
    }

    public void setImagePath(String imagePath) {
        this.setImagePath(imagePath, false);
    }

    public void setImagePath(String imagePath, boolean withSize) {
        if (imagePath == null || imagePath.isEmpty()) {
            return;
        }
        this.currentClickImage = 0;
        this.clickImages = new String[1];
        this.clickImages[this.currentClickImage] = imagePath;
        this.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, this.clickedEvent);
        this.setCurrentImage(this.clickImages[this.currentClickImage]);
    }

    public void addMouseEventHandler(EventHandler<MouseEvent> event) {
        this.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, event);
    }

    public void addMouseEventHandler(EventType<MouseEvent> eventEventType, EventHandler<MouseEvent> event) {
        List list = this.events.computeIfAbsent(eventEventType, k -> new ArrayList());
        list.add(event);
        this.imageBackground.addEventHandler(eventEventType, event);
    }

    public void doOnFocus(boolean isFocused) {
        if (this.focusedImage != null) {
            if (isFocused) {
                this.setCurrentImage(this.focusedImage);
            } else {
                this.setCurrentImage(this.clickImages[this.currentClickImage]);
            }
        }
        if (this.focusedCustomStyle != null) {
            if (isFocused) {
                this.imageBackground.setStyle(this.focusedCustomStyle);
            } else {
                this.imageBackground.setStyle(this.baseStyle);
            }
        } else if (this.focusedBaseStyle != null) {
            if (isFocused) {
                this.imageBackground.setStyle(this.focusedBaseStyle);
            } else {
                this.imageBackground.setStyle(this.baseStyle);
            }
        }
    }

    public void setReleaseFocusAfterClick(boolean releaseFocusAfterClick) {
        this.isReleaseFocusAfterClick = releaseFocusAfterClick;
    }

    public void setMouseCursor(boolean mode) {
        if (mode) {
            this.imageBackground.setOnMouseExited(this.exitEvent);
            this.imageBackground.setOnMouseEntered(this.enteredEvent);
            this.imageBackground.setOnMouseReleased(this.releasedEvent);
        } else {
            this.imageBackground.setOnMouseReleased(null);
            this.imageBackground.setOnMouseExited(null);
            this.imageBackground.setOnMouseEntered(null);
        }
    }

    private Background getBackgroundImage(Image image) {
        BackgroundImage backgroundImage = new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, BackgroundSize.DEFAULT);
        return new Background(new BackgroundImage[]{backgroundImage});
    }

    public void setOnMouseExitedEvent(EventHandler<MouseEvent> event) {
        this.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_EXITED, event);
    }

    public void setOnMouseClickedEvent(EventHandler<MouseEvent> event) {
        this.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, event);
    }

    public void setOnMouseReleasedEvent(EventHandler<MouseEvent> event) {
        this.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_RELEASED, event);
    }

    public String getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public SimpleStringProperty backgroundColorProperty() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor.set(backgroundColor);
    }

    private void initPropertiesControls() {
        this.backgroundColor.addListener(this.colorListener);
        this.focusedBackgroundColor.addListener(this.focusedColorListener);
        this.isCursorDefaultScenario.addListener(this.scenarioListener);
        this.buttonWidth.addListener(this.widthListener);
        this.buttonHeight.addListener(this.heightListener);
        this.borderRadius.addListener(this.radiusListener);
        this.isRounded.addListener(this.roundedListener);
    }

    protected void makeClick() {
        if (this.isClickScenario.get() && this.clickImages != null && this.clickImages.length > 1) {
            this.currentClickImage = this.currentClickImage == 0 ? 1 : 0;
            this.setCurrentImage(this.clickImages[this.currentClickImage]);
        }
    }

    protected void makeClick(int index) {
        if (this.isClickScenario.get() && this.clickImages != null && this.clickImages.length > 1) {
            this.currentClickImage = index;
            this.setCurrentImage(this.clickImages[this.currentClickImage]);
        }
    }

    public void setSelectedImage() {
        if (this.clickImages != null) {
            this.currentClickImage = 0;
            this.setCurrentImage(this.clickImages[this.currentClickImage]);
        }
    }

    private void setRadius(int radius) {
        if (radius > 0) {
            this.baseStyle = this.baseStyle + "-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + ";    -fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + ";";
        } else {
            int index = this.baseStyle.indexOf("-fx-border-radius:");
            if (index != -1) {
                this.baseStyle = this.baseStyle.substring(index, this.baseStyle.indexOf(";", index + 1));
            }
        }
        this.setStyle(this.baseStyle);
    }

    public void hideButton() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    public void showButton() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void setIsClickScenario(boolean isClickScenario) {
        this.isClickScenario.set(isClickScenario);
    }

    public boolean isIsRounded() {
        return this.isRounded.get();
    }

    public SimpleBooleanProperty isRoundedProperty() {
        return this.isRounded;
    }

    public void setIsRounded(boolean isRounded) {
        this.isRounded.set(isRounded);
    }

    public SimpleIntegerProperty getBorderRadiusProperty() {
        return this.borderRadius;
    }

    public void setBorderRadius(int borderRadius) {
        this.borderRadius.set(borderRadius);
    }

    public int getButtonWidth() {
        return this.buttonWidth.get();
    }

    public SimpleIntegerProperty buttonWidthProperty() {
        return this.buttonWidth;
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth.set(buttonWidth);
    }

    public int getButtonHeight() {
        return this.buttonHeight.get();
    }

    public SimpleIntegerProperty buttonHeightProperty() {
        return this.buttonHeight;
    }

    public void setButtonHeight(int buttonHeight) {
        this.buttonHeight.set(buttonHeight);
    }

    public boolean isIsCursorDefaultScenario() {
        return this.isCursorDefaultScenario.get();
    }

    public SimpleBooleanProperty isCursorDefaultScenarioProperty() {
        return this.isCursorDefaultScenario;
    }

    public void setIsCursorDefaultScenario(boolean isCursorDefaultScenario) {
        this.isCursorDefaultScenario.set(isCursorDefaultScenario);
    }

    public int getSelectedImage() {
        return this.currentClickImage;
    }

    @Override
    public void onRelease() {
        this.events.forEach((key, event) -> event.forEach(handler -> this.imageBackground.removeEventHandler(key, handler)));
        if (this.imageViewButton != null) {
            this.imageViewButton.fitWidthProperty().removeListener(this.imageFixWidthListener);
            this.imageViewButton.fitHeightProperty().removeListener(this.imageFixHeightListener);
        }
        try {
            this.backgroundColor.removeListener(this.colorListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.isCursorDefaultScenario.removeListener(this.scenarioListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.focusedBackgroundColor.removeListener(this.focusedColorListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.buttonWidth.removeListener(this.widthListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.buttonHeight.removeListener(this.heightListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.borderRadius.removeListener(this.radiusListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.isRounded.removeListener(this.roundedListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.clickedEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exitEvent = null;
        this.releasedEvent = null;
        this.enteredEvent = null;
        this.colorListener = null;
        this.scenarioListener = null;
        this.widthListener = null;
        this.heightListener = null;
        this.radiusListener = null;
        this.roundedListener = null;
        this.imageViewButton = null;
    }

    public void setTooltip(String name) {
        if (this.tooltip == null) {
            this.tooltip = new Tooltip(ClientSingleton.getInstance().getString(name));
            Tooltip.install((Node)this, (Tooltip)this.tooltip);
        } else {
            this.tooltip.setText(ClientSingleton.getInstance().getString(name));
        }
    }

    private void setCurrentImage(String imagePath) {
        try {
            if (this.imageViewButton != null) {
                this.imageViewButton.setOnMouseEntered(null);
                this.imageViewButton.fitWidthProperty().removeListener(this.imageFixWidthListener);
                this.imageViewButton.fitHeightProperty().removeListener(this.imageFixHeightListener);
                this.imageViewButton = null;
            }
            this.imageViewButton = new ImageView();
            this.imageViewButton.fitWidthProperty().addListener(this.imageFixWidthListener);
            this.imageViewButton.fitHeightProperty().addListener(this.imageFixHeightListener);
            ClientSingleton.getInstance().setCachedImage(this.imageViewButton, imagePath);
            TimerExecutor.getInstance().startInGUI(() -> {
                this.imageBackground.getChildren().clear();
                this.imageBackground.getChildren().add((Object)this.imageViewButton);
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void setCurrentImage(Image background) {
        try {
            if (this.imageViewButton != null) {
                this.imageViewButton.setOnMouseEntered(null);
                this.imageViewButton = null;
            }
            this.imageViewButton = new ImageView();
            this.imageViewButton.setImage(background);
            this.imageViewButton.setFitWidth(background.getWidth());
            this.imageViewButton.setFitHeight(background.getHeight());
            this.imageBackground.getChildren().clear();
            this.imageBackground.getChildren().add((Object)this.imageViewButton);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setImageSize(int width, int height) {
        this.imageViewButton.setFitWidth((double)width);
        this.imageViewButton.setFitHeight((double)height);
    }

    public void setEnableDelay() {
        this.isEnableDelay = true;
        this.addMouseEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, (EventHandler<MouseEvent>)((EventHandler)event -> this.addCoverPane(5L)));
    }

    public void addCoverPane() {
        this.addCoverPane(3L);
    }

    private void addCoverPane(long delay) {
        if (!this.getChildren().contains((Object)this.coverPane)) {
            this.getChildren().add((Object)this.coverPane);
        }
        if (this.coverPane.getMaxHeight() != this.getWidth()) {
            this.coverPane.setMaxHeight(this.getWidth());
        }
        double radius = this.getWidth() / 2.0;
        this.coverPane.setStyle("    -fx-background-color: rgba(255,255,255,0.5);\n    -fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + ";\n    -fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + ";\n");
        TimerExecutor.getInstance().setMyAction(() -> this.getChildren().remove((Object)this.coverPane)).startWithDelayInGUIThread(delay * 1000L);
    }

    public boolean canPress() {
        return this.coverPane == null || !this.getChildren().contains((Object)this.coverPane);
    }
}

