/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.buttons.imagebutton;

import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;

public class ImageButtonWithLabel
extends VBox
implements IActionOnRelease {
    private ImageButton imageButton;
    private Label lbTitle;
    private String imagePath;
    private String labelText;
    private EventHandler<MouseEvent> event;
    private String style;

    private ImageButtonWithLabel() {
    }

    public static ImageButtonWithLabel getInstance() {
        return new ImageButtonWithLabel();
    }

    public ImageButtonWithLabel setImagePath(String imagePath) {
        this.imagePath = imagePath;
        return this;
    }

    public ImageButtonWithLabel setLabelText(String labelText) {
        this.labelText = labelText;
        return this;
    }

    public ImageButtonWithLabel setLabelStyle(String style) {
        this.style = style;
        return this;
    }

    public ImageButtonWithLabel addMouseEventHandler(EventHandler<MouseEvent> event) {
        this.event = event;
        return this;
    }

    public void setLabelString(String text) {
        this.lbTitle.setText(text);
    }

    public ImageButtonWithLabel build() {
        this.setAlignment(Pos.CENTER);
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        this.imageButton = new ImageButton();
        this.imageButton.setBackgroundColor("transparent");
        this.imageButton.setSize(20, 22);
        this.imageButton.setImagePath(this.imagePath);
        this.lbTitle = new Label(this.labelText);
        this.lbTitle.prefHeight(22.0);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.lbTitle);
        if (this.style != null) {
            this.lbTitle.setStyle(this.style);
        }
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, this.event);
        this.getChildren().addAll((Object[])new Node[]{this.imageButton, this.lbTitle});
        return this;
    }

    @Override
    public void onRelease() {
        if (this.imageButton != null) {
            this.imageButton.onRelease();
            this.imageButton.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.event);
            this.imageButton = null;
        }
        if (this.lbTitle != null) {
            this.lbTitle.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.event);
            this.lbTitle = null;
        }
        this.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.event);
    }
}

