/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.buttons.imagebutton;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.buttoncombobox.ContextMenuImageButton;

public class ImageButtonWithLabelAndMenu
extends VBox
implements IActionOnRelease {
    private ContextMenuImageButton imageButton;
    private Label lbTitle;
    private String imagePath;
    private String labelText;
    private EventHandler<MouseEvent> event;
    private String style;

    private ImageButtonWithLabelAndMenu() {
    }

    public static ImageButtonWithLabelAndMenu getInstance() {
        return new ImageButtonWithLabelAndMenu();
    }

    public ImageButtonWithLabelAndMenu setImagePath(String imagePath) {
        this.imagePath = imagePath;
        return this;
    }

    public ImageButtonWithLabelAndMenu setLabelText(String labelText) {
        this.labelText = labelText;
        return this;
    }

    public ImageButtonWithLabelAndMenu setLabelStyle(String style) {
        this.style = style;
        return this;
    }

    public ImageButtonWithLabelAndMenu addMouseEventHandler(EventHandler<MouseEvent> event) {
        this.event = event;
        return this;
    }

    public void clearMenu() {
        this.imageButton.clearItems();
    }

    public void setLabelString(String text) {
        this.lbTitle.setText(text);
    }

    public ImageButtonWithLabelAndMenu build() {
        this.setAlignment(Pos.CENTER);
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        this.imageButton = new ContextMenuImageButton();
        this.imageButton.setBackgroundColor("transparent");
        this.imageButton.setSize(20, 22);
        this.imageButton.setImagePath(this.imagePath);
        this.imageButton.setMenuWidth(150);
        this.lbTitle = new Label(this.labelText);
        this.lbTitle.prefHeight(22.0);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.lbTitle);
        if (this.style != null) {
            this.lbTitle.setStyle(this.style);
        }
        this.getChildren().addAll((Object[])new Node[]{this.imageButton, this.lbTitle});
        return this;
    }

    @Override
    public void onRelease() {
        if (this.imageButton != null) {
            this.imageButton.onRelease();
            this.imageButton.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.event);
            this.imageButton = null;
        }
        if (this.lbTitle != null) {
            this.lbTitle.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.event);
            this.lbTitle = null;
        }
        this.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.event);
    }

    public void hideMenu() {
        this.imageButton.hideMenu();
    }

    public void addItemToMenu(Object title, EventHandler<ActionEvent> eventHandler, String color) {
        this.imageButton.addItemToMenu(title, eventHandler, color, title.toString());
    }

    public void addMenuItem(Object title, EventHandler<ActionEvent> eventHandler) {
        this.imageButton.addItemToMenu(title, eventHandler, null);
    }
}

