/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.callStateArrow;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;

public class CallStateArrowPane
extends HBox {
    private final MyImageView arrowImageView;

    private CallStateArrowPane() {
        this.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        this.arrowImageView = MyImageView.getInstance("tab/calls/arrow_inc.png", 10, 10);
        this.getChildren().add((Object)this.arrowImageView);
    }

    public static CallStateArrowPane getInstance() {
        return new CallStateArrowPane();
    }

    public boolean setArrowImageView(LineInfo lineInfo) {
        String arrowPath = MessageInfoCellLabels.getArrowPngPath(lineInfo);
        if (!arrowPath.isEmpty()) {
            this.arrowImageView.setImage(arrowPath);
            return true;
        }
        return false;
    }

    public boolean setLostArrowImageView(MessageInfo messageInfo) {
        boolean isLost = MessageInfoCellLabels.isLostCall(messageInfo);
        if (isLost) {
            this.arrowImageView.setImage(MessageInfoCellLabels.getArrowPngPath(messageInfo, isLost));
            return true;
        }
        return false;
    }

    public void setArrowImageView(MessageInfo messageInfo, boolean isLost) {
        this.arrowImageView.setImage(MessageInfoCellLabels.getArrowPngPath(messageInfo, isLost));
    }
}

