/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.checkbox;

import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import net.sipsnet.client.utils.viewers.IActionOnRelease;

public class MyCheckBox
extends Pane
implements IActionOnRelease {
    private SimpleIntegerProperty buttonWidth = new SimpleIntegerProperty((Object)10, "buttonWidth");
    private SimpleIntegerProperty buttonHeight = new SimpleIntegerProperty((Object)10, "buttonHeight");
    private SimpleStringProperty backgroundColor = new SimpleStringProperty((Object)"white", "backgroundColor");
    private final int radius = 20;
    private HBox button = null;
    private final CheckBox checkBox;
    private final String baseStyle = "-fx-background-color: " + this.backgroundColor + ";-fx-background-insets: 0 0 0 0;-fx-border-radius: 20 20 20 20;-fx-background-radius: 20 20 20 20;";
    private final ChangeListener<Number> buttonHeightListener = (observable, oldValue, newValue) -> {
        if (newValue.intValue() > 0) {
            this.button.setMinHeight(newValue.doubleValue());
            this.button.setMaxHeight(newValue.doubleValue());
        }
    };
    private final ChangeListener<Number> buttonWidthListener = (observable, oldValue, newValue) -> {
        if (newValue.intValue() > 0) {
            this.button.setMinWidth(newValue.doubleValue());
            this.button.setMaxWidth(newValue.doubleValue());
        }
    };
    private final ChangeListener<String> colorListener = (observable, oldValue, newValue) -> this.setSelection(false);

    public MyCheckBox() {
        this.initPropertiesControls();
        this.button = new HBox();
        this.button.setAlignment(Pos.CENTER);
        this.checkBox = new CheckBox();
        this.button.getChildren().add((Object)this.checkBox);
        this.getChildren().add((Object)this.button);
        this.checkBox.getStylesheets().add((Object)this.getClass().getResource("/fxml/utils/checkbox.css").toExternalForm());
        this.setMouseCursor();
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    private void initPropertiesControls() {
        this.backgroundColor.addListener(this.colorListener);
        this.buttonWidth.addListener(this.buttonWidthListener);
        this.buttonHeight.addListener(this.buttonHeightListener);
    }

    public void addListener(ChangeListener<Boolean> changeListener) {
        this.checkBox.selectedProperty().addListener(changeListener);
    }

    public void setSize(int width, int height) {
        this.setButtonWidth(width);
        this.setButtonHeight(height);
    }

    private void setMouseCursor() {
        this.button.setOnMouseExited(event -> {
            ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
            this.setSelection(false);
        });
        this.button.setOnMouseEntered(event -> {
            ((Node)event.getSource()).setCursor(Cursor.HAND);
            this.setSelection(true);
        });
    }

    public void setSelection(boolean mode) {
        this.button.setStyle(this.baseStyle + (mode ? "-fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.16), 4, 0, 0, 0);" : ""));
    }

    public int getButtonWidth() {
        return this.buttonWidth.get();
    }

    public SimpleIntegerProperty buttonWidthProperty() {
        return this.buttonWidth;
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth.set(buttonWidth);
    }

    public int getButtonHeight() {
        return this.buttonHeight.get();
    }

    public SimpleIntegerProperty buttonHeightProperty() {
        return this.buttonHeight;
    }

    public void setButtonHeight(int buttonHeight) {
        this.buttonHeight.set(buttonHeight);
    }

    public String getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public SimpleStringProperty backgroundColorProperty() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor.set(backgroundColor);
    }

    @Override
    public void onRelease() {
        this.button.setOnMouseExited(null);
        this.button.setOnMouseEntered(null);
        this.backgroundColor.removeListener(this.colorListener);
        this.buttonWidth.removeListener(this.buttonWidthListener);
        this.buttonHeight.removeListener(this.buttonHeightListener);
        this.backgroundColor = null;
        this.buttonWidth = null;
        this.buttonHeight = null;
    }
}

